/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.util;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.qther.ars_controle.mixin.LevelRendererInvoker;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class RenderUtil {
    private static final RenderType BLOCK_OUTLINE = RenderType.create((String)"ars_controle_block_outline", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)1536, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.OUTLINE_TARGET).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));

    public static void renderBlockOutline(RenderLevelStageEvent event, BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        VoxelShape shape = level.isLoaded(pos) ? level.getBlockState(pos).getShape((BlockGetter)level, pos) : Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        Vec3 projectedView = mc.gameRenderer.getMainCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        OutlineBufferSource buffer = mc.renderBuffers().outlineBufferSource();
        VertexConsumer builder = buffer.getBuffer(BLOCK_OUTLINE);
        ParticleColor color = ParticleColor.defaultParticleColor();
        LevelRendererInvoker.invokeRenderShape(poseStack, builder, shape, 0.0, 0.0, 0.0, color.getRed(), color.getGreen(), color.getBlue(), 1.0f);
        poseStack.popPose();
    }

    public static void renderAABBOutline(RenderLevelStageEvent event, AABB aabb) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        VoxelShape shape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)aabb.getXsize(), (double)aabb.getYsize(), (double)aabb.getZsize());
        Vec3 projectedView = mc.gameRenderer.getMainCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
        poseStack.translate(aabb.minX, aabb.minY, aabb.minZ);
        OutlineBufferSource buffer = mc.renderBuffers().outlineBufferSource();
        VertexConsumer builder = buffer.getBuffer(BLOCK_OUTLINE);
        ParticleColor color = new ParticleColor(22, 216, 50);
        LevelRendererInvoker.invokeRenderShape(poseStack, builder, shape, 0.0, 0.0, 0.0, color.getRed(), color.getGreen(), color.getBlue(), 1.0f);
        poseStack.popPose();
    }
}

