/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.spell.filter;

import com.hollingsworth.arsnouveau.api.spell.AbstractFilter;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.registry.ACNames;
import dev.qther.ars_controle.spell.filter.FilterRandom;
import dev.qther.ars_controle.spell.filter.FilterYLevel;
import dev.qther.ars_controle.spell.filter.IAdaptiveFilter;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterBinary
extends AbstractFilter
implements IAdaptiveFilter {
    public static final FilterBinary OR = new FilterBinary(ACNames.GLYPH_FILTER_OR, "Filter: OR", "Only resolves the spell if any of the next 2 Filters are true.", (a, b) -> (Boolean)a.get() != false || (Boolean)b.get() != false);
    public static final FilterBinary XOR = new FilterBinary(ACNames.GLYPH_FILTER_XOR, "Filter: XOR", "Only resolves the spell if only one of the next 2 Filters are true.", (a, b) -> a.get() != b.get());
    public static final FilterBinary XNOR = new FilterBinary(ACNames.GLYPH_FILTER_XNOR, "Filter: XNOR", "Only resolves the spell if the result of both the next 2 Filters are equal.", (a, b) -> a.get() == b.get());
    private final BiFunction<Supplier<Boolean>, Supplier<Boolean>, Boolean> op;
    public SpellResolver res;
    private final String bookDescription;

    private FilterBinary(String id, String name, String bookDescription, BiFunction<Supplier<Boolean>, Supplier<Boolean>, Boolean> op) {
        super(ArsControle.prefix(id), name);
        this.op = op;
        this.bookDescription = bookDescription;
    }

    public String getBookDescription() {
        return this.bookDescription;
    }

    public Integer getTypeIndex() {
        return 15;
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.res = resolver;
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.res = resolver;
        super.onResolveBlock(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public boolean shouldResolveOnBlock(BlockHitResult target, Level level) {
        if (this.res == null || level.isClientSide) {
            return false;
        }
        Pair<Integer, Pair<IFilter, IFilter>> f = this.getFilters();
        if (f == null) {
            return false;
        }
        Pair filters = (Pair)f.second();
        int idx = this.res.spellContext.getCurrentIndex();
        this.res.spellContext.setCurrentIndex(idx + (Integer)f.first());
        try {
            return this.op.apply(() -> ((IFilter)filters.first()).shouldResolveOnBlock(target, level), () -> ((IFilter)filters.second()).shouldResolveOnBlock(target, level));
        }
        catch (Exception e) {
            LivingEntity livingEntity = this.res.spellContext.getUnwrappedCaster();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_controle.glyph.error.generic.error_at_position", (Object[])new Object[]{Component.translatable((String)this.getLocalizationKey()), idx}));
            }
            ArsControle.LOGGER.error("Failed to resolve binary filter", (Throwable)e);
            return false;
        }
    }

    public boolean shouldResolveOnEntity(EntityHitResult target, Level level) {
        if (this.res == null || level.isClientSide) {
            return false;
        }
        Pair<Integer, Pair<IFilter, IFilter>> f = this.getFilters();
        if (f == null) {
            return false;
        }
        Pair filters = (Pair)f.second();
        int idx = this.res.spellContext.getCurrentIndex();
        this.res.spellContext.setCurrentIndex(idx + (Integer)f.first());
        try {
            return this.op.apply(() -> ((IFilter)filters.first()).shouldResolveOnEntity(target, level), () -> ((IFilter)filters.second()).shouldResolveOnEntity(target, level));
        }
        catch (Exception e) {
            LivingEntity livingEntity = this.res.spellContext.getUnwrappedCaster();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_controle.glyph.error.generic.error_at_position", (Object[])new Object[]{Component.translatable((String)this.getLocalizationKey()), idx}));
            }
            ArsControle.LOGGER.error("Failed to resolve binary filter", (Throwable)e);
            return false;
        }
    }

    @Nullable
    public Pair<Integer, Pair<IFilter, IFilter>> getFilters() {
        int idx = this.res.spellContext.getCurrentIndex();
        Spell spell = this.res.spell;
        LivingEntity caster = this.res.spellContext.getUnwrappedCaster();
        if (spell.size() < idx + 2) {
            return null;
        }
        AbstractSpellPart fst = spell.get(idx);
        if (!(fst instanceof IFilter)) {
            return null;
        }
        IFilter afst = (IFilter)fst;
        List firstAugments = spell.getAugments(idx, caster);
        int skip = firstAugments.size() + 1;
        AbstractSpellPart snd = spell.get(idx + skip);
        if (!(snd instanceof IFilter)) {
            return null;
        }
        IFilter asnd = (IFilter)snd;
        if (fst instanceof FilterYLevel) {
            FilterYLevel yfst = (FilterYLevel)fst;
            yfst.y = (int)(this.res.spellContext.getCaster().getPosition().y - 1.0);
        }
        if (snd instanceof FilterYLevel) {
            FilterYLevel ysnd = (FilterYLevel)snd;
            ysnd.y = (int)(this.res.spellContext.getCaster().getPosition().y - 1.0);
        }
        if (fst instanceof FilterRandom) {
            FilterRandom rfst = (FilterRandom)fst;
            SpellContext newCtx = this.res.spellContext.makeChildContext();
            SpellResolver newRes = this.res.getNewResolver(newCtx);
            SpellStats stats = new SpellStats.Builder().setAugments(firstAugments).addItemsFromEntity(caster).build((AbstractSpellPart)rfst, newRes.hitResult, caster.level(), caster, newCtx);
            rfst.chance = FilterRandom.calculateChance(stats.getAmpMultiplier());
        }
        if (snd instanceof FilterRandom) {
            FilterRandom rsnd = (FilterRandom)snd;
            List augments = spell.getAugments(idx, caster);
            SpellContext newCtx = this.res.spellContext.makeChildContext();
            SpellResolver newRes = this.res.getNewResolver(newCtx);
            SpellStats stats = new SpellStats.Builder().setAugments(augments).addItemsFromEntity(caster).build((AbstractSpellPart)rsnd, newRes.hitResult, caster.level(), caster, newCtx);
            rsnd.chance = FilterRandom.calculateChance(stats.getAmpMultiplier());
        }
        return Pair.of((Object)(skip + 1), (Object)Pair.of((Object)afst, (Object)asnd));
    }
}

