/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block.tile;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.block.tile.IDimensionalHighlighter;
import dev.qther.ars_controle.datagen.ACBlockTagProvider;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.Cached;
import it.unimi.dsi.fastutil.Pair;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScryersLinkageTile
extends ModdedTile
implements IWandable,
IDimensionalHighlighter {
    private Cache<Query, BlockCapabilityCache<Object, @Nullable Object>> CAPABILITY_CACHES = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).build();

    public ScryersLinkageTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACRegistry.Tiles.SCRYERS_LINKAGE.get(), pos, state);
    }

    private void migrateOldData(CompoundTag data) {
        if (!data.isEmpty() && data.contains("block", 4) && data.contains("dimension", 8)) {
            long block = data.getLong("block");
            String dimension = data.getString("dimension");
            ServerLevel level = Cached.getLevelByName(dimension);
            if (level == null) {
                ArsControle.LOGGER.warn("Could not migrate old Scryer Linkage data linked to {} in {}", (Object)BlockPos.of((long)block).toShortString(), (Object)dimension);
                return;
            }
            this.setBlock(level, BlockPos.of((long)block));
            data.remove("block");
            data.remove("dimension");
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.migrateOldData(this.getPersistentData());
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag data = this.getPersistentData();
        super.saveAdditional(tag, registries);
    }

    @Nullable
    public GlobalPos getTarget() {
        return this.getExistingData(ACRegistry.Attachments.GLOBAL_POS_TARGET).orElse(null);
    }

    @Nullable
    public Pair<ServerLevel, BlockPos> getTargetInfo() {
        GlobalPos pos = this.getTarget();
        if (pos == null) {
            return null;
        }
        ServerLevel level = Cached.getLevelByKey((ResourceKey<Level>)pos.dimension());
        if (level == null) {
            return null;
        }
        return Pair.of((Object)level, (Object)pos.pos());
    }

    public boolean hasTarget() {
        return this.hasData(ACRegistry.Attachments.GLOBAL_POS_TARGET);
    }

    public boolean setBlock(@NotNull ServerLevel level, @NotNull BlockPos block) {
        this.CAPABILITY_CACHES.invalidateAll();
        Level thisLevel = this.getLevel();
        if (thisLevel == null) {
            return false;
        }
        BlockState target = level.getBlockState(block);
        if (BuiltInRegistries.BLOCK.wrapAsHolder((Object)target.getBlock()).is(ACBlockTagProvider.SCRYERS_LINKAGE_BLACKLIST)) {
            return false;
        }
        this.setData(ACRegistry.Attachments.GLOBAL_POS_TARGET, new GlobalPos(level.dimension(), block));
        this.notifyChange();
        return true;
    }

    public void removeBlock() {
        this.CAPABILITY_CACHES.invalidateAll();
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.removeData(ACRegistry.Attachments.GLOBAL_POS_TARGET);
        this.notifyChange();
    }

    private void notifyChange() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.setChanged();
        this.invalidateCapabilities();
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getBlockState();
        Block thisBlock = state.getBlock();
        level.updateNeighborsAt(pos, thisBlock);
        level.updateNeighbourForOutputSignal(pos, thisBlock);
        state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
    }

    @Nullable
    private ServerLevel getTargetLevel() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel level2 = (ServerLevel)level;
        GlobalPos target = this.getTarget();
        if (target == null) {
            return null;
        }
        if (level2.dimension().equals(target.dimension())) {
            return level2;
        }
        return Cached.getLevelByKey((ResourceKey<Level>)target.dimension());
    }

    @Nullable
    private BlockPos getTargetBlock() {
        if (this.level == null) {
            return null;
        }
        GlobalPos target = this.getTarget();
        if (target == null) {
            return null;
        }
        return target.pos();
    }

    public IWandable.Result onLastConnection(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return IWandable.Result.FAIL;
        }
        if (storedPos == null) {
            return IWandable.Result.FAIL;
        }
        ServerLevel level = Cached.getLevelByKey((ResourceKey<Level>)storedPos.dimension());
        if (level == null) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_dimension"));
            return IWandable.Result.FAIL;
        }
        if (!this.setBlock(level, storedPos.pos())) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_target"));
            return IWandable.Result.FAIL;
        }
        PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.pos().toShortString(), level.dimension().location().toString()}));
        return IWandable.Result.SUCCESS;
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        Level level;
        if (storedPos != null && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.setBlock(serverLevel, storedPos)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.toShortString(), serverLevel.dimension().location().toString()}));
            } else {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_target"));
            }
        }
    }

    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        BlockPos target = this.getTargetBlock();
        if (target != null) {
            list.add(ColorPos.centered((BlockPos)target));
        }
        return list;
    }

    @Override
    public List<ColorPos> getWandHighlight(Level level, List<ColorPos> list) {
        Pair<ServerLevel, BlockPos> target = this.getTargetInfo();
        if (target != null && target.first() == level) {
            list.add(ColorPos.centered((BlockPos)((BlockPos)target.second())));
        }
        return list;
    }

    @Nullable
    public <T, C> T getCapability(BlockCapability<T, C> cap, C context) {
        Pair<ServerLevel, BlockPos> info = this.getTargetInfo();
        if (info == null) {
            return null;
        }
        try {
            BlockCapability erased = cap;
            Query key = new Query(erased, context);
            BlockCapabilityCache value = (BlockCapabilityCache)this.CAPABILITY_CACHES.get((Object)key, () -> BlockCapabilityCache.create((BlockCapability)erased, (ServerLevel)((ServerLevel)info.first()), (BlockPos)((BlockPos)info.second()), (Object)context));
            return (T)value.getCapability();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public record Query(BlockCapability<Object, @Nullable Object> cap, @Nullable Object context) {
    }
}

