/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.compat.jei;

import cy.jdkdigital.treetap.TreeTap;
import cy.jdkdigital.treetap.common.recipe.TapExtractRecipe;
import cy.jdkdigital.treetap.compat.jei.TapExtractRecipeCategory;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public class TreeTapJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"treetap", (String)"treetap");
    public static final RecipeType<TapExtractRecipe> TAP_EXTRACT_TYPE = RecipeType.create((String)"treetap", (String)"tap_extract", TapExtractRecipe.class);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        Arrays.stream(Ingredient.of(TreeTap.TAPS).getItems()).forEach(itemStack -> registration.addRecipeCatalyst(itemStack, new RecipeType[]{TAP_EXTRACT_TYPE}));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new TapExtractRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List bottlerRecipeMap = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)TreeTap.TAP_RECIPE_TYPE.get());
        registration.addRecipes(TAP_EXTRACT_TYPE, bottlerRecipeMap.stream().map(RecipeHolder::value).toList());
    }
}

