/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.augmenter.AugmentApplicationBlock;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PortalEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int age = 0;
    public GlobalPos target;
    protected static final RawAnimation PORTAL = RawAnimation.begin().thenPlay("create").thenLoop("idle");

    public PortalEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void playerTouch(Player player) {
        if (this.level().isClientSide) {
            return;
        }
        if (this.target != null) {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel targetWorld = this.getServer().getLevel(this.target.dimension());
            if (targetWorld != null) {
                BlockPos targetPos = this.target.pos();
                Vec3 centerPos = targetPos.getCenter();
                AugmentApplicationBlock.lastTeleportedPlayer = new Tuple((Object)targetWorld.getGameTime(), (Object)serverPlayer);
                serverPlayer.teleportTo(targetWorld, centerPos.x, centerPos.y, centerPos.z, serverPlayer.getYRot(), serverPlayer.getXRot());
            } else {
                Oritech.LOGGER.warn("Attempted to teleport player to non-existent dimension: {}", (Object)this.target.dimension().location());
            }
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void tick() {
        Level world = this.level();
        if (world.isClientSide) {
            return;
        }
        ++this.tickCount;
        if (this.tickCount > 100) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(PORTAL)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }
}

