/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.harvesting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dev.architectury.event.EventResult;
import dev.architectury.utils.value.IntValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.client.renderers.PromethiumToolRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.ToolsContent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PromethiumPickaxeItem
extends DiggerItem
implements GeoItem {
    private static final RawAnimation AREA_ANIM = RawAnimation.begin().thenLoop("area");
    private static final RawAnimation SILK_ANIM = RawAnimation.begin().thenLoop("silk_touch");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PromethiumPickaxeItem(Tier toolMaterial, TagKey<Block> effectiveBlocks, Item.Properties settings) {
        super(toolMaterial, effectiveBlocks, settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (!world.isClientSide && stack.has(DataComponents.INTANGIBLE_PROJECTILE)) {
            ItemEnchantments enchantments = stack.getEnchantments();
            ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(enchantments);
            builder.removeIf(elem -> elem.is(Enchantments.SILK_TOUCH));
            stack.set(DataComponents.ENCHANTMENTS, (Object)builder.toImmutable());
            stack.remove(DataComponents.INTANGIBLE_PROJECTILE);
        }
        return true;
    }

    private static boolean isAreaEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault((DataComponentType)ComponentContent.IS_AOE_ACTIVE.get(), (Object)false);
    }

    private static void setAreaEnabled(ItemStack stack, boolean enabled) {
        stack.set((DataComponentType)ComponentContent.IS_AOE_ACTIVE.get(), (Object)enabled);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!world.isClientSide && user.isShiftKeyDown()) {
            ItemStack stack = user.getItemInHand(hand);
            boolean wasArea = PromethiumPickaxeItem.isAreaEnabled(stack);
            boolean isArea = !wasArea;
            PromethiumPickaxeItem.setAreaEnabled(stack, isArea);
            user.sendSystemMessage((Component)(isArea ? Component.translatable((String)"message.oritech.tool_mode.area_effect") : Component.translatable((String)"message.oritech.tool_mode.silk_touch")));
        }
        return super.use(world, user, hand);
    }

    public static List<BlockPos> getOffsetBlocks(Level world, Player player, BlockPos pos) {
        ItemStack handStack = player.getMainHandItem();
        if (handStack == null || !handStack.is(ToolsContent.PROMETHIUM_PICKAXE)) {
            return List.of();
        }
        if (PromethiumPickaxeItem.isAreaEnabled(handStack) && !player.isShiftKeyDown()) {
            ArrayList<BlockPos> breakBlocks = new ArrayList<BlockPos>();
            HitResult playerHit = player.pick(player.blockInteractionRange(), 0.0f, false);
            if (playerHit instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)playerHit;
                Direction blockSide = blockHit.getDirection();
                Direction perpA = Direction.EAST;
                Direction perpB = Direction.NORTH;
                if (blockSide.equals((Object)Direction.NORTH) || blockSide.equals((Object)Direction.SOUTH)) {
                    perpA = Direction.UP;
                    perpB = Direction.EAST;
                } else if (blockSide.equals((Object)Direction.EAST) || blockSide.equals((Object)Direction.WEST)) {
                    perpA = Direction.UP;
                    perpB = Direction.NORTH;
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0) continue;
                        BlockPos neighborPos = pos.offset(perpA.getNormal().multiply(x)).offset(perpB.getNormal().multiply(z));
                        breakBlocks.add(neighborPos);
                    }
                }
                return ImmutableList.copyOf((Iterable)Iterables.filter(breakBlocks, p -> world.getBlockState(p).is(TagContent.DRILL_MINEABLE)));
            }
        }
        return List.of();
    }

    public static EventResult preMine(Level world, BlockPos pos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        ItemStack handStack = player.getMainHandItem();
        if (handStack == null || !handStack.is(ToolsContent.PROMETHIUM_PICKAXE)) {
            return EventResult.pass();
        }
        if (PromethiumPickaxeItem.isAreaEnabled(handStack)) {
            for (BlockPos offsetPos : PromethiumPickaxeItem.getOffsetBlocks(world, (Player)player, pos)) {
                BlockState offsetState = world.getBlockState(offsetPos);
                BlockEntity offsetEntity = world.getBlockEntity(offsetPos);
                Block.dropResources((BlockState)offsetState, (Level)world, (BlockPos)offsetPos, (BlockEntity)offsetEntity, (Entity)player, (ItemStack)handStack);
                offsetState.getBlock().playerWillDestroy(world, offsetPos, offsetState, (Player)player);
                world.destroyBlock(offsetPos, false, (Entity)player);
            }
        } else {
            boolean hasExistingSilkTouch = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)handStack).keySet().stream().anyMatch(elem -> elem.is(Enchantments.SILK_TOUCH));
            if (!hasExistingSilkTouch) {
                Holder.Reference registryEntry = (Holder.Reference)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.SILK_TOUCH).get();
                handStack.enchant((Holder)registryEntry, 1);
                handStack.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
            }
        }
        return EventResult.pass();
    }

    public static ItemAttributeModifiers createPromethiumAttributes(Tier tier, float attackDamage, float attackSpeed, float range) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(attackDamage + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(Oritech.id("pick_block_range"), (double)range, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Oritech.id("pick_entity_range"), (double)range, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        boolean area = PromethiumPickaxeItem.isAreaEnabled(stack);
        tooltip.add((Component)(area ? Component.translatable((String)"tooltip.oritech.tool_mode.area_range.area") : Component.translatable((String)"tooltip.oritech.tool_mode.area_range.single")).withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.promethium_pick").withStyle(ChatFormatting.DARK_GRAY));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PromethiumToolRenderer renderer;

            @Nullable
            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PromethiumToolRenderer("promethium_pickaxe");
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Pickaxe", 5, state -> PlayState.CONTINUE).triggerableAnim("silk", SILK_ANIM).triggerableAnim("area", AREA_ANIM));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void onHeldTick(ItemStack stack, Player player, ClientLevel world) {
        if (world.getGameTime() % 20L != 0L) {
            return;
        }
        boolean area = PromethiumPickaxeItem.isAreaEnabled(stack);
        this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "Pickaxe", area ? "area" : "silk");
    }
}

