/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.other;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.MultiblockMachineController;

public class ColorCartridgeItem
extends Item {
    public final ColorableMachine.ColorVariant variant;

    public ColorCartridgeItem(Item.Properties properties, ColorableMachine.ColorVariant variant) {
        super(properties);
        this.variant = variant;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.oritech.paint.1").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.oritech.paint.2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        MachineCoreEntity machineCore;
        if (context.getLevel().isClientSide()) {
            return super.useOn(context);
        }
        BlockPos targetBlock = context.getClickedPos();
        BlockEntity targetEntity = context.getLevel().getBlockEntity(targetBlock);
        if (targetEntity instanceof MachineCoreEntity && (machineCore = (MachineCoreEntity)targetEntity).getCachedController() != null) {
            targetEntity = (BlockEntity)machineCore.getCachedController();
            targetBlock = targetEntity.getBlockPos();
        }
        if (targetEntity instanceof ColorableMachine) {
            ColorableMachine colorableMachine = (ColorableMachine)targetEntity;
            if (colorableMachine.getCurrentColor().equals((Object)this.variant)) {
                return super.useOn(context);
            }
            Oritech.LOGGER.info("assigning color {} to {}", (Object)this.variant, (Object)targetBlock);
            colorableMachine.assignColor(this.variant);
            ItemStack stack = context.getItemInHand();
            stack.shrink(1);
            context.getPlayer().setItemInHand(context.getHand(), stack);
            context.getLevel().playSound(null, targetBlock, SoundEvents.AXOLOTL_SPLASH, SoundSource.PLAYERS, 1.0f, 0.6f);
            ArrayList<BlockPos> targetBlocks = new ArrayList<BlockPos>();
            targetBlocks.add(targetBlock);
            if (targetEntity instanceof MultiblockMachineController) {
                MultiblockMachineController multiblockMachineController = (MultiblockMachineController)targetEntity;
                targetBlocks.addAll(multiblockMachineController.getConnectedCores());
            }
            Level level = context.getLevel();
            Level level2 = context.getLevel();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                for (BlockPos pos : targetBlocks) {
                    Vec3 at = pos.getCenter().add((double)level.random.nextFloat() * 0.1, (double)level.random.nextFloat() * 0.1, (double)level.random.nextFloat() * 0.1);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.GUST, at.x, at.y, at.z, 1, (double)level.random.nextFloat(), (double)level.random.nextFloat(), (double)level.random.nextFloat(), (double)0.15f);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }
}

