/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.client.renderers.MachineModel;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;

public class LaserArmModel<T extends LaserArmBlockEntity>
extends MachineModel<T> {
    private static final HashMap<Long, ModelRenderData> additionalData = new HashMap();
    private static final HashMap<Long, Vec3> drillOffsets = new HashMap();
    private Vec3 lastActivePlayerPos = Vec3.ZERO;

    public LaserArmModel(String subpath) {
        super(subpath);
    }

    private ModelRenderData getById(long id) {
        return additionalData.computeIfAbsent(id, s -> new ModelRenderData(0.0f, 0.0f, this.getAnimationProcessor().getBone("pivotX"), this.getAnimationProcessor().getBone("pivotY")));
    }

    private Vec3 getOffsetByDrillId(long id, T laserEntity) {
        return drillOffsets.computeIfAbsent(id, s -> {
            Direction drillFacing = (Direction)laserEntity.getLevel().getBlockState(laserEntity.getCurrentTarget()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            return Geometry.rotatePosition(new Vec3(1.0, 1.4, 0.0), drillFacing);
        });
    }

    public void setCustomAnimations(T laserEntity, long instanceId, AnimationState<T> animationState) {
        Vec3 target;
        boolean isIdle = false;
        if (((LaserArmBlockEntity)laserEntity).getCurrentTarget() == null || ((LaserArmBlockEntity)laserEntity).getCurrentTarget().closerThan((Vec3i)BlockPos.ZERO, (double)0.1f)) {
            target = this.getIdleTarget(laserEntity);
            isIdle = true;
        } else {
            target = ((LaserArmBlockEntity)laserEntity).getVisualTarget();
        }
        if (target == null || target == Vec3.ZERO) {
            return;
        }
        Block targetBlock = laserEntity.getLevel().getBlockState(((LaserArmBlockEntity)laserEntity).getCurrentTarget()).getBlock();
        Vec3 startPos = ((LaserArmBlockEntity)laserEntity).laserHead;
        if (((LaserArmBlockEntity)laserEntity).isTargetingAtomicForge(targetBlock)) {
            double moveX = 0.5;
            double moveZ = 0.5;
            if (startPos.x < target.x) {
                moveX = -0.5;
            }
            if (startPos.z < target.z) {
                moveZ = -0.5;
            }
            target = target.add(moveX, 0.2, moveZ);
        } else if (!isIdle && ((LaserArmBlockEntity)laserEntity).isTargetingDeepdrill(laserEntity.getLevel().getBlockState(((LaserArmBlockEntity)laserEntity).getCurrentTarget()).getBlock())) {
            long drillId = ((LaserArmBlockEntity)laserEntity).getCurrentTarget().asLong();
            Vec3 offset = this.getOffsetByDrillId(drillId, laserEntity);
            target = target.add(offset);
        }
        Vec3 ownPos = ((LaserArmBlockEntity)laserEntity).laserHead;
        Direction facing = (Direction)laserEntity.getBlockState().getValue((Property)BlockStateProperties.FACING);
        Vec3 offset = Geometry.worldToOffsetPosition(facing, target, ownPos);
        Vector2f offsetY = new Vector2f((float)offset.x(), (float)offset.y());
        Vector2f forwardY = new Vector2f(0.0f, -1.0f);
        if (facing == Direction.NORTH) {
            forwardY = new Vector2f(0.0f, 1.0f);
        }
        if (facing == Direction.WEST) {
            forwardY = new Vector2f(1.0f, 0.0f);
        }
        if (facing == Direction.EAST) {
            forwardY = new Vector2f(-1.0f, 0.0f);
        }
        float angleY = -offsetY.angle((Vector2fc)forwardY);
        float lengthY = offsetY.length();
        double heightDiff = offset.z();
        Vector2f offsetX = new Vector2f(lengthY, (float)heightDiff);
        Vector2f forwardX = new Vector2f(0.0f, 1.0f);
        float detX = LaserArmModel.determinant(offsetX, forwardX);
        float dotX = offsetX.dot((Vector2fc)forwardX);
        double angleX = Math.atan2(detX, dotX);
        angleX -= 0.8290313882753253;
        ModelRenderData data = this.getById(instanceId);
        if (data.boneX != null) {
            float newRotY = LaserArmModel.lerp(data.angleY, angleY, 0.06f);
            float newRotX = LaserArmModel.lerp(data.angleX, (float)angleX, 0.06f);
            data.boneY.setRotY(newRotY);
            data.boneX.setRotX(newRotX);
            data.angleY = newRotY;
            data.angleX = newRotX;
        }
    }

    private Vec3 getIdleTarget(T entity) {
        Vec3 offsetA = new Vec3(0.0, Math.pow(Math.sin((float)entity.getLevel().getGameTime() / 40.0f), 3.0), 0.0);
        Vec3 offsetB = new Vec3(Math.pow(Math.sin((float)entity.getLevel().getGameTime() / 40.0f + 1.3f), 3.0), 0.0, 0.0);
        if (entity.getLevel().getRandom().nextFloat() > 0.9f) {
            this.lastActivePlayerPos = Minecraft.getInstance().player.getEyePosition();
        }
        if (this.lastActivePlayerPos.equals((Object)Vec3.ZERO)) {
            return Vec3.ZERO;
        }
        return this.lastActivePlayerPos.add(offsetA).add(offsetB);
    }

    public static float lerp(float a, float b, float f) {
        if (Math.abs(b - a) > 6.108652f) {
            return b;
        }
        return a + f * (b - a);
    }

    public static float determinant(Vector2f a, Vector2f b) {
        return a.x * b.y - a.y * b.x;
    }

    private static class ModelRenderData {
        protected float angleY;
        protected float angleX;
        protected GeoBone boneX;
        protected GeoBone boneY;

        public ModelRenderData(float angleX, float angleY, GeoBone boneX, GeoBone boneY) {
            this.angleY = angleY;
            this.angleX = angleX;
            this.boneX = boneX;
            this.boneY = boneY;
        }
    }
}

