/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.LaserArmRenderer;
import rearth.oritech.client.renderers.util.BeamRenderer;

public class AcceleratorControllerRenderer
implements BlockEntityRenderer<AcceleratorControllerBlockEntity> {
    private final Map<Long, RenderedLine> activeLines = new HashMap<Long, RenderedLine>();

    public int getViewDistance() {
        return 128;
    }

    public boolean shouldRenderOffScreen(AcceleratorControllerBlockEntity blockEntity) {
        return true;
    }

    public void render(AcceleratorControllerBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity.displayTrail == null) {
            this.activeLines.remove(entity.getBlockPos().asLong());
            return;
        }
        float time = (float)entity.getLevel().getGameTime() + tickDelta;
        List<Vec3> displayTrail = entity.displayTrail;
        if (!this.activeLines.containsKey(entity.getBlockPos().asLong()) || !this.activeLines.get((Object)Long.valueOf((long)entity.getBlockPos().asLong())).positions.equals(displayTrail)) {
            this.activeLines.put(entity.getBlockPos().asLong(), new RenderedLine(time, displayTrail));
            ParticleContent.PARTICLE_MOVING.spawn(entity.getLevel(), displayTrail.getLast());
        }
        RenderedLine activeLine = this.activeLines.get(entity.getBlockPos().asLong());
        List<Vec3> line = activeLine.positions;
        float age = time - activeLine.startedAt;
        if (age >= 60.0f && entity.displayTrail.equals(activeLine.positions)) {
            entity.displayTrail = null;
        }
        Vec3 bePos = Vec3.atLowerCornerOf((Vec3i)entity.getBlockPos());
        float baseThickness = 0.07f;
        VertexConsumer beamConsumer = vertexConsumers.getBuffer(RenderType.eyes((ResourceLocation)LaserArmRenderer.BEAM_TEXTURE));
        for (int i = 0; i < line.size() - 1; ++i) {
            Vec3 pointCurrent = line.get(i);
            Vec3 pointNext = line.get(i + 1);
            Vec3 startLocal = pointCurrent.subtract(bePos);
            Vec3 endLocal = pointNext.subtract(bePos);
            Vec3 delta = endLocal.subtract(startLocal);
            BeamRenderer.renderStraightBeam(matrices, beamConsumer, startLocal, delta, baseThickness * 0.3f, 0xF000F0, LaserArmRenderer.CORE_COLOR_START, LaserArmRenderer.CORE_COLOR_END);
            BeamRenderer.renderStraightBeam(matrices, beamConsumer, startLocal, delta, baseThickness, 0xF000F0, -1718947105, -1726784688);
        }
    }

    private record RenderedLine(float startedAt, List<Vec3> positions) {
    }
}

