/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.cablesurfer;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.client.cablesurfer.ClientZiplineHandler;
import rearth.oritech.client.cablesurfer.ZiplineSoundInstance;

public class ZiplineFxHandler {
    private static final Map<UUID, ZiplineSoundInstance> ACTIVE_SOUNDS = new HashMap<UUID, ZiplineSoundInstance>();

    public static void tick() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            ACTIVE_SOUNDS.clear();
            return;
        }
        for (AbstractClientPlayer player : level.players()) {
            ZiplineFxHandler.handlePlayerFX((Player)player);
        }
        ACTIVE_SOUNDS.entrySet().removeIf(entry -> {
            ZiplineSoundInstance sound = (ZiplineSoundInstance)((Object)((Object)entry.getValue()));
            return sound.isStopped();
        });
    }

    private static void handlePlayerFX(Player player) {
        if (!ClientZiplineHandler.isZiplining(player)) {
            return;
        }
        if (!ACTIVE_SOUNDS.containsKey(player.getUUID())) {
            ZiplineSoundInstance sound = new ZiplineSoundInstance(player);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
            ACTIVE_SOUNDS.put(player.getUUID(), sound);
            player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.IRON_TRAPDOOR_OPEN, player.getSoundSource(), 0.5f, 0.5f, false);
            player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.CHAIN_PLACE, player.getSoundSource(), 0.2f, 1.0f, false);
        }
        ZiplineFxHandler.spawnParticles(player);
    }

    private static void spawnParticles(Player player) {
        RandomSource random = player.level().random;
        double speed = player.getDeltaMovement().length();
        if (speed < 0.1) {
            return;
        }
        if ((double)random.nextFloat() < speed / 2.0) {
            double wireY = player.getY() + (double)1.65f + 0.38;
            Vec3 vel = player.getDeltaMovement().scale(2.0);
            player.level().addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, player.getX(), wireY, player.getZ(), vel.x + ((double)random.nextFloat() - 0.5) * 0.2, vel.y + (double)random.nextFloat() * 0.2, vel.z + ((double)random.nextFloat() - 0.5) * 0.2);
            if ((double)random.nextFloat() > 0.85) {
                player.level().playLocalSound(player.getX(), wireY, player.getZ(), SoundEvents.CHAIN_HIT, player.getSoundSource(), 0.3f, 2.0f, false);
            }
        }
    }
}

