/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.storage;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.storage.UnstableContainerBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class UnstableContainerBlockEntity
extends NetworkedBlockEntity
implements ScreenProvider,
ExtendedMenuProvider,
ColorableMachine,
GeoBlockEntity,
MultiblockMachineController,
EnergyApi.BlockProvider {
    public static final RawAnimation SETUP = RawAnimation.begin().thenPlay("setup").thenPlay("idle");
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    public static final Long BASE_CAPACITY = Oritech.CONFIG.unstableContainerBaseCapacity();
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    public BlockState capturedBlock = Blocks.AIR.defaultBlockState();
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    public float qualityMultiplier = 1.0f;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    public DynamicStatisticEnergyStorage.EnergyStatistics currentStats;
    @SyncField(value={SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = this.getDefaultColor();
    private long age = 0L;
    private boolean dropped = false;
    public final SimpleEnergyStorage laserInputStorage = new SimpleEnergyStorage(100000000L, 0L, 100000000L);
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    protected final DynamicStatisticEnergyStorage energyStorage = new DynamicStatisticEnergyStorage(20000000L, 20000000L, 20000000L, this::setChanged);
    private final EnergyApi.EnergyStorage outputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsInsertion() {
            return false;
        }
    };
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public UnstableContainerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.UNSTABLE_CONTAINER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        ++this.age;
        if (this.age > 10L && !((Boolean)state.getValue((Property)UnstableContainerBlock.SETUP_DONE)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)UnstableContainerBlock.SETUP_DONE, (Comparable)Boolean.valueOf(true)));
        }
        this.energyStorage.tick((int)world.getGameTime());
        this.adjustEnergyStorageSize();
        if (this.energyStorage.amount > 0L) {
            this.outputEnergy();
        }
    }

    private void adjustEnergyStorageSize() {
        double targetMultiplier = 1.0 + Math.pow((double)this.laserInputStorage.getAmount() / (double)Oritech.CONFIG.laserArmConfig.energyPerTick(), 2.0);
        targetMultiplier = Math.min(targetMultiplier, 5000.0);
        this.laserInputStorage.setAmount(0L);
        double targetAmount = (double)((float)BASE_CAPACITY.longValue() * this.qualityMultiplier) * targetMultiplier;
        long currentAmount = this.energyStorage.getCapacity();
        this.energyStorage.capacity = (long)Mth.lerp((double)0.005, (double)currentAmount, (double)targetAmount);
        this.energyStorage.setMaxInsert((long)targetAmount);
        this.energyStorage.setMaxExtract((long)targetAmount);
        if ((double)this.energyStorage.capacity < (double)this.energyStorage.maxInsert * 0.9999) {
            ParticleContent.UNSTABLE_CONTAINER_GROWING.spawn(this.level, this.worldPosition.getCenter(), (Object)2);
        }
        if (this.energyStorage.amount > this.energyStorage.capacity) {
            this.energyStorage.amount = this.energyStorage.capacity;
        }
        if ((float)this.energyStorage.capacity != (float)BASE_CAPACITY.longValue() * this.qualityMultiplier) {
            this.energyStorage.update();
        }
    }

    private void outputEnergy() {
        List<Vec3i> positions = List.of(new Vec3i(0, -3, 0), new Vec3i(0, 2, 0));
        for (Vec3i outputPos : positions) {
            BlockPos worldPos = this.worldPosition.offset(outputPos);
            EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.level, worldPos, null);
            if (candidate == null) continue;
            EnergyApi.transfer(this.energyStorage, candidate, this.energyStorage.maxExtract, false);
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.addMultiblockToNbt(nbt);
        this.addColorToNbt(nbt);
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)this.capturedBlock.getBlock());
        nbt.putString("captured", blockId.toString());
        nbt.putLong("energy_stored", this.energyStorage.amount);
        nbt.putLong("energy_capacity", this.energyStorage.capacity);
        nbt.putFloat("quality", this.qualityMultiplier);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.loadColorFromNbt(nbt);
        this.energyStorage.amount = nbt.getLong("energy_stored");
        this.energyStorage.capacity = nbt.getLong("energy_capacity");
        this.energyStorage.capacity = nbt.getLong("energy_capacity");
        this.qualityMultiplier = nbt.getFloat("quality");
        String blockId = nbt.getString("captured");
        if (!blockId.isBlank() && BuiltInRegistries.BLOCK.containsKey(ResourceLocation.parse((String)blockId))) {
            this.capturedBlock = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockId))).defaultBlockState();
        }
    }

    @Override
    public void preNetworkUpdate(SyncType type) {
        super.preNetworkUpdate(type);
        this.currentStats = this.energyStorage.getCurrentStatistics(this.level.getGameTime());
    }

    @Override
    public ColorableMachine.ColorVariant getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void assignColor(ColorableMachine.ColorVariant color) {
        this.currentColor = color;
        if (this.level != null && !this.level.isClientSide()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }

    @Override
    public ColorableMachine.ColorVariant getDefaultColor() {
        return ColorableMachine.ColorVariant.CAMO;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 0, state -> {
            if (state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                if (((Boolean)this.getBlockState().getValue((Property)UnstableContainerBlock.SETUP_DONE)).booleanValue()) {
                    return state.setAndContinue(IDLE);
                }
                return state.setAndContinue(SETUP);
            }
            return PlayState.CONTINUE;
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return UnstableContainerBlockEntity.getCoreOffsets();
    }

    public static List<Vec3i> getCoreOffsets() {
        return List.of(new Vec3i(-1, -2, -1), new Vec3i(0, -2, -1), new Vec3i(1, -2, -1), new Vec3i(-1, -2, 0), new Vec3i(0, -2, 0), new Vec3i(1, -2, 0), new Vec3i(-1, -2, 1), new Vec3i(0, -2, 1), new Vec3i(1, -2, 1), new Vec3i(-1, -1, -1), new Vec3i(0, -1, -1), new Vec3i(1, -1, -1), new Vec3i(-1, -1, 0), new Vec3i(0, -1, 0), new Vec3i(1, -1, 0), new Vec3i(-1, -1, 1), new Vec3i(0, -1, 1), new Vec3i(1, -1, 1), new Vec3i(-1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(-1, 0, 1), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(0, 1, -1), new Vec3i(-1, 1, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(0, 1, 1));
    }

    @Override
    public Direction getFacingForMultiblock() {
        return Direction.NORTH;
    }

    @Override
    public BlockPos getPosForMultiblock() {
        return this.worldPosition;
    }

    @Override
    public Level getWorldForMultiblock() {
        return this.level;
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
    }

    @Override
    public float getCoreQuality() {
        return 7.0f;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return null;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction direction) {
        return this.getEnergyStorage(direction);
    }

    @Override
    public void triggerSetupAnimation() {
    }

    @Override
    public void onCoreBroken(BlockPos corePos) {
        this.onBroken(corePos);
    }

    @Override
    public void onControllerBroken() {
        this.onBroken(this.worldPosition);
    }

    private void onBroken(BlockPos eventSource) {
        if (this.dropped) {
            return;
        }
        this.dropped = true;
        for (BlockPos corePos : this.coreBlocksConnected) {
            if (corePos.equals((Object)eventSource)) continue;
            this.level.setBlockAndUpdate(corePos, Blocks.AIR.defaultBlockState());
        }
        this.level.setBlockAndUpdate(this.worldPosition, this.capturedBlock);
        Vec3 spawnAt = this.worldPosition.getCenter().add(0.0, 1.0, 0.0);
        this.level.addFreshEntity((Entity)new ItemEntity(this.level, spawnAt.x, spawnAt.y, spawnAt.z, new ItemStack((ItemLike)ItemContent.UNSTABLE_CONTAINER)));
    }

    public void setCapturedBlock(BlockState capturedBlock) {
        this.capturedBlock = capturedBlock;
        this.setChanged();
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        if (direction == null) {
            return this.energyStorage;
        }
        if (direction.equals((Object)Direction.DOWN) || direction.equals((Object)Direction.UP)) {
            return this.outputStorage;
        }
        return this.energyStorage;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of();
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 6, 15, 72);
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return new SimpleContainer(new ItemStack[0]);
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.STORAGE_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }
}

