/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.OritechPlatform;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleInOutFluidStorage;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.CentrifugeScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class CentrifugeBlockEntity
extends MultiblockMachineEntity
implements FluidApi.BlockProvider {
    @SyncField(value={SyncType.GUI_TICK, SyncType.INITIAL})
    public final SimpleInOutFluidStorage fluidContainer;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.INITIAL})
    public boolean hasFluidAddon;

    public CentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.CENTRIFUGE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.centrifugeData.energyPerTick());
        this.fluidContainer = new SimpleInOutFluidStorage(Oritech.CONFIG.processingMachines.centrifugeData.tankSizeInBuckets() * FluidStackHooks.bucketAmount(), this::setChanged);
        this.hasFluidAddon = false;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.centrifugeData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.centrifugeData.maxEnergyInsertion();
    }

    @Override
    protected boolean canProceed(OritechRecipe recipe) {
        FluidStack output;
        if (!this.hasFluidAddon) {
            return super.canProceed(recipe);
        }
        if (!CentrifugeBlockEntity.recipeInputMatchesTank(this.fluidContainer.getInStack(), recipe)) {
            return false;
        }
        FluidStack fluidStack = output = recipe.getFluidOutputs().isEmpty() ? null : recipe.getFluidOutputs().getFirst();
        if (output != null && !output.isEmpty()) {
            if (this.fluidContainer.getOutStack().getAmount() + output.getAmount() > this.fluidContainer.getCapacity()) {
                return false;
            }
            if (!this.fluidContainer.getOutStack().isEmpty() && !output.isFluidEqual(this.fluidContainer.getOutStack())) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        if (!this.hasFluidAddon) {
            return super.getRecipe();
        }
        List candidates = Objects.requireNonNull(this.level).getRecipeManager().getRecipesFor((RecipeType)this.getOwnRecipeType(), this.getInputInventory(), this.level);
        Optional<RecipeHolder<OritechRecipe>> fluidRecipe = candidates.stream().filter(candidate -> CentrifugeBlockEntity.recipeInputMatchesTank(this.fluidContainer.getInStack(), (OritechRecipe)candidate.value())).findAny();
        if (fluidRecipe.isPresent()) {
            return fluidRecipe;
        }
        return this.getNormalRecipe();
    }

    private Optional<RecipeHolder<OritechRecipe>> getNormalRecipe() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.CENTRIFUGE, this.getInputInventory(), this.level);
    }

    public static boolean recipeInputMatchesTank(FluidStack available, OritechRecipe recipe) {
        boolean recipeNeedsFluid;
        boolean bl = recipeNeedsFluid = recipe.getFluidInput() != null && recipe.getFluidInput().amount() > 0L;
        if (!recipeNeedsFluid) {
            return true;
        }
        boolean isTankEmpty = available.isEmpty();
        if (isTankEmpty) {
            return false;
        }
        FluidIngredient recipeFluid = recipe.getFluidInput();
        return recipeFluid.matchesFluid(available) && available.getAmount() >= recipe.getFluidInput().amount();
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<ItemStack> outputInventory, List<ItemStack> inputInventory) {
        Optional<RecipeHolder<OritechRecipe>> newRecipe;
        int chamberCount = this.getBaseAddonData().extraChambers() + 1;
        for (int i = 0; i < chamberCount && !(newRecipe = this.getRecipe()).isEmpty() && ((OritechRecipe)newRecipe.get().value()).equals(this.currentRecipe) && this.canOutputRecipe(activeRecipe) && this.canProceed(activeRecipe); ++i) {
            super.craftItem(activeRecipe, outputInventory, inputInventory);
            if (!this.hasFluidAddon) continue;
            this.craftFluids(activeRecipe);
        }
    }

    @Override
    public boolean supportExtraChambersAuto() {
        return false;
    }

    private void craftFluids(OritechRecipe activeRecipe) {
        FluidStack output;
        FluidIngredient input = activeRecipe.getFluidInput();
        FluidStack fluidStack = output = activeRecipe.getFluidOutputs().isEmpty() ? null : activeRecipe.getFluidOutputs().getFirst();
        if (input != null && input.amount() > 0L) {
            this.fluidContainer.getInputContainer().extract(this.fluidContainer.getInStack().copyWithAmount(input.amount()), false);
        }
        if (output != null && output.getAmount() > 0L) {
            this.fluidContainer.getOutputContainer().insert(output, false);
        }
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        CombiAddonEntity combi;
        AddonBlockEntity addonBlockEntity;
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_FLUID_ADDON) || (addonBlockEntity = addonBlock.addonEntity()) instanceof CombiAddonEntity && (combi = (CombiAddonEntity)addonBlockEntity).hasFluid()) {
            this.hasFluidAddon = true;
        }
    }

    @Override
    public void resetAddons() {
        super.resetAddons();
        this.hasFluidAddon = false;
    }

    @Override
    public void initAddons(BlockPos brokenAddon) {
        Level level;
        boolean hadAddon = this.hasFluidAddon;
        this.hasFluidAddon = false;
        super.initAddons(brokenAddon);
        if (this.hasFluidAddon != hadAddon && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional coreCandidate = this.level.getBlockEntity(this.worldPosition.above(), BlockEntitiesContent.MACHINE_CORE_ENTITY);
            if (coreCandidate.isPresent()) {
                MachineCoreEntity core = (MachineCoreEntity)coreCandidate.get();
                core.resetCaches();
            }
            OritechPlatform.INSTANCE.resetCapabilities(serverLevel, this.worldPosition);
            OritechPlatform.INSTANCE.resetCapabilities(serverLevel, this.worldPosition.above());
            this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
            this.level.blockUpdated(this.worldPosition.above(), this.level.getBlockState(this.worldPosition.above()).getBlock());
        }
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("fluidAddon", this.hasFluidAddon);
        this.fluidContainer.writeNbt(nbt, "");
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.hasFluidAddon = nbt.getBoolean("fluidAddon");
        this.fluidContainer.readNbt(nbt, "");
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        if (this.hasFluidAddon) {
            return RecipeContent.CENTRIFUGE_FLUID;
        }
        return RecipeContent.CENTRIFUGE;
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 2);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 113, 38, true), new ScreenProvider.GuiSlot(2, 113, 56, true));
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.CENTRIFUGE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0));
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, 0, -1), new Vec3i(0, 0, 1));
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new CentrifugeScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public int getAnimationDuration() {
        return 180;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable Direction direction) {
        if (!this.hasFluidAddon) {
            return null;
        }
        return this.fluidContainer;
    }
}

