/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ShrinkerBlockEntity
extends NetworkedBlockEntity
implements ItemApi.BlockProvider,
EnergyApi.BlockProvider,
GeoBlockEntity,
ExtendedMenuProvider,
ScreenProvider,
MultiblockMachineController,
MachineAddonController,
ColorableMachine {
    public static final RawAnimation SHRINK = RawAnimation.begin().thenPlay("work");
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    private final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), 0L, this::setChanged);
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(1, this::setChanged);
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    private float coreQuality = 1.0f;
    @SyncField(value={SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = this.getDefaultColor();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA;
    @SyncField(value={SyncType.GUI_OPEN})
    public ShrunkAddonData currentCandidate = new ShrunkAddonData(MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA, false, 0, 0, false, false);
    private boolean wasRedstoneActive = false;

    public ShrinkerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.SHRINKER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        boolean currentRedstone = world.hasNeighborSignal(pos);
        if (currentRedstone && !this.wasRedstoneActive) {
            System.out.println("triggered redstone shrink");
            this.doShrink();
        }
        this.wasRedstoneActive = currentRedstone;
    }

    public void doShrink() {
        if (this.energyStorage.getAmount() < this.getDefaultCapacity()) {
            return;
        }
        this.initAddons();
        if (this.currentCandidate == null || this.connectedAddons.isEmpty() || !this.inventory.isEmpty()) {
            return;
        }
        this.energyStorage.setAmount(this.energyStorage.getAmount() - this.getDefaultCapacity());
        this.energyStorage.update();
        ItemStack createdStack = new ItemStack((ItemLike)BlockContent.MACHINE_COMBI_ADDON.asItem());
        createdStack.set((DataComponentType)ComponentContent.ADDON_DATA.get(), (Object)this.currentCandidate);
        this.inventory.setStackInSlot(0, createdStack);
        for (BlockPos addonPos : this.connectedAddons.reversed()) {
            this.level.setBlock(addonPos, Blocks.AIR.defaultBlockState(), 2);
            Level level = this.level;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverWorld = (ServerLevel)level;
            Vec3 spawnAt = addonPos.getCenter();
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.GUST, spawnAt.x, spawnAt.y, spawnAt.z, 1, 0.0, (double)0.1f, 0.0, 0.5);
            serverWorld.playSound(null, this.worldPosition, SoundEvents.SMALL_AMETHYST_BUD_PLACE, SoundSource.BLOCKS, 2.0f, 0.5f);
        }
        this.triggerAnim("machine", "work");
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        MachineAddonController.super.gatherAddonStats(addons);
        if (addons.isEmpty()) {
            this.currentCandidate = new ShrunkAddonData(MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA, false, 0, 0, false, false);
            return;
        }
        MachineAddonController.BaseAddonData data = this.getBaseAddonData();
        boolean fluid = false;
        int quarryCount = 0;
        int yieldCount = 0;
        boolean cropFilter = false;
        boolean silk = false;
        for (MachineAddonController.AddonBlock addon : addons) {
            if (((Object)((Object)addon.addonBlock())).equals(BlockContent.MACHINE_FLUID_ADDON)) {
                fluid = true;
            }
            if (((Object)((Object)addon.addonBlock())).equals(BlockContent.QUARRY_ADDON)) {
                ++quarryCount;
            }
            if (((Object)((Object)addon.addonBlock())).equals(BlockContent.MACHINE_YIELD_ADDON)) {
                ++yieldCount;
            }
            if (((Object)((Object)addon.addonBlock())).equals(BlockContent.CROP_FILTER_ADDON)) {
                cropFilter = true;
            }
            if (!((Object)((Object)addon.addonBlock())).equals(BlockContent.MACHINE_SILK_TOUCH_ADDON)) continue;
            silk = true;
        }
        this.currentCandidate = new ShrunkAddonData(data, fluid, quarryCount, yieldCount, cropFilter, silk);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        this.addMultiblockToNbt(nbt);
        this.writeAddonToNbt(nbt);
        this.addColorToNbt(nbt);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        nbt.putBoolean("redstone", this.wasRedstoneActive);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.loadAddonNbtData(nbt);
        this.loadColorFromNbt(nbt);
        this.energyStorage.amount = nbt.getLong("energy_stored");
        this.wasRedstoneActive = nbt.getBoolean("redstone");
        this.updateEnergyContainer();
    }

    @Override
    public ColorableMachine.ColorVariant getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void assignColor(ColorableMachine.ColorVariant color) {
        this.currentColor = color;
        if (this.level != null && !this.level.isClientSide()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 0, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            if (this.isActive(this.getBlockState())) {
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).triggerableAnim("work", SHRINK).triggerableAnim("deploy", MachineBlockEntity.SETUP).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new UpgradableMachineScreenHandler(i, inventory, this);
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public BlockPos getPosForAddon() {
        return this.getBlockPos();
    }

    @Override
    public Level getWorldForAddon() {
        return this.getLevel();
    }

    @Override
    public Direction getFacingForAddon() {
        return (Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(1, 0, 0));
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.addonConfig.addonShrinkerRF();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.addonConfig.addonShrinkerRF() / 60L;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(1, 0, 1), new Vec3i(0, 0, 1));
    }

    @Override
    public Direction getFacingForMultiblock() {
        return (Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Override
    public BlockPos getPosForMultiblock() {
        return this.getBlockPos();
    }

    @Override
    public Level getWorldForMultiblock() {
        return this.getLevel();
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("machine", "deploy");
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 40, 40, true));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.getDefaultCapacity();
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.SHRINKER_SCREEN;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    public static void onPlayerUse(ShrinkerPlayerUsePacket packet, Player player, RegistryAccess registryAccess) {
        Level world = player.level();
        Optional candidate = world.getBlockEntity(packet.pos(), BlockEntitiesContent.SHRINKER_BLOCK_ENTITY);
        candidate.ifPresent(ShrinkerBlockEntity::doShrink);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    public record ShrunkAddonData(MachineAddonController.BaseAddonData data, boolean fluid, int quarryCount, int yieldCount, boolean cropFilter, boolean silk) {
        public static final Codec<ShrunkAddonData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MachineAddonController.BaseAddonData.CODEC.fieldOf("data").forGetter(ShrunkAddonData::data), (App)Codec.BOOL.fieldOf("fluid").forGetter(ShrunkAddonData::fluid), (App)Codec.INT.fieldOf("quarry_count").forGetter(ShrunkAddonData::quarryCount), (App)Codec.INT.fieldOf("yield_count").forGetter(ShrunkAddonData::yieldCount), (App)Codec.BOOL.fieldOf("crop_filter").forGetter(ShrunkAddonData::cropFilter), (App)Codec.BOOL.fieldOf("silk").forGetter(ShrunkAddonData::silk)).apply((Applicative)instance, ShrunkAddonData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShrunkAddonData> STREAM_CODEC = NetworkManager.getAutoCodec(ShrunkAddonData.class);

        @Override
        @NotNull
        public String toString() {
            return "ShrunkAddonData{data=" + String.valueOf(this.data) + ", fluid=" + this.fluid + ", quarryCount=" + this.quarryCount + ", yieldCount=" + this.yieldCount + ", cropFilter=" + this.cropFilter + "}";
        }
    }

    public record ShrinkerPlayerUsePacket(BlockPos pos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ShrinkerPlayerUsePacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("shrink"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

