/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.interaction;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.TooltipHelper;

public class PowerPoleBlock
extends Block
implements EntityBlock {
    public PowerPoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MultiblockMachine.ASSEMBLED, BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getClockWise().getOpposite());
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (!world.isClientSide) {
            Boolean corePlaced;
            BlockEntity entity = world.getBlockEntity(pos);
            if (!(entity instanceof PowerPoleEntity)) {
                return InteractionResult.SUCCESS;
            }
            PowerPoleEntity powerPole = (PowerPoleEntity)entity;
            Boolean wasAssembled = (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
            if (!wasAssembled.booleanValue() && (corePlaced = powerPole.tryPlaceNextCore(player)).booleanValue()) {
                return InteractionResult.SUCCESS;
            }
            boolean isAssembled = powerPole.initMultiblock(state);
            if (isAssembled && !wasAssembled.booleanValue()) {
                powerPole.triggerSetupAnimation();
                return InteractionResult.SUCCESS;
            }
            if (!isAssembled) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.machine.missing_core"));
                return InteractionResult.SUCCESS;
            }
            ExtendedMenuProvider handler = (ExtendedMenuProvider)world.getBlockEntity(pos);
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)handler);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof MultiblockMachineController) {
                MultiblockMachineController machineEntity = (MultiblockMachineController)entity;
                machineEntity.onControllerBroken();
            }
            if (entity instanceof PowerPoleEntity) {
                PowerPoleEntity poleBlock = (PowerPoleEntity)entity;
                poleBlock.onRemoved();
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PowerPoleEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        boolean showExtra = Screen.hasControlDown();
        if (!showExtra) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.power_pole.short").withStyle(ChatFormatting.GRAY));
        }
        TooltipHelper.addMachineTooltip(tooltip, this, this);
        if (showExtra) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.power_pole.1").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.power_pole.2").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.power_pole.3", (Object[])new Object[]{Oritech.CONFIG.poleConfig.minRange(), Oritech.CONFIG.poleConfig.maxRange(), TooltipHelper.getEnergyText(Oritech.CONFIG.poleConfig.energyCapacity())}).withStyle(ChatFormatting.GRAY));
        }
    }
}

