/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.data.client;

import com.Pdiddy973.AllTheCompressed.AllTheCompressed;
import com.Pdiddy973.AllTheCompressed.overlay.Overlays;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.datagen.BlockStateDataGen;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class XycraftBlockStates
extends BlockStateDataGen {
    protected static final Map<XyCraftColors, Overlays> overlays = new EnumMap<XyCraftColors, Overlays>(XyCraftColors.class);

    public XycraftBlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, new ArrayList(), "allthecompressed", exFileHelper);
    }

    public String getName() {
        return "ATC XyCraft Compressed Blocks";
    }

    protected void registerStatesAndModels() {
        for (XyCraftColors color : XyCraftColors.values()) {
            Overlays value = overlays.get(color);
            BlockContent storage = (BlockContent)WorldContent.Block.XychoriumStorage.get(color);
            ResourceLocation parent = value.overlay.parent;
            Optional block = BuiltInRegistries.BLOCK.getOptional(parent);
            if (block.isEmpty() || block.get() == Blocks.AIR) {
                AllTheCompressed.LOGGER.error("missing block during datagen: {}", (Object)parent);
                continue;
            }
            for (int i = 0; i < 9; ++i) {
                DeferredBlock<Block> each = value.overlay.xall.get(i);
                String path = each.getId().getPath();
                BlockModelBuilder model = this.cloudModelTintable(path, storage);
                model.texture("tex", "xycraft_world:block/connected/xychorium_storage_single");
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().cube("#overlay").end()).renderType("minecraft:cutout")).texture("overlay", String.format("%s:block/layer_%s", "allthecompressed", i + 1))).texture("particle", "minecraft:block/netherite_block");
                this.simpleBlockWithItem((Block)each.get(), (ModelFile)model);
            }
        }
    }

    static {
        overlays.put(XyCraftColors.Red, Overlays.RED_XYCHORIUM);
        overlays.put(XyCraftColors.Blue, Overlays.BLUE_XYCHORIUM);
        overlays.put(XyCraftColors.Green, Overlays.GREEN_XYCHORIUM);
        overlays.put(XyCraftColors.Dark, Overlays.DARK_XYCHORIUM);
        overlays.put(XyCraftColors.Light, Overlays.LIGHT_XYCHORIUM);
    }
}

