/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.client;

import codechicken.lib.internal.HighlightHandler;
import codechicken.lib.raytracer.RayTracer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class HighlightCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ccl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"highlight").then(((LiteralArgumentBuilder)Commands.literal((String)"set").executes(HighlightCommand::setHighlightRayTrace)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(HighlightCommand::setHighlightArg)))).then(Commands.literal((String)"clear").executes(HighlightCommand::clearHighlight))).then(Commands.literal((String)"toggle_depth").executes(HighlightCommand::toggleDepth))).then(Commands.literal((String)"info").executes(HighlightCommand::dumpInfo))));
    }

    private static int setHighlightRayTrace(CommandContext<CommandSourceStack> ctx) {
        BlockHitResult hitResult = RayTracer.retrace((Player)Minecraft.getInstance().player, 3000.0, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Not looking at a block."));
            return 0;
        }
        return HighlightCommand.setHighlight(ctx, hitResult.getBlockPos());
    }

    private static int setHighlightArg(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return HighlightCommand.setHighlight(ctx, BlockPosArgument.getSpawnablePos(ctx, (String)"pos"));
    }

    private static int setHighlight(CommandContext<CommandSourceStack> ctx, BlockPos pos) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (HighlightHandler.highlight == null) {
            source.sendSuccess(() -> Component.literal((String)("Set highlight at " + pos.getX() + ", " + pos.getY() + ", " + pos.getZ())), false);
        } else {
            BlockPos prev = HighlightHandler.highlight;
            source.sendSuccess(() -> Component.literal((String)("Moved highlight from " + prev.getX() + ", " + prev.getY() + ", " + prev.getZ() + " to " + pos.getX() + ", " + pos.getY() + ", " + pos.getZ())), false);
        }
        HighlightHandler.highlight = pos;
        return 0;
    }

    private static int clearHighlight(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (HighlightHandler.highlight == null) {
            source.sendFailure((Component)Component.literal((String)"Highlight not set."));
            return 0;
        }
        HighlightHandler.highlight = null;
        HighlightHandler.useDepth = true;
        source.sendSuccess(() -> Component.literal((String)"Highlight position cleared."), false);
        return 0;
    }

    private static int toggleDepth(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (HighlightHandler.highlight == null) {
            source.sendFailure((Component)Component.literal((String)"Highlight not set."));
            return 0;
        }
        boolean bl = HighlightHandler.useDepth = !HighlightHandler.useDepth;
        if (HighlightHandler.useDepth) {
            source.sendSuccess(() -> Component.literal((String)"Enabled highlight depth."), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"Disabled highlight depth."), false);
        }
        return 0;
    }

    private static int dumpInfo(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        BlockPos pos = HighlightHandler.highlight;
        if (HighlightHandler.highlight == null) {
            source.sendFailure((Component)Component.literal((String)"Highlight not set."));
            return 0;
        }
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        BlockEntity tile = level.getBlockEntity(pos);
        StringBuilder builder = new StringBuilder("\nBlock info:\n");
        builder.append("  BlockPos:      ").append(String.format("x:%s, y:%s, z:%s", pos.getX(), pos.getY(), pos.getZ())).append("\n");
        builder.append("  Block Class:   ").append(block.getClass()).append("\n");
        builder.append("  Registry Name: ").append(BuiltInRegistries.BLOCK.getKey((Object)block)).append("\n");
        builder.append("  State:         ").append(state).append("\n");
        builder.append("Tile at position\n");
        builder.append("  Tile Class:    ").append(tile != null ? tile.getClass() : null).append("\n");
        builder.append("  Tile Id:       ").append(tile != null ? BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)tile.getType()) : null).append("\n");
        builder.append("  Tile NBT:      ").append(tile != null ? tile.saveWithoutMetadata((HolderLookup.Provider)tile.getLevel().registryAccess()) : null).append("\n");
        source.sendSuccess(() -> Component.literal((String)builder.toString()), false);
        return 0;
    }
}

