/*
 * Decompiled with CFR 0.152.
 */
package name.modid.neoforge;

import java.util.UUID;
import name.modid.BattleExtrasServerConfig;
import name.modid.CobblemonBattleExtras;
import name.modid.ServerConfigSync;
import name.modid.client.ServerConfigHolder;
import name.modid.client.net.TeamBallClientData;
import name.modid.client.net.TeraTypeClientData;
import name.modid.net.payload.FaintRevivePayload;
import name.modid.net.payload.ServerConfigSyncPayload;
import name.modid.net.payload.TeamBallPayload;
import name.modid.net.payload.TeraTypeSyncPayload;
import name.modid.net.payload.UpdateServerConfigPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="cobblemon_battle_extras", bus=EventBusSubscriber.Bus.MOD)
public class NeoForgeClientNetworkRegistration {
    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1.0").optional();
        registrar.playToClient(ServerConfigSyncPayload.TYPE, ServerConfigSyncPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> ServerConfigHolder.updateFromServer(payload.hideOpponentPokeballTypes(), payload.battleSpeedMultiplier())));
        registrar.playToClient(TeamBallPayload.TYPE, TeamBallPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            UUID actorUuid = UUID.fromString(payload.actorUuid());
            TeamBallClientData.setTeamData(actorUuid, payload.team());
        }));
        registrar.playToClient(FaintRevivePayload.TYPE, FaintRevivePayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            UUID actorUuid = UUID.fromString(payload.actorUuid());
            TeamBallClientData.updateFaintStatus(actorUuid, payload.pokemonIndex(), payload.isFainted());
        }));
        registrar.playToClient(TeraTypeSyncPayload.TYPE, TeraTypeSyncPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> TeraTypeClientData.setTeraType(payload.pokemonUuid(), payload.teraType())));
        registrar.playToServer(UpdateServerConfigPayload.TYPE, UpdateServerConfigPayload.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (player.hasPermissions(3)) {
                    BattleExtrasServerConfig.get().hideOpponentPokeballTypes = payload.hideOpponentPokeballTypes();
                    BattleExtrasServerConfig.get().battleSpeedMultiplier = payload.battleSpeedMultiplier();
                    BattleExtrasServerConfig.save(player.getServer().getServerDirectory().resolve("config"));
                    for (ServerPlayer p : player.getServer().getPlayerList().getPlayers()) {
                        ServerConfigSync.syncToPlayer(p);
                    }
                    CobblemonBattleExtras.LOGGER.debug("[BattleExtras] {} updated server config: hideOpponentPokeballTypes={}, battleSpeedMultiplier={}", new Object[]{player.getName().getString(), payload.hideOpponentPokeballTypes(), Float.valueOf(payload.battleSpeedMultiplier())});
                } else {
                    CobblemonBattleExtras.LOGGER.warn("[BattleExtras] {} tried to update server config without permission", (Object)player.getName().getString());
                }
            }
        }));
    }
}

