/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin.client;

import com.cobblemon.mod.common.client.net.battle.BattleMessageHandler;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMessagePacket;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.battlelog.BattleLogManager;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BattleMessageHandler.class}, remap=false)
public class CobblemonBattleMessageHandlerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BattleExtras-MessageHandler");

    @Inject(method={"handle(Lcom/cobblemon/mod/common/net/messages/client/battle/BattleMessagePacket;Lnet/minecraft/client/Minecraft;)V"}, at={@At(value="HEAD")}, require=0)
    private void onBattleMessage(BattleMessagePacket packet, Minecraft client, CallbackInfo ci) {
        CobblemonBattleInfoClient.debug("[BattleExtras] MIXIN METHOD CALLED!", new Object[0]);
        this.processBattleMessage(packet);
    }

    private void processBattleMessage(BattleMessagePacket packet) {
        if (packet == null) {
            return;
        }
        try {
            for (Component component : packet.getMessages()) {
                String string;
                ComponentContents componentContents;
                if (component == null) continue;
                ComponentContents componentContents2 = component.getContents();
                if (componentContents2 instanceof TranslatableContents) {
                    TranslatableContents tc = (TranslatableContents)componentContents2;
                    String key = tc.getKey();
                    CobblemonBattleInfoClient.debug("[BattleExtras] Translation key: {}", key);
                    if (key != null && (key.contains("boost") || key.contains("stat"))) {
                        CobblemonBattleInfoClient.debug("[BattleExtras] STAT KEY DETECTED: {}", key);
                        Object[] args = tc.getArgs();
                        CobblemonBattleInfoClient.debug("[BattleExtras]   args count: {}", args == null ? 0 : args.length);
                        if (args != null) {
                            for (int i = 0; i < args.length; ++i) {
                                Object arg = args[i];
                                CobblemonBattleInfoClient.debug("[BattleExtras]   arg[{}] type: {}", i, arg == null ? "null" : arg.getClass().getName());
                                if (arg instanceof Component) {
                                    Component c = (Component)arg;
                                    CobblemonBattleInfoClient.debug("[BattleExtras]   arg[{}] text: {}", i, c.getString());
                                    ComponentContents componentContents3 = c.getContents();
                                    if (!(componentContents3 instanceof TranslatableContents)) continue;
                                    TranslatableContents innerTc = (TranslatableContents)componentContents3;
                                    CobblemonBattleInfoClient.debug("[BattleExtras]   arg[{}] inner key: {}", i, innerTc.getKey());
                                    continue;
                                }
                                CobblemonBattleInfoClient.debug("[BattleExtras]   arg[{}] value: {}", i, arg);
                            }
                        }
                    }
                    BattleMessageSubscriber.onBattleTranslatableMessage(tc);
                }
                if ((componentContents = component.getContents()) instanceof TranslatableContents) {
                    TranslatableContents tc = (TranslatableContents)componentContents;
                    string = tc.getKey();
                } else {
                    string = null;
                }
                String translationKey = string;
                BattleLogManager.addMessage(component, translationKey);
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[BattleExtras] Error processing battle message", t);
        }
    }

    static {
        CobblemonBattleInfoClient.debug("[BattleExtras] CobblemonBattleMessageHandlerMixin CLASS LOADED!", new Object[0]);
    }
}

