/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageColorizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Pseudo
@Mixin(targets={"com/cobblemon/mod/common/client/battle/ClientBattleMessageQueue"}, remap=false)
public class BattleMessageQueueMixin {
    @ModifyArg(method={"add(Ljava/lang/Iterable;)V"}, at=@At(value="INVOKE", target="Ljava/util/List;addAll(Ljava/util/Collection;)Z", remap=false), index=0, require=0, remap=false)
    private Collection<?> fixWordWrapping(Collection<?> messages) {
        try {
            Component colorized;
            if (!BattleExtrasConfig.isBattleLogColoringEnabled()) {
                return messages;
            }
            if (messages == null || messages.isEmpty()) {
                return messages;
            }
            StringBuilder fullText = new StringBuilder();
            for (Object obj : messages) {
                if (!(obj instanceof FormattedCharSequence)) continue;
                FormattedCharSequence fcs = (FormattedCharSequence)obj;
                StringBuilder sb = new StringBuilder();
                fcs.accept((index, style, codepoint) -> {
                    sb.appendCodePoint(codepoint);
                    return true;
                });
                String lineText = sb.toString();
                if (fullText.length() > 0 && !Character.isWhitespace(fullText.charAt(fullText.length() - 1)) && lineText.length() > 0 && !Character.isWhitespace(lineText.charAt(0))) {
                    fullText.append(lineText);
                    continue;
                }
                if (fullText.length() > 0 && !fullText.toString().endsWith(" ")) {
                    fullText.append(" ");
                }
                fullText.append(lineText.trim());
            }
            String text = fullText.toString().trim();
            if (text.isEmpty()) {
                return messages;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null) {
                BattleMessageColorizer.setPlayerName(mc.player.getName().getString());
            }
            if ((colorized = BattleMessageColorizer.colorizeLineByParts(text)) == null) {
                return new ArrayList();
            }
            List<FormattedCharSequence> properlyWrapped = this.wrapTextByWords(colorized, 140, mc.font);
            return properlyWrapped;
        }
        catch (Throwable t) {
            return messages;
        }
    }

    private List<FormattedCharSequence> wrapTextByWords(Component text, int maxWidth, Font font) {
        Component lineComponent;
        ArrayList<FormattedCharSequence> result = new ArrayList<FormattedCharSequence>();
        String plainText = text.getString();
        String[] words = plainText.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            Object testLine = currentLine.length() > 0 ? String.valueOf(currentLine) + " " + word : word;
            int testWidth = font.width((String)testLine);
            if (testWidth > maxWidth && currentLine.length() > 0) {
                Component lineComponent2 = BattleMessageColorizer.colorizeLineByParts(currentLine.toString());
                if (lineComponent2 != null) {
                    result.add(lineComponent2.getVisualOrderText());
                }
                currentLine = new StringBuilder(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0 && (lineComponent = BattleMessageColorizer.colorizeLineByParts(currentLine.toString())) != null) {
            result.add(lineComponent.getVisualOrderText());
        }
        return result;
    }
}

