/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin.client;

import java.util.ArrayList;
import java.util.List;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageColorizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Pseudo
@Mixin(targets={"com/cobblemon/mod/common/client/battle/ClientBattleMessageQueue"}, remap=false)
public class BattleMessagePaneMixin {
    private static final int MAX_MESSAGE_WIDTH = 140;

    @ModifyVariable(method={"add(Ljava/lang/Iterable;)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0, remap=false, require=0)
    private Iterable<FormattedCharSequence> colorizeMessages(Iterable<FormattedCharSequence> original) {
        if (!BattleExtrasConfig.isBattleLogColoringEnabled()) {
            return original;
        }
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null) {
                BattleMessageColorizer.setPlayerName(mc.player.getName().getString());
            }
            StringBuilder fullText = new StringBuilder();
            ArrayList<FormattedCharSequence> originalList = new ArrayList<FormattedCharSequence>();
            for (FormattedCharSequence fcs : original) {
                originalList.add(fcs);
                StringBuilder sb = new StringBuilder();
                fcs.accept((index, style, codepoint) -> {
                    sb.appendCodePoint(codepoint);
                    return true;
                });
                String lineText = sb.toString().trim();
                if (fullText.length() > 0 && lineText.length() > 0) {
                    fullText.append(" ");
                }
                fullText.append(lineText);
            }
            String text = fullText.toString().trim();
            if (text.isEmpty()) {
                return original;
            }
            Font font = mc.font;
            List<FormattedCharSequence> result = this.wrapTextByWords(text, 140, font);
            return result;
        }
        catch (Throwable t) {
            return original;
        }
    }

    private List<FormattedCharSequence> wrapTextByWords(String text, int maxWidth, Font font) {
        Component fullColoredComponent = BattleMessageColorizer.colorizeLineByParts(text);
        List wrappedLines = font.split((FormattedText)fullColoredComponent, maxWidth);
        return wrappedLines;
    }
}

