/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client.battlelog;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import name.modid.client.BattleExtrasConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class XPTracker {
    private static boolean inBattle = false;
    private static final List<XPGainEntry> xpGainQueue = new CopyOnWriteArrayList<XPGainEntry>();
    private static long lastDisplayTime = 0L;
    private static final long DISPLAY_DURATION_MS = 2000L;
    private static int currentDisplayIndex = 0;
    private static final List<XPGainEntry> pendingGains = new ArrayList<XPGainEntry>();
    private static long lastGainTime = 0L;
    private static final long BATCH_WINDOW_MS = 500L;

    public static void onBattleStart() {
        inBattle = true;
        xpGainQueue.clear();
        pendingGains.clear();
        currentDisplayIndex = 0;
        lastDisplayTime = 0L;
        lastGainTime = 0L;
    }

    public static void onBattleEnd() {
        XPTracker.processPendingGains();
        inBattle = false;
    }

    public static void onXPGained(String pokemonName, int xpGained, int oldLevel, int newLevel) {
        if (!inBattle) {
            return;
        }
        if (xpGained <= 0) {
            return;
        }
        if (!BattleExtrasConfig.isXPGainedDisplayEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (!pendingGains.isEmpty() && now - lastGainTime > 500L) {
            XPTracker.processPendingGains();
        }
        pendingGains.add(new XPGainEntry(pokemonName, xpGained, oldLevel, newLevel));
        lastGainTime = now;
    }

    private static void processPendingGains() {
        if (pendingGains.isEmpty()) {
            return;
        }
        int addedCount = pendingGains.size();
        xpGainQueue.addAll(pendingGains);
        pendingGains.clear();
        if ((currentDisplayIndex == 0 || currentDisplayIndex >= xpGainQueue.size()) && (currentDisplayIndex = xpGainQueue.size() - addedCount) < 0) {
            currentDisplayIndex = 0;
        }
    }

    public static void tick() {
        if (!BattleExtrasConfig.isXPGainedDisplayEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (!pendingGains.isEmpty() && now - lastGainTime > 500L) {
            XPTracker.processPendingGains();
        }
        if (xpGainQueue.isEmpty()) {
            return;
        }
        if (now - lastDisplayTime >= 2000L && currentDisplayIndex < xpGainQueue.size()) {
            XPTracker.displayXPGain(xpGainQueue.get(currentDisplayIndex), currentDisplayIndex + 1, xpGainQueue.size());
            ++currentDisplayIndex;
            lastDisplayTime = now;
        }
    }

    private static void displayXPGain(XPGainEntry entry, int current, int total) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        String prefix = total > 1 ? "(" + current + "/" + total + ") " : "";
        MutableComponent message = entry.newLevel > entry.oldLevel ? Component.literal((String)(prefix + "\u2605 ")).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)entry.pokemonName).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" +").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)(XPTracker.formatNumber(entry.xpGained) + " XP")).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)(" \u2192 Lv." + entry.newLevel + "!")).withStyle(ChatFormatting.GREEN)) : Component.literal((String)(prefix + "\u2605 ")).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)entry.pokemonName).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" +").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)(XPTracker.formatNumber(entry.xpGained) + " XP")).withStyle(ChatFormatting.YELLOW));
        mc.player.displayClientMessage((Component)message, true);
    }

    public static boolean isInBattle() {
        return inBattle;
    }

    public static void clear() {
        xpGainQueue.clear();
        pendingGains.clear();
        currentDisplayIndex = 0;
        lastDisplayTime = 0L;
        lastGainTime = 0L;
    }

    private static String formatNumber(int number) {
        return String.format("%,d", number);
    }

    private static class XPGainEntry {
        final String pokemonName;
        final int xpGained;
        final int oldLevel;
        final int newLevel;

        XPGainEntry(String pokemonName, int xpGained, int oldLevel, int newLevel) {
            this.pokemonName = pokemonName;
            this.xpGained = xpGained;
            this.oldLevel = oldLevel;
            this.newLevel = newLevel;
        }
    }
}

