/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client.battlelog;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class BattleLogEntry {
    private final int turn;
    private final EntryType type;
    private final Component message;
    private final String translationKey;
    private final long timestamp;
    private volatile List<String> cachedLines;
    private volatile int cachedWidth;
    private volatile float cachedScale;

    public BattleLogEntry(int turn, EntryType type, Component message, String translationKey) {
        this.turn = turn;
        this.type = type;
        this.message = message;
        this.translationKey = translationKey;
        this.timestamp = System.currentTimeMillis();
        this.cachedLines = null;
        this.cachedWidth = -1;
        this.cachedScale = -1.0f;
    }

    public int getTurn() {
        return this.turn;
    }

    public EntryType getType() {
        return this.type;
    }

    public Component getMessage() {
        return this.message;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<String> getCachedLines() {
        return this.cachedLines;
    }

    public void setCachedLines(List<String> lines, int width, float scale) {
        this.cachedLines = new ArrayList<String>(lines);
        this.cachedWidth = width;
        this.cachedScale = scale;
    }

    public boolean isCacheValid(int width, float scale) {
        return this.cachedLines != null && this.cachedWidth == width && Math.abs(this.cachedScale - scale) < 0.01f;
    }

    public void clearCache() {
        this.cachedLines = null;
        this.cachedWidth = -1;
        this.cachedScale = -1.0f;
    }

    public static enum EntryType {
        TURN,
        MOVE,
        HP,
        HEALING,
        EFFECT,
        FIELD,
        OTHER;

    }
}

