/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.BattleSideHelper;
import name.modid.client.TypeChart;
import name.modid.client.TypeIconRenderer;
import name.modid.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class WeaknessTooltipRenderer {
    private static final int TILE_WIDTH = 140;
    private static final int COMPACT_TILE_WIDTH = 128;
    private static final int TILE_HEIGHT = 40;
    private static final int COMPACT_TILE_HEIGHT = 28;
    private static final int HORIZONTAL_INSET = 12;
    private static final int VERTICAL_INSET = 10;
    private static final int HORIZONTAL_SPACING = 4;
    private static final int VERTICAL_SPACING = 40;
    private static final int COMPACT_VERTICAL_SPACING = 30;
    private static final ResourceLocation TYPE_SPRITE_SHEET = ResourceLocation.parse((String)"cobblemon:textures/gui/types.png");
    private static final int ICON_SIZE = 36;
    private static final int SPRITE_SHEET_WIDTH = 648;
    private static final int DISPLAY_ICON_SIZE = 10;
    private static final String[] TYPE_ORDER = new String[]{"normal", "fire", "water", "grass", "electric", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"};
    private static final Map<String, Integer> TYPE_COLORS = new HashMap<String, Integer>();

    public static void init() {
        if (!Services.PLATFORM.isModLoaded("cobblemon")) {
            return;
        }
        Services.EVENTS.registerHudRender((guiGraphics, tickDelta) -> {
            try {
                WeaknessTooltipRenderer.renderWeaknessTooltip(guiGraphics);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("Weakness tooltip renderer initialized", new Object[0]);
    }

    private static void renderWeaknessTooltip(GuiGraphics gui) {
        int tileHeight;
        int tileWidth;
        ClientBattlePokemon battlePokemon;
        if (!BattleExtrasConfig.isWeaknessTooltipEnabled()) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.mouseHandler.isMouseGrabbed()) {
            return;
        }
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        double mouseX = mc.mouseHandler.xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth();
        double mouseY = mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        boolean isCompact = battle.getBattleFormat().getBattleType().getPokemonPerSide() > 1;
        int totalOpponentPokemon = 0;
        for (Object pokemon : opponentSide.getActiveClientBattlePokemon()) {
            ++totalOpponentPokemon;
        }
        int totalPlayerPokemon = 0;
        for (ActiveClientBattlePokemon pokemon : playerSide.getActiveClientBattlePokemon()) {
            ++totalPlayerPokemon;
        }
        if (isCompact || totalPlayerPokemon == 1) {
            int playerSlot = 0;
            for (ClientBattleActor actor : playerSide.getActors()) {
                for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                    battlePokemon = activePokemon.getBattlePokemon();
                    if (battlePokemon == null) continue;
                    tileWidth = isCompact ? 128 : 140;
                    tileHeight = isCompact ? 28 : 40;
                    float x = 12.0f;
                    int y = 10 + playerSlot * (isCompact ? 30 : 40);
                    if (mouseX >= (double)x && mouseX <= (double)(x + (float)tileWidth) && mouseY >= (double)y && mouseY <= (double)(y + tileHeight)) {
                        String pokemonName = battlePokemon.getSpecies().getName();
                        List<String> types = WeaknessTooltipRenderer.getPokemonTypes(battlePokemon, pokemonName, "player");
                        WeaknessTooltipRenderer.renderWeaknessPanel(gui, (int)mouseX, (int)mouseY, types, pokemonName, "player");
                        return;
                    }
                    ++playerSlot;
                }
            }
        }
        if (BattleExtrasConfig.isBattleInfoPanelEnabled()) {
            return;
        }
        int opponentSlot = 0;
        for (ClientBattleActor actor : opponentSide.getActors()) {
            for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                battlePokemon = activePokemon.getBattlePokemon();
                if (battlePokemon == null) continue;
                tileWidth = isCompact ? 128 : 140;
                tileHeight = isCompact ? 28 : 40;
                int slotCount = battle.getBattleFormat().getBattleType().getSlotsPerActor();
                float x = screenWidth - 12 - (slotCount - (totalOpponentPokemon - opponentSlot - 1) - 1) * 4 - tileWidth;
                int y = 10 + (totalOpponentPokemon - opponentSlot - 1) * (isCompact ? 30 : 40);
                if (mouseX >= (double)x && mouseX <= (double)(x + (float)tileWidth) && mouseY >= (double)y && mouseY <= (double)(y + tileHeight)) {
                    String pokemonName = battlePokemon.getSpecies().getName();
                    List<String> types = WeaknessTooltipRenderer.getPokemonTypes(battlePokemon, pokemonName, "opponent");
                    WeaknessTooltipRenderer.renderWeaknessPanel(gui, (int)mouseX, (int)mouseY, types, pokemonName, "opponent");
                    return;
                }
                ++opponentSlot;
            }
        }
    }

    private static List<String> getPokemonTypes(Object battlePokemon, String pokemonName, String side) {
        List<ElementalType> displayTypes;
        ArrayList<String> types = new ArrayList<String>();
        String pokemonUUID = null;
        try {
            Method getUuidMethod = battlePokemon.getClass().getMethod("getUuid", new Class[0]);
            Object uuidObj = getUuidMethod.invoke(battlePokemon, new Object[0]);
            if (uuidObj != null) {
                pokemonUUID = uuidObj.toString();
            }
        }
        catch (Throwable getUuidMethod) {
            // empty catch block
        }
        if (pokemonUUID != null) {
            try {
                String[] opponentTypes;
                Boolean hasOpponentTypes;
                Class<?> randomizerClient = Class.forName("cobblemon.randomizer.client.RandomizerClient");
                String[] wildTypes = (String[])randomizerClient.getMethod("getWildPokemonTypes", String.class).invoke(null, pokemonUUID);
                if (wildTypes != null && wildTypes.length > 0) {
                    for (String typeName : wildTypes) {
                        types.add(typeName.toLowerCase());
                    }
                    CobblemonBattleInfoClient.debug("[WeaknessTooltip] Using wild randomized types for {}: {}", pokemonName, types);
                    return types;
                }
                if ("opponent".equals(side) && (hasOpponentTypes = (Boolean)randomizerClient.getMethod("hasOpponentPokemonTypes", new Class[0]).invoke(null, new Object[0])) != null && hasOpponentTypes.booleanValue() && (opponentTypes = (String[])randomizerClient.getMethod("getOpponentPokemonTypes", String.class).invoke(null, pokemonUUID)) != null && opponentTypes.length > 0) {
                    for (String typeName : opponentTypes) {
                        types.add(typeName.toLowerCase());
                    }
                    CobblemonBattleInfoClient.debug("[WeaknessTooltip] Using PvP opponent randomized types for {}: {}", pokemonName, types);
                    return types;
                }
                if ("player".equals(side)) {
                    Method getTypesForPokemon;
                    String[] randomizedTypes;
                    Method isRunActive = randomizerClient.getMethod("isRunActive", new Class[0]);
                    Method isRandomTypes = randomizerClient.getMethod("isRandomTypes", new Class[0]);
                    if (((Boolean)isRunActive.invoke(null, new Object[0])).booleanValue() && ((Boolean)isRandomTypes.invoke(null, new Object[0])).booleanValue() && (randomizedTypes = (String[])(getTypesForPokemon = randomizerClient.getMethod("getTypesForPokemon", String.class, String.class)).invoke(null, pokemonName, pokemonUUID)) != null && randomizedTypes.length > 0) {
                        for (String typeName : randomizedTypes) {
                            types.add(typeName.toLowerCase());
                        }
                        CobblemonBattleInfoClient.debug("[WeaknessTooltip] Using player randomized types for {}: {}", pokemonName, types);
                        return types;
                    }
                }
            }
            catch (ClassNotFoundException randomizerClient) {
            }
            catch (Throwable t) {
                CobblemonBattleInfoClient.debug("[WeaknessTooltip] Error checking randomizer types: {}", t.getMessage());
            }
        }
        if ((displayTypes = TypeIconRenderer.getDisplayTypes(battlePokemon, pokemonName, side, pokemonUUID)) == null) {
            return types;
        }
        if (!displayTypes.isEmpty()) {
            for (ElementalType type : displayTypes) {
                types.add(type.getName().toLowerCase());
            }
            return types;
        }
        try {
            Method getTypes = battlePokemon.getClass().getMethod("getTypes", new Class[0]);
            Object typesObj = getTypes.invoke(battlePokemon, new Object[0]);
            if (typesObj instanceof Iterable) {
                for (Object type : (Iterable)typesObj) {
                    if (!(type instanceof ElementalType)) continue;
                    types.add(((ElementalType)type).getName().toLowerCase());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return types;
    }

    private static void renderWeaknessPanel(GuiGraphics gui, int mouseX, int mouseY, List<String> defenderTypes, String pokemonName, String side) {
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        boolean isCompact = battle != null && battle.getBattleFormat().getBattleType().getPokemonPerSide() > 1;
        ArrayList<String> superEffective4x = new ArrayList<String>();
        ArrayList<String> superEffective2x = new ArrayList<String>();
        ArrayList<String> immune = new ArrayList<String>();
        for (String attackType : TYPE_ORDER) {
            float effectiveness = WeaknessTooltipRenderer.calculateEffectiveness(attackType, defenderTypes);
            if (effectiveness == 0.0f) {
                immune.add(attackType);
                continue;
            }
            if (effectiveness >= 4.0f) {
                superEffective4x.add(attackType);
                continue;
            }
            if (!(effectiveness >= 2.0f)) continue;
            superEffective2x.add(attackType);
        }
        Map<String, Integer> stats = null;
        boolean hasStatChanges = false;
        if (isCompact) {
            stats = BattleMessageSubscriber.getStatStagesForPokemon(side, pokemonName);
            boolean bl = hasStatChanges = stats != null && !stats.isEmpty() && stats.values().stream().anyMatch(v -> v != null && v != 0);
        }
        if (superEffective4x.isEmpty() && superEffective2x.isEmpty() && immune.isEmpty() && !hasStatChanges) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int iconSpacing = 11;
        int labelWidth = 16;
        int maxIcons = Math.max(Math.max(superEffective4x.size(), superEffective2x.size()), immune.size());
        int iconsWidth = maxIcons * iconSpacing;
        int panelWidth = Math.max(50, labelWidth + iconsWidth + 10);
        int panelHeight = 6;
        int rowCount = 0;
        if (!superEffective4x.isEmpty()) {
            ++rowCount;
        }
        if (!superEffective2x.isEmpty()) {
            ++rowCount;
        }
        if (!immune.isEmpty()) {
            ++rowCount;
        }
        panelHeight += rowCount * 12;
        if (rowCount > 1) {
            panelHeight += (rowCount - 1) * 4;
        }
        int statStageLines = 0;
        if (hasStatChanges) {
            for (Integer val : stats.values()) {
                if (val == null || val == 0) continue;
                ++statStageLines;
            }
            if (statStageLines > 0) {
                panelHeight += 5;
                panelHeight += statStageLines * 8;
            }
        }
        panelHeight += 4;
        int panelX = mouseX - panelWidth - 8;
        int panelY = mouseY + 8;
        if (panelX < 4) {
            panelX = mouseX + 12;
        }
        if (panelY + panelHeight > screenHeight - 4) {
            panelY = mouseY - panelHeight - 8;
        }
        if (panelY < 4) {
            panelY = 4;
        }
        int borderColor = TYPE_COLORS.getOrDefault(defenderTypes.get(0), -8355712);
        int borderColorDark = WeaknessTooltipRenderer.darkenColor(borderColor, 0.6f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        gui.pose().pushPose();
        gui.pose().translate(0.0f, 0.0f, 400.0f);
        WeaknessTooltipRenderer.drawRoundedTooltipBox(gui, panelX, panelY, panelWidth, panelHeight, -535816152, borderColor, borderColorDark);
        int currentY = panelY + 5;
        int separatorColor = WeaknessTooltipRenderer.mixColors(borderColor, -1, 0.4f);
        boolean needsSeparator = false;
        if (!superEffective4x.isEmpty()) {
            if (needsSeparator) {
                WeaknessTooltipRenderer.drawSeparator(gui, panelX + 4, currentY, panelWidth - 8, separatorColor);
                currentY += 4;
            }
            WeaknessTooltipRenderer.renderCompactRow(gui, mc, "\u00a7cx4:", superEffective4x, panelX, currentY, panelWidth);
            currentY += 12;
            needsSeparator = true;
        }
        if (!superEffective2x.isEmpty()) {
            if (needsSeparator) {
                WeaknessTooltipRenderer.drawSeparator(gui, panelX + 4, currentY, panelWidth - 8, separatorColor);
                currentY += 4;
            }
            WeaknessTooltipRenderer.renderCompactRow(gui, mc, "\u00a76x2:", superEffective2x, panelX, currentY, panelWidth);
            currentY += 12;
            needsSeparator = true;
        }
        if (!immune.isEmpty()) {
            if (needsSeparator) {
                WeaknessTooltipRenderer.drawSeparator(gui, panelX + 4, currentY, panelWidth - 8, separatorColor);
                currentY += 4;
            }
            WeaknessTooltipRenderer.renderCompactRow(gui, mc, "\u00a78x0:", immune, panelX, currentY, panelWidth);
            currentY += 12;
        }
        if (hasStatChanges) {
            WeaknessTooltipRenderer.drawSeparator(gui, panelX + 4, currentY, panelWidth - 8, separatorColor);
            WeaknessTooltipRenderer.renderStatStages(gui, mc, stats, panelX + 4, currentY += 5, panelWidth);
        }
        gui.pose().popPose();
        RenderSystem.disableBlend();
    }

    private static void drawRoundedTooltipBox(GuiGraphics gui, int x, int y, int width, int height, int backgroundColor, int borderStart, int borderEnd) {
        int r = 3;
        gui.fill(x + r, y + r, x + width - r, y + height - r, backgroundColor);
        gui.fill(x + r, y + 1, x + width - r, y + r, backgroundColor);
        gui.fill(x + r, y + height - r, x + width - r, y + height - 1, backgroundColor);
        gui.fill(x + 1, y + r, x + r, y + height - r, backgroundColor);
        gui.fill(x + width - r, y + r, x + width - 1, y + height - r, backgroundColor);
        gui.fill(x + 2, y + 2, x + r, y + r, backgroundColor);
        gui.fill(x + width - r, y + 2, x + width - 2, y + r, backgroundColor);
        gui.fill(x + 2, y + height - r, x + r, y + height - 2, backgroundColor);
        gui.fill(x + width - r, y + height - r, x + width - 2, y + height - 2, backgroundColor);
        gui.fillGradient(x + r, y, x + width - r, y + 1, borderStart, borderEnd);
        gui.fillGradient(x + r, y + height - 1, x + width - r, y + height, borderEnd, borderStart);
        gui.fillGradient(x, y + r, x + 1, y + height - r, borderStart, borderEnd);
        gui.fillGradient(x + width - 1, y + r, x + width, y + height - r, borderEnd, borderStart);
        gui.fill(x + 1, y + 2, x + 2, y + r, borderStart);
        gui.fill(x + 2, y + 1, x + r, y + 2, borderStart);
        int topRightColor = WeaknessTooltipRenderer.mixColors(borderStart, borderEnd, 0.5f);
        gui.fill(x + width - 2, y + 2, x + width - 1, y + r, topRightColor);
        gui.fill(x + width - r, y + 1, x + width - 2, y + 2, topRightColor);
        int bottomLeftColor = WeaknessTooltipRenderer.mixColors(borderStart, borderEnd, 0.5f);
        gui.fill(x + 1, y + height - r, x + 2, y + height - 2, bottomLeftColor);
        gui.fill(x + 2, y + height - 2, x + r, y + height - 1, bottomLeftColor);
        gui.fill(x + width - 2, y + height - r, x + width - 1, y + height - 2, borderEnd);
        gui.fill(x + width - r, y + height - 2, x + width - 2, y + height - 1, borderEnd);
    }

    private static void drawSeparator(GuiGraphics gui, int x, int y, int width, int color) {
        int lineColor = color & 0xFFFFFF | 0x40000000;
        gui.fill(x, y, x + width, y + 1, lineColor);
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * (1.0f - ratio) + (float)a2 * ratio);
        int r = (int)((float)r1 * (1.0f - ratio) + (float)r2 * ratio);
        int g = (int)((float)g1 * (1.0f - ratio) + (float)g2 * ratio);
        int b = (int)((float)b1 * (1.0f - ratio) + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static void renderStatStages(GuiGraphics gui, Minecraft mc, Map<String, Integer> stats, int x, int y, int panelWidth) {
        int currentY = y;
        for (Map.Entry<String, Integer> entry : stats.entrySet()) {
            Integer val = entry.getValue();
            if (val == null || val == 0) continue;
            String statLabel = WeaknessTooltipRenderer.abbreviateStatKey(entry.getKey());
            String arrow = val > 0 ? "\u2191" : "\u2193";
            String sign = val > 0 ? "+" : "";
            String text = arrow + " " + statLabel + " " + sign + val;
            int color = val > 0 ? -11141291 : -43691;
            gui.pose().pushPose();
            gui.pose().translate((float)x, (float)currentY, 0.0f);
            gui.pose().scale(0.6f, 0.6f, 1.0f);
            gui.drawString(mc.font, text, 0, 0, color, true);
            gui.pose().popPose();
            currentY += 8;
        }
    }

    private static String abbreviateStatKey(String raw) {
        if (raw == null) {
            return "";
        }
        String s = raw.trim().toUpperCase();
        if (s.isEmpty()) {
            return s;
        }
        switch (s) {
            case "ATK": 
            case "DEF": 
            case "SPE": 
            case "ACC": 
            case "EVA": 
            case "CRIT": {
                return s;
            }
            case "SP.ATK": 
            case "SP.AT": 
            case "SPATK": 
            case "SPA": {
                return "SP.ATK";
            }
            case "SP.DEF": 
            case "SPDEF": 
            case "SPD": {
                return "SP.DEF";
            }
        }
        String lower = s.toLowerCase();
        if (lower.contains("special") && lower.contains("attack")) {
            return "SP.ATK";
        }
        if (lower.contains("special") && lower.contains("def")) {
            return "SP.DEF";
        }
        if (lower.contains("attack")) {
            return "ATK";
        }
        if (lower.contains("defense") || lower.contains("defence")) {
            return "DEF";
        }
        if (lower.contains("speed")) {
            return "SPE";
        }
        if (lower.contains("accuracy")) {
            return "ACC";
        }
        if (lower.contains("evasion")) {
            return "EVA";
        }
        if (lower.contains("crit")) {
            return "CRIT";
        }
        return s;
    }

    private static void renderCompactRow(GuiGraphics gui, Minecraft mc, String label, List<String> types, int x, int y, int panelWidth) {
        gui.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int iconSpacing = 11;
        int labelWidth = (int)((float)mc.font.width(label) * 0.8f);
        int iconsWidth = types.size() * iconSpacing;
        int totalWidth = labelWidth + 2 + iconsWidth;
        int startX = x + (panelWidth - totalWidth) / 2;
        int labelYOffset = 2;
        gui.pose().pushPose();
        gui.pose().translate((float)startX, (float)(y + labelYOffset), 0.0f);
        gui.pose().scale(0.8f, 0.8f, 1.0f);
        gui.drawString(mc.font, label, 0, 0, 0xFFFFFF, false);
        gui.pose().popPose();
        int iconsStartX = startX + labelWidth + 2;
        for (int i = 0; i < types.size(); ++i) {
            WeaknessTooltipRenderer.renderTypeIcon(gui, types.get(i), iconsStartX + i * iconSpacing, y);
        }
    }

    private static void renderTypeIcon(GuiGraphics gui, String typeName, int x, int y) {
        int typeIndex = WeaknessTooltipRenderer.getTypeIndex(typeName);
        if (typeIndex < 0) {
            return;
        }
        int u = typeIndex * 36;
        gui.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        gui.blit(TYPE_SPRITE_SHEET, x, y, 10, 10, (float)u, 0.0f, 36, 36, 648, 36);
        gui.flush();
    }

    private static int getTypeIndex(String typeName) {
        for (int i = 0; i < TYPE_ORDER.length; ++i) {
            if (!TYPE_ORDER[i].equalsIgnoreCase(typeName)) continue;
            return i;
        }
        return -1;
    }

    private static float calculateEffectiveness(String attackType, List<String> defenderTypes) {
        if (defenderTypes.isEmpty()) {
            return 1.0f;
        }
        String defenderType1 = defenderTypes.get(0);
        String defenderType2 = defenderTypes.size() > 1 ? defenderTypes.get(1) : null;
        return TypeChart.getEffectivenessAgainstTypes(attackType, defenderType1, defenderType2);
    }

    private static int darkenColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    static {
        TYPE_COLORS.put("normal", -5724040);
        TYPE_COLORS.put("fire", -1015760);
        TYPE_COLORS.put("water", -9924368);
        TYPE_COLORS.put("electric", -470992);
        TYPE_COLORS.put("grass", -8861616);
        TYPE_COLORS.put("ice", -6760232);
        TYPE_COLORS.put("fighting", -4181976);
        TYPE_COLORS.put("poison", -6274912);
        TYPE_COLORS.put("ground", -2047896);
        TYPE_COLORS.put("flying", -5730064);
        TYPE_COLORS.put("psychic", -501624);
        TYPE_COLORS.put("bug", -5720032);
        TYPE_COLORS.put("rock", -4677576);
        TYPE_COLORS.put("ghost", -9414504);
        TYPE_COLORS.put("dragon", -9422600);
        TYPE_COLORS.put("dark", -9414584);
        TYPE_COLORS.put("steel", -4671280);
        TYPE_COLORS.put("fairy", -1140308);
    }
}

