/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.mojang.blaze3d.systems.RenderSystem;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleOpacityHelper;
import name.modid.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TurnCounterRenderer {
    private static int currentTurn = 0;
    private static final ResourceLocation TURNBAR_TEXTURE = ResourceLocation.parse((String)"cobblemon-battle-extras:textures/gui/turnbar.png");
    private static final int TURNBAR_WIDTH = 80;
    private static final int TURNBAR_HEIGHT = 10;

    public static void init() {
        Services.EVENTS.registerHudRender((gui, tickDelta) -> {
            try {
                TurnCounterRenderer.render(gui);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("Turn counter renderer initialized", new Object[0]);
    }

    public static void setTurn(int turn) {
        currentTurn = turn;
        CobblemonBattleInfoClient.debug("Turn counter set to: {}", turn);
    }

    public static int getCurrentTurn() {
        return currentTurn;
    }

    public static void reset() {
        currentTurn = 0;
    }

    private static void render(GuiGraphics gui) {
        if (!BattleExtrasConfig.isTurnCounterEnabled()) {
            return;
        }
        if (CobblemonClient.INSTANCE.getBattle() == null) {
            return;
        }
        if (currentTurn <= 0) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.player == null) {
            return;
        }
        Font font = mc.font;
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        float opacity = BattleOpacityHelper.getBattleOpacity();
        MutableComponent turnText = Component.translatable((String)"battle.turn_counter", (Object[])new Object[]{currentTurn});
        String text = turnText.getString();
        int textWidth = font.width(text);
        int barX = (screenWidth - 80) / 2;
        int barY = 5;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TURNBAR_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        gui.blit(TURNBAR_TEXTURE, barX, barY, 0.0f, 0.0f, 80, 10, 80, 10);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textColor = BattleOpacityHelper.applyOpacity(-1, opacity);
        int textX = barX + (80 - textWidth) / 2;
        int textY = barY + 1;
        gui.drawString(font, text, textX, textY, textColor, true);
    }
}

