/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import java.util.UUID;
import net.minecraft.client.Minecraft;

public class BattleSideHelper {
    public static boolean isSide1Player(ClientBattle battle) {
        if (battle == null) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return false;
        }
        UUID playerUUID = mc.player.getUUID();
        for (ClientBattleActor actor : battle.getSide1().getActors()) {
            if (!actor.getUuid().equals(playerUUID)) continue;
            return true;
        }
        return false;
    }

    public static ClientBattleSide getPlayerSide(ClientBattle battle) {
        if (battle == null) {
            return null;
        }
        return BattleSideHelper.isSide1Player(battle) ? battle.getSide1() : battle.getSide2();
    }

    public static ClientBattleSide getOpponentSide(ClientBattle battle) {
        if (battle == null) {
            return null;
        }
        return BattleSideHelper.isSide1Player(battle) ? battle.getSide2() : battle.getSide1();
    }

    public static boolean isSpectating(ClientBattle battle) {
        if (battle == null) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return false;
        }
        UUID playerUUID = mc.player.getUUID();
        for (ClientBattleActor actor : battle.getSide1().getActors()) {
            if (!actor.getUuid().equals(playerUUID)) continue;
            return false;
        }
        for (ClientBattleActor actor : battle.getSide2().getActors()) {
            if (!actor.getUuid().equals(playerUUID)) continue;
            return false;
        }
        return true;
    }
}

