/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.cobblemon.mod.common.client.battle.SingleActionRequest;
import java.io.BufferedWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.BattleSideHelper;
import name.modid.client.battlelog.BattleLogManager;
import name.modid.client.battlelog.DamageTracker;
import name.modid.client.battlelog.EnhancedBattleLogWidget;
import name.modid.client.battlelog.XPTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BattleLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BattleLogger");
    private static boolean isRecording = false;
    private static BattleLogEntry currentLog = null;
    private static String currentOpponentName = null;
    private static String currentOpponentUUID = null;
    private static boolean isPvPBattle = false;
    private static BattleType currentBattleType = BattleType.UNKNOWN;
    private static final List<String> earlyMessageBuffer = new CopyOnWriteArrayList<String>();
    private static long lastEarlyMessageTime = 0L;
    private static final long EARLY_MESSAGE_TIMEOUT = 5000L;
    private static final List<BattleLogEntry> recentLogs = new CopyOnWriteArrayList<BattleLogEntry>();
    private static final int MAX_RECENT_LOGS = 50;
    private static Path logDirectory = null;
    private static String pendingOpponentName = null;

    public static void init() {
        try {
            Path gameDir = Minecraft.getInstance().gameDirectory.toPath();
            logDirectory = gameDir.resolve("cobblemon-battle-logs");
            Files.createDirectories(logDirectory, new FileAttribute[0]);
            CobblemonBattleInfoClient.debug("[BattleLogger] Log directory: {}", logDirectory);
            BattleLogger.loadRecentLogsIndex();
        }
        catch (Exception e) {
            LOGGER.error("[BattleLogger] Failed to initialize: {}", (Object)e.getMessage());
        }
    }

    public static void onBattleStart() {
        try {
            BattleParticipantInfo opponentInfo;
            ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
            if (battle == null) {
                return;
            }
            if (BattleSideHelper.isSpectating(battle)) {
                isPvPBattle = false;
                isRecording = false;
                currentBattleType = BattleType.UNKNOWN;
                earlyMessageBuffer.clear();
                BattleLogManager.onBattleStart();
                DamageTracker.clear();
                EnhancedBattleLogWidget.clear();
                XPTracker.onBattleStart();
                CobblemonBattleInfoClient.debug("[BattleLogger] Spectating battle - not recording to file", new Object[0]);
                return;
            }
            BattleType messageBasedType = BattleLogger.detectBattleTypeFromMessages();
            CobblemonBattleInfoClient.debug("[BattleLogger] Message-based detection result: {}, buffer size: {}", new Object[]{messageBasedType, earlyMessageBuffer.size()});
            if (!earlyMessageBuffer.isEmpty()) {
                CobblemonBattleInfoClient.debug("[BattleLogger] First buffered message: '{}'", earlyMessageBuffer.get(0));
            }
            if ((opponentInfo = BattleLogger.getOpponentInfo(battle)) == null) {
                currentBattleType = BattleType.UNKNOWN;
                isPvPBattle = false;
                isRecording = false;
                LOGGER.warn("[BattleLogger] Could not get opponent info, not recording");
                return;
            }
            CobblemonBattleInfoClient.debug("[BattleLogger] API-based detection: battleType={}, opponentName='{}', uuid='{}'", new Object[]{opponentInfo.battleType, opponentInfo.name, opponentInfo.uuid});
            if (opponentInfo.battleType == BattleType.WILD) {
                currentBattleType = BattleType.WILD;
                CobblemonBattleInfoClient.debug("[BattleLogger] API detected WILD battle - NOT RECORDING", new Object[0]);
            } else if (messageBasedType == BattleType.WILD) {
                currentBattleType = BattleType.WILD;
                CobblemonBattleInfoClient.debug("[BattleLogger] Message detection says WILD battle (first msg is 'Go!') - NOT RECORDING", new Object[0]);
            } else {
                currentBattleType = opponentInfo.battleType;
                CobblemonBattleInfoClient.debug("[BattleLogger] Using API battle type: {}", new Object[]{currentBattleType});
            }
            if (currentBattleType == BattleType.PVP || currentBattleType == BattleType.NPC) {
                if (!BattleExtrasConfig.isBattleLogRecordingEnabled()) {
                    isPvPBattle = false;
                    isRecording = false;
                    earlyMessageBuffer.clear();
                    BattleLogManager.onBattleStart();
                    DamageTracker.clear();
                    XPTracker.onBattleStart();
                    CobblemonBattleInfoClient.debug("[BattleLogger] Battle log recording disabled in config, not recording to file", new Object[0]);
                    return;
                }
                isPvPBattle = currentBattleType == BattleType.PVP;
                isRecording = true;
                currentOpponentName = opponentInfo.name;
                currentOpponentUUID = opponentInfo.uuid;
                BattleLogManager.onBattleStart();
                DamageTracker.clear();
                EnhancedBattleLogWidget.clear();
                XPTracker.onBattleStart();
                String playerName = Minecraft.getInstance().player != null ? Minecraft.getInstance().player.getName().getString() : "Unknown";
                currentLog = new BattleLogEntry();
                BattleLogger.currentLog.playerName = playerName;
                BattleLogger.currentLog.opponentName = currentOpponentName;
                BattleLogger.currentLog.opponentUUID = currentOpponentUUID;
                BattleLogger.currentLog.battleType = currentBattleType;
                BattleLogger.currentLog.startTime = System.currentTimeMillis();
                BattleLogger.currentLog.date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                BattleLogger.currentLog.playerTeam = BattleLogger.getPlayerTeam(battle, true);
                BattleLogger.currentLog.opponentTeam = BattleLogger.getPlayerTeam(battle, false);
                String battleTypeStr = currentBattleType == BattleType.PVP ? "PvP" : "NPC/Trainer";
                CobblemonBattleInfoClient.debug("[BattleLogger] Started recording {} battle: {} vs {}", battleTypeStr, playerName, currentOpponentName);
                BattleLogger.addLogMessage("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                BattleLogger.addLogMessage("                    BATTLE START");
                BattleLogger.addLogMessage("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                BattleLogger.addLogMessage("");
                BattleLogger.addLogMessage("Battle Type: " + battleTypeStr);
                BattleLogger.addLogMessage("Date: " + BattleLogger.currentLog.date);
                BattleLogger.addLogMessage(playerName + " vs " + currentOpponentName);
                BattleLogger.addLogMessage("");
                BattleLogger.addLogMessage("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                BattleLogger.addLogMessage("");
                if (!earlyMessageBuffer.isEmpty()) {
                    CobblemonBattleInfoClient.debug("[BattleLogger] Replaying {} early messages", earlyMessageBuffer.size());
                    for (String earlyMsg : earlyMessageBuffer) {
                        BattleLogger.processAndAddMessage(earlyMsg);
                    }
                    earlyMessageBuffer.clear();
                }
            } else {
                isPvPBattle = false;
                isRecording = false;
                currentBattleType = BattleType.WILD;
                earlyMessageBuffer.clear();
                BattleLogManager.onBattleStart();
                DamageTracker.clear();
                XPTracker.onBattleStart();
                CobblemonBattleInfoClient.debug("[BattleLogger] Wild battle detected, not recording", new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("[BattleLogger] Error starting battle log: {}", (Object)e.getMessage());
        }
    }

    public static void onBattleEnd(String result) {
        BattleLogManager.onBattleEnd();
        DamageTracker.clear();
        XPTracker.onBattleEnd();
        if (!isRecording || currentLog == null) {
            BattleLogger.reset();
            return;
        }
        try {
            BattleLogger.currentLog.endTime = System.currentTimeMillis();
            BattleLogger.currentLog.result = result != null ? result : "Unknown";
            BattleLogger.addLogMessage("");
            BattleLogger.addLogMessage("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            BattleLogger.addLogMessage("                     BATTLE END");
            BattleLogger.addLogMessage("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            BattleLogger.addLogMessage("");
            BattleLogger.addLogMessage("Result: " + BattleLogger.currentLog.result);
            BattleLogger.addLogMessage("Duration: " + BattleLogger.formatDuration(BattleLogger.currentLog.endTime - BattleLogger.currentLog.startTime));
            BattleLogger.addLogMessage("");
            BattleLogger.addLogMessage("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            BattleLogger.saveBattleLog(currentLog);
            CobblemonBattleInfoClient.debug("[BattleLogger] Battle ended. Result: {}", result);
        }
        catch (Exception e) {
            LOGGER.error("[BattleLogger] Error ending battle log: {}", (Object)e.getMessage());
        }
        finally {
            BattleLogger.reset();
        }
    }

    public static void addBattleMessage(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        String cleanMessage = message.trim();
        if (cleanMessage.isEmpty()) {
            return;
        }
        if (!isRecording || currentLog == null) {
            long now = System.currentTimeMillis();
            if (now - lastEarlyMessageTime > 5000L) {
                earlyMessageBuffer.clear();
            }
            earlyMessageBuffer.add(cleanMessage);
            lastEarlyMessageTime = now;
            CobblemonBattleInfoClient.debug("[BattleLogger] Buffered early message: '{}'", cleanMessage);
            return;
        }
        BattleLogger.processAndAddMessage(cleanMessage);
    }

    private static void processAndAddMessage(String cleanMessage) {
        if (currentLog == null) {
            return;
        }
        String lower = cleanMessage.toLowerCase();
        if (pendingOpponentName != null && lower.endsWith("!") && !lower.contains(" ") && Character.isUpperCase(cleanMessage.charAt(0))) {
            String pokemonName = cleanMessage.substring(0, cleanMessage.length() - 1).trim();
            if (!pokemonName.isEmpty() && pokemonName.length() > 1 && pokemonName.length() < 20) {
                BattleLogger.addOpponentPokemon(pokemonName);
                CobblemonBattleInfoClient.debug("[BattleLogger] Tracked opponent Pokemon from standalone name: {}", pokemonName);
            }
            pendingOpponentName = null;
        } else if (lower.startsWith("out ") && pendingOpponentName != null) {
            String afterOut = cleanMessage.substring(4);
            int endIdx = afterOut.indexOf(33);
            if (endIdx > 0) {
                String pokemonName = afterOut.substring(0, endIdx).trim();
                BattleLogger.addOpponentPokemon(pokemonName);
                CobblemonBattleInfoClient.debug("[BattleLogger] Tracked opponent Pokemon from 'out' continuation: {}", pokemonName);
            }
            pendingOpponentName = null;
        } else if (lower.startsWith("sent out ") && pendingOpponentName != null) {
            String afterSentOut = cleanMessage.substring(9);
            int endIdx = afterSentOut.indexOf(33);
            if (endIdx > 0) {
                String pokemonName = afterSentOut.substring(0, endIdx).trim();
                BattleLogger.addOpponentPokemon(pokemonName);
                CobblemonBattleInfoClient.debug("[BattleLogger] Tracked opponent Pokemon from 'sent out' continuation: {}", pokemonName);
            }
            pendingOpponentName = null;
        } else if (lower.contains(" sent out ") && !lower.startsWith("go!")) {
            String afterSentOut;
            int endIdx;
            int sentOutIdx = lower.indexOf(" sent out ");
            if (sentOutIdx > 0 && (endIdx = (afterSentOut = cleanMessage.substring(sentOutIdx + 10)).indexOf(33)) > 0) {
                String pokemonName = afterSentOut.substring(0, endIdx).trim();
                BattleLogger.addOpponentPokemon(pokemonName);
                CobblemonBattleInfoClient.debug("[BattleLogger] Tracked opponent Pokemon from full 'sent out': {}", pokemonName);
            }
            pendingOpponentName = null;
        } else if (lower.endsWith(" sent")) {
            int sentIdx = lower.lastIndexOf(" sent");
            if (sentIdx > 0) {
                pendingOpponentName = cleanMessage.substring(0, sentIdx).trim();
                CobblemonBattleInfoClient.debug("[BattleLogger] Pending 'sent' - waiting for 'out [Pokemon]!' from: {}", pendingOpponentName);
            }
        } else if (lower.endsWith(" sent out")) {
            int sentOutIdx = lower.lastIndexOf(" sent out");
            if (sentOutIdx > 0) {
                pendingOpponentName = cleanMessage.substring(0, sentOutIdx).trim();
                CobblemonBattleInfoClient.debug("[BattleLogger] Pending 'sent out' - waiting for '[Pokemon]!' from: {}", pendingOpponentName);
            }
        } else {
            pendingOpponentName = !lower.contains("'s ") && !lower.endsWith("!") && !lower.endsWith(".") && !lower.startsWith("go!") && !lower.contains(" used ") && !lower.contains("fainted") && !lower.contains("turn") && !lower.equals("") ? cleanMessage : null;
        }
        BattleLogger.trackOpponentPokemonFromMessage(cleanMessage);
        if (lower.contains("turn")) {
            BattleLogger.addLogMessage("");
            BattleLogger.addLogMessage("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        }
        BattleLogger.addLogMessage(cleanMessage);
    }

    private static void trackOpponentPokemonFromMessage(String message) {
        boolean isOnTargetMessage;
        if (currentLog == null) {
            return;
        }
        String playerName = BattleLogger.currentLog.playerName;
        if (playerName == null || playerName.isEmpty()) {
            return;
        }
        String lower = message.toLowerCase();
        boolean isSentOutMessage = lower.contains("sent out ");
        boolean isUsedMessage = lower.contains(" used ");
        boolean bl = isOnTargetMessage = lower.contains(" on ") && lower.endsWith("!");
        if (!(isSentOutMessage || isUsedMessage || isOnTargetMessage)) {
            return;
        }
        int apostropheIdx = message.indexOf("'s ");
        while (apostropheIdx > 0) {
            int nextIdx;
            String ownerName = message.substring(0, apostropheIdx);
            if (ownerName.toLowerCase().startsWith("on ")) {
                ownerName = ownerName.substring(3);
            }
            if (!ownerName.equals(playerName) && !ownerName.endsWith(playerName)) {
                String pokemonName;
                String afterApostrophe = message.substring(apostropheIdx + 3);
                int endIdx = -1;
                for (int i = 0; i < afterApostrophe.length(); ++i) {
                    char c = afterApostrophe.charAt(i);
                    if (c != ' ' && c != '!' && c != '.' && c != '\'') continue;
                    endIdx = i;
                    break;
                }
                if (!(pokemonName = endIdx > 0 ? afterApostrophe.substring(0, endIdx).trim() : afterApostrophe.trim()).isEmpty() && pokemonName.length() > 1 && pokemonName.length() < 20 && Character.isUpperCase(pokemonName.charAt(0))) {
                    BattleLogger.addOpponentPokemon(pokemonName);
                }
            }
            if ((nextIdx = message.indexOf("'s ", apostropheIdx + 3)) <= apostropheIdx) break;
            apostropheIdx = nextIdx;
        }
    }

    private static void addOpponentPokemon(String pokemonName) {
        String capitalizedName;
        if (pokemonName == null || pokemonName.isEmpty() || currentLog == null) {
            return;
        }
        if (pokemonName.contains("(") && pokemonName.contains(")")) {
            int parenStart = pokemonName.indexOf(40);
            int parenEnd = pokemonName.indexOf(41);
            if (parenEnd > parenStart) {
                pokemonName = pokemonName.substring(parenStart + 1, parenEnd).trim();
            }
        }
        String lowerName = pokemonName.toLowerCase();
        Set<String> blacklist = Set.of("drizzle", "drought", "intimidate", "pressure", "levitate", "synchronize", "blaze", "torrent", "overgrow", "swarm", "guts", "marvel", "scale", "hp", "attack", "defense", "special", "speed", "accuracy", "evasion", "evasiveness", "stat", "stats", "turn", "move", "moves", "ability", "type", "types", "team", "power", "effect", "effects", "status", "condition", "the", "and", "for", "was", "has", "had", "will", "can", "lost", "restored", "rose", "fell", "sharply", "harshly", "drastically");
        if (blacklist.contains(lowerName)) {
            return;
        }
        if (!pokemonName.isEmpty() && !BattleLogger.currentLog.opponentTeam.contains(capitalizedName = pokemonName.substring(0, 1).toUpperCase() + pokemonName.substring(1).toLowerCase())) {
            BattleLogger.currentLog.opponentTeam.add(capitalizedName);
            CobblemonBattleInfoClient.debug("[BattleLogger] Added opponent Pokemon to team: {}", capitalizedName);
        }
    }

    private static void addLogMessage(String message) {
        if (currentLog != null) {
            BattleLogger.currentLog.messages.add(message);
        }
    }

    private static void saveBattleLog(BattleLogEntry log) {
        if (logDirectory == null) {
            BattleLogger.init();
        }
        try {
            String dateStr = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date(log.startTime));
            String safeName = BattleLogger.sanitizeFileName(log.opponentName);
            String prefix = log.battleType == BattleType.PVP ? "PvP" : (log.battleType == BattleType.NPC ? "NPC" : "Battle");
            String fileName = String.format("%s_%sVs%s_%s.txt", prefix, BattleLogger.sanitizeFileName(log.playerName), safeName, dateStr);
            Path logFile = logDirectory.resolve(fileName);
            log.fileName = fileName;
            try (BufferedWriter writer = Files.newBufferedWriter(logFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                for (String line : log.messages) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            recentLogs.add(0, log);
            while (recentLogs.size() > 50) {
                recentLogs.remove(recentLogs.size() - 1);
            }
            BattleLogger.saveRecentLogsIndex();
            CobblemonBattleInfoClient.debug("[BattleLogger] Saved battle log: {}", fileName);
            if (Minecraft.getInstance().player != null && BattleExtrasConfig.isBattleLogRecordingEnabled() && BattleExtrasConfig.isBattleLogChatMessagesEnabled()) {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"message.cobblemon-battle-extras.battle_log.saved", (Object[])new Object[]{fileName}), false);
            }
        }
        catch (Exception e) {
            LOGGER.error("[BattleLogger] Failed to save battle log: {}", (Object)e.getMessage());
        }
    }

    private static BattleType detectBattleTypeFromMessages() {
        String lower;
        if (earlyMessageBuffer.isEmpty()) {
            return BattleType.UNKNOWN;
        }
        for (int i = 0; i < earlyMessageBuffer.size(); ++i) {
            String nextMsg;
            String msg = earlyMessageBuffer.get(i);
            lower = msg.toLowerCase().trim();
            if ((lower.endsWith(" sent") || lower.endsWith("sent")) && i + 1 < earlyMessageBuffer.size() && (nextMsg = earlyMessageBuffer.get(i + 1).toLowerCase().trim()).startsWith("out ")) {
                CobblemonBattleInfoClient.debug("[BattleLogger] Detected split 'sent' + 'out' pattern - NPC/Trainer battle", new Object[0]);
                return BattleType.NPC;
            }
            if (!lower.contains("sent out")) continue;
            CobblemonBattleInfoClient.debug("[BattleLogger] Detected 'sent out' in message - NPC/Trainer battle", new Object[0]);
            return BattleType.NPC;
        }
        for (String msg : earlyMessageBuffer) {
            lower = msg.toLowerCase().trim();
            if (lower.isEmpty() || !lower.contains("!") && !lower.contains(".") && !lower.contains("turn") || !lower.startsWith("go!")) continue;
            CobblemonBattleInfoClient.debug("[BattleLogger] Detected 'Go!' as first action message - WILD battle", new Object[0]);
            return BattleType.WILD;
        }
        return BattleType.UNKNOWN;
    }

    private static BattleParticipantInfo getOpponentInfo(ClientBattle battle) {
        try {
            ClientBattleSide opponentSide;
            List actors;
            ClientBattleSide side1 = battle.getSide1();
            ClientBattleSide side2 = battle.getSide2();
            if (side1 == null || side2 == null) {
                return null;
            }
            SingleActionRequest request = battle.getFirstUnansweredRequest();
            boolean side1IsPlayer = true;
            if (request != null && request.getActivePokemon() != null) {
                ClientBattleActor requestActor = request.getActivePokemon().getActor();
                side1IsPlayer = side1.getActors().stream().anyMatch(a -> a == requestActor);
            }
            if ((actors = (opponentSide = side1IsPlayer ? side2 : side1).getActors()).isEmpty()) {
                return null;
            }
            ClientBattleActor firstActor = (ClientBattleActor)actors.get(0);
            BattleParticipantInfo info = new BattleParticipantInfo();
            try {
                Method getDisplayName = firstActor.getClass().getMethod("getDisplayName", new Class[0]);
                Object displayName = getDisplayName.invoke((Object)firstActor, new Object[0]);
                if (displayName != null) {
                    try {
                        Method getString = displayName.getClass().getMethod("getString", new Class[0]);
                        info.name = (String)getString.invoke(displayName, new Object[0]);
                    }
                    catch (Exception e) {
                        info.name = displayName.toString();
                    }
                }
            }
            catch (Exception e) {
                try {
                    Method getName = firstActor.getClass().getMethod("getName", new Class[0]);
                    Object name = getName.invoke((Object)firstActor, new Object[0]);
                    if (name != null) {
                        info.name = name.toString();
                    }
                }
                catch (Exception getName) {
                    // empty catch block
                }
            }
            try {
                Method getUuid = firstActor.getClass().getMethod("getUuid", new Class[0]);
                Object uuid = getUuid.invoke((Object)firstActor, new Object[0]);
                if (uuid != null) {
                    info.uuid = uuid.toString();
                }
            }
            catch (Exception e) {
                try {
                    Method getPlayerUUID = firstActor.getClass().getMethod("getPlayerUUID", new Class[0]);
                    Object uuid = getPlayerUUID.invoke((Object)firstActor, new Object[0]);
                    if (uuid != null) {
                        info.uuid = uuid.toString();
                    }
                }
                catch (Exception getPlayerUUID) {
                    // empty catch block
                }
            }
            boolean hasValidUuid = info.uuid != null && !info.uuid.isEmpty() && !info.uuid.equals("00000000-0000-0000-0000-000000000000");
            boolean isPlayerActor = false;
            boolean isWildActor = false;
            String actorTypeString = "UNKNOWN";
            try {
                ActorType actorType = firstActor.getType();
                actorTypeString = actorType != null ? actorType.toString().toUpperCase() : "UNKNOWN";
                isPlayerActor = actorTypeString.equals("PLAYER");
                isWildActor = actorTypeString.equals("WILD");
                CobblemonBattleInfoClient.debug("[BattleLogger] Opponent actor type: {}, isPlayer: {}, isWild: {}", actorTypeString, isPlayerActor, isWildActor);
            }
            catch (Exception e) {
                isPlayerActor = hasValidUuid;
                CobblemonBattleInfoClient.debug("[BattleLogger] Failed to get actor type, fallback to UUID check: hasValidUuid={}", hasValidUuid);
            }
            if (info.name == null || info.name.isEmpty()) {
                info.name = "Opponent";
            }
            String lowerName = info.name.toLowerCase();
            if (isWildActor) {
                info.battleType = BattleType.WILD;
                CobblemonBattleInfoClient.debug("[BattleLogger] Detected WILD battle from actor type", new Object[0]);
            } else if (lowerName.contains("wild")) {
                info.battleType = BattleType.WILD;
                CobblemonBattleInfoClient.debug("[BattleLogger] Detected WILD battle from name containing 'wild'", new Object[0]);
            } else if (isPlayerActor && hasValidUuid) {
                info.battleType = BattleType.PVP;
                CobblemonBattleInfoClient.debug("[BattleLogger] Detected PVP battle from PLAYER actor type with valid UUID", new Object[0]);
            } else if (actorTypeString.equals("NPC")) {
                info.battleType = BattleType.NPC;
                CobblemonBattleInfoClient.debug("[BattleLogger] Detected NPC battle from actor type: opponent name = {}", info.name);
            } else if (!lowerName.isEmpty() && !lowerName.equals("opponent")) {
                info.battleType = BattleType.NPC;
                CobblemonBattleInfoClient.debug("[BattleLogger] Detected NPC battle from name: opponent name = {}", info.name);
            } else if (!(lowerName.isEmpty() || lowerName.equals("opponent") || lowerName.equals("unknown"))) {
                info.battleType = BattleType.NPC;
                LOGGER.warn("[BattleLogger] Unknown actor type '{}', but treating as NPC due to name: {}", (Object)actorTypeString, (Object)info.name);
            } else {
                info.battleType = BattleType.UNKNOWN;
                CobblemonBattleInfoClient.debug("[BattleLogger] Unknown battle type", new Object[0]);
            }
            return info;
        }
        catch (Exception e) {
            LOGGER.error("[BattleLogger] Error getting opponent info: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static List<String> getPlayerTeam(ClientBattle battle, boolean isPlayerSide) {
        List<String> team;
        block13: {
            team = new ArrayList<String>();
            try {
                ClientBattleSide targetSide;
                ClientBattleSide side1 = battle.getSide1();
                ClientBattleSide side2 = battle.getSide2();
                SingleActionRequest request = battle.getFirstUnansweredRequest();
                boolean side1IsPlayer = true;
                if (request != null && request.getActivePokemon() != null) {
                    ClientBattleActor requestActor = request.getActivePokemon().getActor();
                    side1IsPlayer = side1.getActors().stream().anyMatch(a -> a == requestActor);
                }
                ClientBattleSide clientBattleSide = isPlayerSide ? (side1IsPlayer ? side1 : side2) : (targetSide = side1IsPlayer ? side2 : side1);
                if (targetSide == null) {
                    if (!isPlayerSide) {
                        return BattleLogger.formatTrackedOpponentTeam();
                    }
                    return team;
                }
                List actors = targetSide.getActors();
                for (ClientBattleActor actor : actors) {
                    try {
                        Method getPokemon = actor.getClass().getMethod("getPokemon", new Class[0]);
                        Object pokemonList = getPokemon.invoke((Object)actor, new Object[0]);
                        if (!(pokemonList instanceof Iterable)) continue;
                        for (Object pokemon : (Iterable)pokemonList) {
                            String pokemonName = BattleLogger.getPokemonDisplayName(pokemon);
                            if (pokemonName == null || pokemonName.isEmpty()) continue;
                            team.add(pokemonName);
                        }
                    }
                    catch (Exception e) {
                        try {
                            Method getActive = actor.getClass().getMethod("getActivePokemon", new Class[0]);
                            Object activeList = getActive.invoke((Object)actor, new Object[0]);
                            if (!(activeList instanceof Iterable)) continue;
                            for (Object active : (Iterable)activeList) {
                                String name;
                                Method getBattlePokemon = active.getClass().getMethod("getBattlePokemon", new Class[0]);
                                Object battlePokemon = getBattlePokemon.invoke(active, new Object[0]);
                                if (battlePokemon == null || (name = BattleLogger.getPokemonDisplayName(battlePokemon)) == null || team.contains(name)) continue;
                                team.add(name);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (!isPlayerSide && team.isEmpty()) {
                    team = BattleLogger.formatTrackedOpponentTeam();
                }
            }
            catch (Exception e) {
                CobblemonBattleInfoClient.debug("[BattleLogger] Error getting team: {}", e.getMessage());
                if (isPlayerSide) break block13;
                return BattleLogger.formatTrackedOpponentTeam();
            }
        }
        return team;
    }

    private static List<String> formatTrackedOpponentTeam() {
        ArrayList<String> formatted = new ArrayList<String>();
        for (String name : BattleMessageSubscriber.getTrackedOpponentPokemon()) {
            if (name == null || name.isEmpty()) continue;
            String capitalized = name.substring(0, 1).toUpperCase() + name.substring(1);
            formatted.add(capitalized);
        }
        return formatted;
    }

    private static String getPokemonDisplayName(Object pokemon) {
        try {
            try {
                Method getDisplayName = pokemon.getClass().getMethod("getDisplayName", new Class[0]);
                Object displayName = getDisplayName.invoke(pokemon, new Object[0]);
                if (displayName != null) {
                    try {
                        Method getString = displayName.getClass().getMethod("getString", new Class[0]);
                        return (String)getString.invoke(displayName, new Object[0]);
                    }
                    catch (Exception e) {
                        return displayName.toString();
                    }
                }
            }
            catch (Exception getDisplayName) {
                // empty catch block
            }
            try {
                Method getName = pokemon.getClass().getMethod("getName", new Class[0]);
                Object name = getName.invoke(pokemon, new Object[0]);
                if (name != null) {
                    return name.toString();
                }
            }
            catch (Exception getName) {
                // empty catch block
            }
            try {
                Method getName;
                Object name;
                Method getSpecies = pokemon.getClass().getMethod("getSpecies", new Class[0]);
                Object species = getSpecies.invoke(pokemon, new Object[0]);
                if (species != null && (name = (getName = species.getClass().getMethod("getName", new Class[0])).invoke(species, new Object[0])) != null) {
                    return BattleLogger.formatPokemonName(name.toString());
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String formatPokemonName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.contains(":")) {
            name = name.substring(name.indexOf(":") + 1);
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    private static String formatDuration(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes > 0L) {
            return String.format("%d min %d sec", minutes, seconds);
        }
        return String.format("%d sec", seconds);
    }

    private static String sanitizeFileName(String name) {
        if (name == null) {
            return "Unknown";
        }
        return name.replaceAll("[^a-zA-Z0-9_-]", "_");
    }

    private static void reset() {
        isRecording = false;
        currentLog = null;
        currentOpponentName = null;
        currentOpponentUUID = null;
        isPvPBattle = false;
        earlyMessageBuffer.clear();
        pendingOpponentName = null;
    }

    public static boolean isRecording() {
        return isRecording;
    }

    public static boolean isPvPBattle() {
        return isPvPBattle;
    }

    public static List<BattleLogEntry> getRecentLogs() {
        return new ArrayList<BattleLogEntry>(recentLogs);
    }

    public static Path getLogDirectory() {
        if (logDirectory == null) {
            BattleLogger.init();
        }
        return logDirectory;
    }

    public static List<String> loadBattleLog(String fileName) {
        List<String> lines = new ArrayList<String>();
        try {
            Path logFile = logDirectory.resolve(fileName);
            if (Files.exists(logFile, new LinkOption[0])) {
                lines = Files.readAllLines(logFile, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            LOGGER.error("[BattleLogger] Error loading log: {}", (Object)e.getMessage());
        }
        return lines;
    }

    public static List<BattleLogEntry> getAllLogs() {
        ArrayList<BattleLogEntry> logs = new ArrayList<BattleLogEntry>();
        try {
            BattleLogEntry entry;
            if (logDirectory == null) {
                BattleLogger.init();
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(logDirectory, "PvP_*.txt");){
                for (Path file : stream) {
                    entry = BattleLogger.parseLogFileInfo(file, BattleType.PVP);
                    if (entry == null) continue;
                    logs.add(entry);
                }
            }
            stream = Files.newDirectoryStream(logDirectory, "NPC_*.txt");
            try {
                for (Path file : stream) {
                    entry = BattleLogger.parseLogFileInfo(file, BattleType.NPC);
                    if (entry == null) continue;
                    logs.add(entry);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            stream = Files.newDirectoryStream(logDirectory, "BattleLog_*.txt");
            try {
                for (Path file : stream) {
                    entry = BattleLogger.parseLogFileInfo(file, BattleType.PVP);
                    if (entry == null) continue;
                    logs.add(entry);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            logs.sort((a, b) -> Long.compare(b.startTime, a.startTime));
        }
        catch (Exception e) {
            LOGGER.error("[BattleLogger] Error listing logs: {}", (Object)e.getMessage());
        }
        return logs;
    }

    private static BattleLogEntry parseLogFileInfo(Path file, BattleType battleType) {
        try {
            String fileName = file.getFileName().toString();
            BattleLogEntry entry = new BattleLogEntry();
            entry.fileName = fileName;
            entry.battleType = battleType;
            String withoutExt = fileName.replace(".txt", "");
            String[] parts = withoutExt.split("_");
            if (parts.length >= 3) {
                String vspart = parts[1];
                int vsIndex = vspart.toLowerCase().indexOf("vs");
                if (vsIndex > 0) {
                    entry.playerName = vspart.substring(0, vsIndex);
                    entry.opponentName = vspart.substring(vsIndex + 2);
                }
                if (parts.length >= 4) {
                    String dateStr = parts[2] + "_" + parts[3];
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                        Date date = sdf.parse(dateStr);
                        entry.startTime = date.getTime();
                        entry.date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
                    }
                    catch (Exception e) {
                        entry.startTime = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                        entry.date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(entry.startTime));
                    }
                }
            }
            try {
                List<String> lines = Files.readAllLines(file, StandardCharsets.UTF_8);
                for (String line : lines) {
                    if (!line.startsWith("Result: ")) continue;
                    entry.result = line.substring(8);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return entry;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void loadRecentLogsIndex() {
        recentLogs.clear();
        recentLogs.addAll(BattleLogger.getAllLogs());
        while (recentLogs.size() > 50) {
            recentLogs.remove(recentLogs.size() - 1);
        }
    }

    private static void saveRecentLogsIndex() {
    }

    public static boolean deleteLog(String fileName) {
        try {
            Path logFile = logDirectory.resolve(fileName);
            if (Files.exists(logFile, new LinkOption[0])) {
                Files.delete(logFile);
                recentLogs.removeIf(log -> fileName.equals(log.fileName));
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("[BattleLogger] Error deleting log: {}", (Object)e.getMessage());
        }
        return false;
    }

    public static enum BattleType {
        PVP,
        NPC,
        WILD,
        UNKNOWN;

    }

    private static class BattleParticipantInfo {
        String name;
        String uuid;
        BattleType battleType = BattleType.UNKNOWN;

        private BattleParticipantInfo() {
        }
    }

    public static class BattleLogEntry {
        public String playerName = "";
        public String opponentName = "";
        public String opponentUUID = "";
        public String date = "";
        public String result = "";
        public String fileName = "";
        public BattleType battleType = BattleType.UNKNOWN;
        public long startTime = 0L;
        public long endTime = 0L;
        public List<String> playerTeam = new ArrayList<String>();
        public List<String> opponentTeam = new ArrayList<String>();
        public List<String> messages = new ArrayList<String>();

        public String getDisplayTitle() {
            String prefix = this.battleType == BattleType.PVP ? "[PvP] " : (this.battleType == BattleType.NPC ? "[NPC] " : "");
            return prefix + this.playerName + " vs " + this.opponentName;
        }

        public String getShortDate() {
            if (this.date.length() > 10) {
                return this.date.substring(0, 10);
            }
            return this.date;
        }

        public boolean isPvP() {
            return this.battleType == BattleType.PVP;
        }

        public boolean isNPC() {
            return this.battleType == BattleType.NPC;
        }
    }
}

