/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Desktop;
import java.util.ArrayList;
import java.util.List;
import name.modid.client.BattleLogger;
import name.modid.client.BattleMessageColorizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class BattleLogScreen
extends Screen {
    private static final int LIST_ITEM_HEIGHT = 24;
    private static final int LOG_VIEW_WIDTH = 400;
    private List<BattleLogger.BattleLogEntry> logs = new ArrayList<BattleLogger.BattleLogEntry>();
    private List<String> currentLogContent = new ArrayList<String>();
    private List<Component> currentLogContentColored = new ArrayList<Component>();
    private int selectedLogIndex = -1;
    private int listScrollOffset = 0;
    private int contentScrollOffset = 0;
    private int maxVisibleListItems = 10;
    private int maxVisibleContentLines = 20;
    private int listX;
    private int listY;
    private int listWidth;
    private int listHeight;
    private int contentX;
    private int contentY;
    private int contentWidth;
    private int contentHeight;
    private Button openFolderButton;
    private Button deleteButton;
    private Button closeButton;

    public BattleLogScreen() {
        super((Component)Component.translatable((String)"gui.cobblemon-battle-extras.battle_logs.title"));
    }

    protected void init() {
        super.init();
        this.logs = BattleLogger.getAllLogs();
        int padding = 20;
        int centerGap = 10;
        this.listWidth = 200;
        this.listHeight = this.height - padding * 2 - 50;
        this.listX = padding;
        this.listY = padding + 30;
        this.contentX = this.listX + this.listWidth + centerGap;
        this.contentY = this.listY;
        this.contentWidth = this.width - this.contentX - padding;
        this.contentHeight = this.listHeight;
        this.maxVisibleListItems = this.listHeight / 24;
        this.maxVisibleContentLines = this.contentHeight / 12;
        int buttonY = this.height - padding - 18;
        int buttonWidth = 100;
        int buttonSpacing = 10;
        this.openFolderButton = Button.builder((Component)Component.translatable((String)"gui.cobblemon-battle-extras.battle_logs.open_folder"), button -> this.openLogsFolder()).bounds(this.listX, buttonY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.openFolderButton);
        this.deleteButton = Button.builder((Component)Component.translatable((String)"gui.cobblemon-battle-extras.battle_logs.delete"), button -> this.deleteSelectedLog()).bounds(this.listX + buttonWidth + buttonSpacing, buttonY, 80, 20).build();
        this.deleteButton.active = this.selectedLogIndex >= 0;
        this.addRenderableWidget((GuiEventListener)this.deleteButton);
        this.closeButton = Button.builder((Component)Component.translatable((String)"gui.cobblemon-battle-extras.battle_logs.close"), button -> this.onClose()).bounds(this.width - padding - 80, buttonY, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.closeButton);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(0, 0, this.width, this.height, -16119270);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int logIndex;
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, "Battle Logs", this.width / 2, 10, 0xFFFFFF);
        graphics.fill(this.listX - 2, this.listY - 2, this.listX + this.listWidth + 2, this.listY + this.listHeight + 2, -13421739);
        graphics.fill(this.listX, this.listY, this.listX + this.listWidth, this.listY + this.listHeight, -15066578);
        graphics.drawString(this.font, "Recent Battles (" + this.logs.size() + ")", this.listX + 5, this.listY - 15, -5592321);
        int visibleItems = Math.min(this.maxVisibleListItems, this.logs.size() - this.listScrollOffset);
        for (int i = 0; i < visibleItems && (logIndex = i + this.listScrollOffset) < this.logs.size(); ++i) {
            BattleLogger.BattleLogEntry log = this.logs.get(logIndex);
            int itemY = this.listY + i * 24;
            if (logIndex == this.selectedLogIndex) {
                graphics.fill(this.listX, itemY, this.listX + this.listWidth, itemY + 24 - 2, -12298838);
            } else if (this.isMouseOverListItem(mouseX, mouseY, itemY)) {
                graphics.fill(this.listX, itemY, this.listX + this.listWidth, itemY + 24 - 2, -13421722);
            }
            String title = this.truncateString(log.getDisplayTitle(), 22);
            String date = log.getShortDate();
            graphics.drawString(this.font, title, this.listX + 5, itemY + 3, -1);
            graphics.drawString(this.font, date, this.listX + 5, itemY + 13, -5592406);
            if (log.result == null || log.result.isEmpty()) continue;
            int resultColor = -5592406;
            if (log.result.toLowerCase().contains("win") || log.result.toLowerCase().contains("victory")) {
                resultColor = -11141291;
            } else if (log.result.toLowerCase().contains("lose") || log.result.toLowerCase().contains("defeat")) {
                resultColor = -43691;
            }
            graphics.drawString(this.font, "\u25cf", this.listX + this.listWidth - 15, itemY + 8, resultColor);
        }
        if (this.listScrollOffset > 0) {
            graphics.drawCenteredString(this.font, "\u25b2", this.listX + this.listWidth / 2, this.listY - 10, -5592321);
        }
        if (this.listScrollOffset + this.maxVisibleListItems < this.logs.size()) {
            graphics.drawCenteredString(this.font, "\u25bc", this.listX + this.listWidth / 2, this.listY + this.listHeight + 2, -5592321);
        }
        graphics.fill(this.contentX - 2, this.contentY - 2, this.contentX + this.contentWidth + 2, this.contentY + this.contentHeight + 2, -13421739);
        graphics.fill(this.contentX, this.contentY, this.contentX + this.contentWidth, this.contentY + this.contentHeight, -15066578);
        if (this.selectedLogIndex >= 0 && this.selectedLogIndex < this.logs.size()) {
            BattleLogger.BattleLogEntry log = this.logs.get(this.selectedLogIndex);
            String vsHeader = log.playerName + " VS " + log.opponentName;
            graphics.drawCenteredString(this.font, vsHeader, this.contentX + this.contentWidth / 2, this.contentY - 15, -21931);
        } else {
            graphics.drawString(this.font, "Select a battle to view", this.contentX + 5, this.contentY - 15, -7829368);
        }
        if (!this.currentLogContent.isEmpty()) {
            RenderSystem.enableScissor((int)(this.contentX * (int)this.minecraft.getWindow().getGuiScale()), (int)((this.height - this.contentY - this.contentHeight) * (int)this.minecraft.getWindow().getGuiScale()), (int)(this.contentWidth * (int)this.minecraft.getWindow().getGuiScale()), (int)(this.contentHeight * (int)this.minecraft.getWindow().getGuiScale()));
            int lineY = this.contentY + 5 - this.contentScrollOffset * 12;
            for (int i = 0; i < this.currentLogContent.size(); ++i) {
                if (lineY >= this.contentY - 12 && lineY < this.contentY + this.contentHeight) {
                    if (i < this.currentLogContentColored.size()) {
                        Component coloredLine = this.currentLogContentColored.get(i);
                        graphics.drawString(this.font, coloredLine, this.contentX + 5, lineY, -1);
                    } else {
                        String line = this.currentLogContent.get(i);
                        int color = this.getLineColor(line);
                        graphics.drawString(this.font, line, this.contentX + 5, lineY, color);
                    }
                }
                lineY += 12;
            }
            RenderSystem.disableScissor();
            if (this.contentScrollOffset > 0) {
                graphics.drawCenteredString(this.font, "\u25b2", this.contentX + this.contentWidth / 2, this.contentY - 10, -5592321);
            }
            if (this.contentScrollOffset + this.maxVisibleContentLines < this.currentLogContent.size()) {
                graphics.drawCenteredString(this.font, "\u25bc", this.contentX + this.contentWidth / 2, this.contentY + this.contentHeight + 2, -5592321);
            }
        } else if (this.selectedLogIndex < 0) {
            graphics.drawCenteredString(this.font, "Click a battle on the left", this.contentX + this.contentWidth / 2, this.contentY + 50, -10066330);
            graphics.drawCenteredString(this.font, "to view its log", this.contentX + this.contentWidth / 2, this.contentY + 65, -10066330);
        }
        this.openFolderButton.render(graphics, mouseX, mouseY, partialTick);
        this.deleteButton.render(graphics, mouseX, mouseY, partialTick);
        this.closeButton.render(graphics, mouseX, mouseY, partialTick);
    }

    private int getLineColor(String line) {
        if (line.contains("\u2550") || line.contains("\u2500")) {
            return -10057473;
        }
        if (line.contains("BATTLE START") || line.contains("BATTLE END")) {
            return -22016;
        }
        if (line.startsWith("Result:")) {
            if (line.toLowerCase().contains("win") || line.toLowerCase().contains("victory")) {
                return -11141291;
            }
            if (line.toLowerCase().contains("lose") || line.toLowerCase().contains("defeat")) {
                return -43691;
            }
            return -1;
        }
        if (line.toLowerCase().contains("super effective")) {
            return -11141291;
        }
        if (line.toLowerCase().contains("not very effective")) {
            return -30635;
        }
        if (line.toLowerCase().contains("fainted") || line.toLowerCase().contains("was knocked out")) {
            return -43691;
        }
        if (line.contains("Turn ")) {
            return -171;
        }
        if (line.startsWith("  \u2022")) {
            return -5592321;
        }
        if (line.startsWith("---") || line.startsWith("Date:") || line.startsWith("Duration:")) {
            return -5592406;
        }
        return -1;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int clickedIndex;
        if (button == 0 && mouseX >= (double)this.listX && mouseX < (double)(this.listX + this.listWidth) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listHeight) && (clickedIndex = (int)((mouseY - (double)this.listY) / 24.0) + this.listScrollOffset) >= 0 && clickedIndex < this.logs.size()) {
            this.selectLog(clickedIndex);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (mouseX >= (double)this.listX && mouseX < (double)(this.listX + this.listWidth) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listHeight)) {
            if (scrollY > 0.0) {
                this.listScrollOffset = Math.max(0, this.listScrollOffset - 1);
            } else if (scrollY < 0.0) {
                this.listScrollOffset = Math.min(Math.max(0, this.logs.size() - this.maxVisibleListItems), this.listScrollOffset + 1);
            }
            return true;
        }
        if (mouseX >= (double)this.contentX && mouseX < (double)(this.contentX + this.contentWidth) && mouseY >= (double)this.contentY && mouseY < (double)(this.contentY + this.contentHeight)) {
            if (scrollY > 0.0) {
                this.contentScrollOffset = Math.max(0, this.contentScrollOffset - 3);
            } else if (scrollY < 0.0) {
                this.contentScrollOffset = Math.min(Math.max(0, this.currentLogContent.size() - this.maxVisibleContentLines), this.contentScrollOffset + 3);
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        if (keyCode == 265 && this.selectedLogIndex > 0) {
            this.selectLog(this.selectedLogIndex - 1);
            if (this.selectedLogIndex < this.listScrollOffset) {
                this.listScrollOffset = this.selectedLogIndex;
            }
            return true;
        }
        if (keyCode == 264 && this.selectedLogIndex < this.logs.size() - 1) {
            this.selectLog(this.selectedLogIndex + 1);
            if (this.selectedLogIndex >= this.listScrollOffset + this.maxVisibleListItems) {
                this.listScrollOffset = this.selectedLogIndex - this.maxVisibleListItems + 1;
            }
            return true;
        }
        if (keyCode == 266) {
            this.contentScrollOffset = Math.max(0, this.contentScrollOffset - this.maxVisibleContentLines);
            return true;
        }
        if (keyCode == 267) {
            this.contentScrollOffset = Math.min(Math.max(0, this.currentLogContent.size() - this.maxVisibleContentLines), this.contentScrollOffset + this.maxVisibleContentLines);
            return true;
        }
        if (keyCode == 261 && this.selectedLogIndex >= 0) {
            this.deleteSelectedLog();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void selectLog(int index) {
        if (index < 0 || index >= this.logs.size()) {
            return;
        }
        this.selectedLogIndex = index;
        this.contentScrollOffset = 0;
        BattleLogger.BattleLogEntry log = this.logs.get(index);
        this.currentLogContent = log.fileName != null && !log.fileName.isEmpty() ? BattleLogger.loadBattleLog(log.fileName) : new ArrayList<String>(log.messages);
        this.currentLogContentColored = new ArrayList<Component>();
        BattleMessageColorizer.setPlayerName(log.playerName);
        BattleMessageColorizer.setOpponentName(log.opponentName);
        for (String line : this.currentLogContent) {
            Component coloredLine = BattleMessageColorizer.colorizeLineByParts(line);
            this.currentLogContentColored.add(coloredLine);
        }
        this.deleteButton.active = true;
    }

    private void openLogsFolder() {
        block8: {
            try {
                String os = System.getProperty("os.name").toLowerCase();
                String path = BattleLogger.getLogDirectory().toAbsolutePath().toString();
                if (os.contains("win")) {
                    Runtime.getRuntime().exec(new String[]{"explorer", path});
                } else if (os.contains("mac")) {
                    Runtime.getRuntime().exec(new String[]{"open", path});
                } else if (os.contains("nix") || os.contains("nux")) {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", path});
                } else {
                    Desktop.getDesktop().open(BattleLogger.getLogDirectory().toFile());
                }
            }
            catch (Exception e) {
                if (this.minecraft == null) break block8;
                this.minecraft.keyboardHandler.setClipboard(BattleLogger.getLogDirectory().toString());
                if (this.minecraft.player == null) break block8;
                this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"gui.cobblemon-battle-extras.battle_logs.path_copied", (Object[])new Object[]{BattleLogger.getLogDirectory()}), false);
            }
        }
    }

    private void deleteSelectedLog() {
        if (this.selectedLogIndex < 0 || this.selectedLogIndex >= this.logs.size()) {
            return;
        }
        BattleLogger.BattleLogEntry log = this.logs.get(this.selectedLogIndex);
        if (BattleLogger.deleteLog(log.fileName)) {
            this.logs.remove(this.selectedLogIndex);
            if (this.logs.isEmpty()) {
                this.selectedLogIndex = -1;
                this.currentLogContent.clear();
                this.deleteButton.active = false;
            } else if (this.selectedLogIndex >= this.logs.size()) {
                this.selectLog(this.logs.size() - 1);
            } else {
                this.selectLog(this.selectedLogIndex);
            }
        }
    }

    private boolean isMouseOverListItem(int mouseX, int mouseY, int itemY) {
        return mouseX >= this.listX && mouseX < this.listX + this.listWidth && mouseY >= itemY && mouseY < itemY + 24 - 2;
    }

    private String truncateString(String str, int maxLength) {
        if (str == null) {
            return "";
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength - 3) + "...";
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static void open() {
        Minecraft.getInstance().setScreen((Screen)new BattleLogScreen());
    }
}

