/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class AbilityPopupRenderer {
    private static final List<AbilityPopup> activePopups = new ArrayList<AbilityPopup>();
    private static final Set<String> recentlyShown = new HashSet<String>();
    private static final long DUPLICATE_COOLDOWN_MS = 5000L;
    private static final long SLIDE_IN_DURATION_MS = 300L;
    private static final long SLIDE_OUT_DURATION_MS = 400L;
    private static final int BG_COLOR = -535816152;
    private static final int BORDER_TOP = -570435840;
    private static final int BORDER_BOTTOM = -573794048;
    private static final int HEADER_COLOR = -10496;
    private static final int ACCENT_COLOR = -22016;
    private static final int TEXT_COLOR = -1;
    private static final int GLOW_COLOR = 1090508544;

    public static void init() {
        Services.EVENTS.registerHudRender((guiGraphics, tickDelta) -> {
            try {
                AbilityPopupRenderer.renderPopups(guiGraphics);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("Ability popup renderer initialized", new Object[0]);
    }

    public static void showAbilityPopup(String pokemonName, String abilityName) {
        abilityName = AbilityPopupRenderer.formatAbilityName(abilityName);
        String key = (pokemonName = AbilityPopupRenderer.capitalizeName(pokemonName)) + ":" + abilityName;
        if (recentlyShown.contains(key)) {
            return;
        }
        recentlyShown.add(key);
        float durationSeconds = BattleExtrasConfig.getAbilityPopupDurationSeconds();
        long durationMs = (long)(durationSeconds * 1000.0f);
        boolean isPlayer = AbilityPopupRenderer.isPlayerPokemon(pokemonName);
        activePopups.add(new AbilityPopup(pokemonName, abilityName, durationMs, key, isPlayer));
    }

    private static String capitalizeName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static boolean isPlayerPokemon(String pokemonName) {
        try {
            ClientBattleSide side2;
            ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
            if (battle == null) {
                return true;
            }
            ClientBattleSide side = battle.getSide1();
            if (side != null) {
                for (ClientBattleActor actor : side.getActors()) {
                    for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                        String name;
                        ClientBattlePokemon battlePokemon;
                        if (activePokemon == null || (battlePokemon = activePokemon.getBattlePokemon()) == null || !(name = battlePokemon.getDisplayName().getString()).equalsIgnoreCase(pokemonName)) continue;
                        return true;
                    }
                }
            }
            if ((side2 = battle.getSide2()) != null) {
                for (ClientBattleActor actor : side2.getActors()) {
                    for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                        String name;
                        ClientBattlePokemon battlePokemon;
                        if (activePokemon == null || (battlePokemon = activePokemon.getBattlePokemon()) == null || !(name = battlePokemon.getDisplayName().getString()).equalsIgnoreCase(pokemonName)) continue;
                        return false;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private static String formatAbilityName(String abilityName) {
        if (abilityName == null || abilityName.isEmpty()) {
            return abilityName;
        }
        if (abilityName.contains(" ")) {
            return abilityName;
        }
        StringBuilder formatted = new StringBuilder();
        for (int i = 0; i < abilityName.length(); ++i) {
            char c = abilityName.charAt(i);
            if (i > 0 && Character.isUpperCase(c) && Character.isLowerCase(abilityName.charAt(i - 1))) {
                formatted.append(' ');
            }
            formatted.append(c);
        }
        return formatted.toString();
    }

    public static void showAbility(String pokemonName, String abilityName) {
        AbilityPopupRenderer.showAbilityPopup(pokemonName, abilityName);
    }

    private static void renderPopups(GuiGraphics gui) {
        if (activePopups.isEmpty()) {
            return;
        }
        if (!BattleExtrasConfig.isAbilityPopupsEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        boolean centered = BattleExtrasConfig.isAbilityPopupCentered();
        int playerY = screenHeight / 2 - 40;
        int opponentY = screenHeight / 2 - 40;
        int centeredY = screenHeight - 100;
        long currentTime = System.currentTimeMillis();
        Iterator<AbilityPopup> iterator = activePopups.iterator();
        while (iterator.hasNext()) {
            int x;
            int y;
            AbilityPopup popup = iterator.next();
            long elapsed = currentTime - popup.startTime;
            long remaining = popup.durationMs - elapsed;
            if (remaining <= 0L) {
                recentlyShown.remove(popup.key);
                iterator.remove();
                continue;
            }
            float slideProgress = Math.min(1.0f, (float)elapsed / 300.0f);
            slideProgress = 1.0f - (1.0f - slideProgress) * (1.0f - slideProgress) * (1.0f - slideProgress);
            long fadeStartTime = popup.durationMs * 2L / 3L;
            float alpha = 1.0f;
            float slideOutProgress = 0.0f;
            if (elapsed > fadeStartTime) {
                long fadeElapsed = elapsed - fadeStartTime;
                long fadeDuration = popup.durationMs - fadeStartTime;
                alpha = 1.0f - (float)fadeElapsed / (float)fadeDuration;
                slideOutProgress = (float)fadeElapsed / (float)Math.min(fadeDuration, 400L);
                slideOutProgress = Math.min(1.0f, slideOutProgress);
                slideOutProgress *= slideOutProgress;
            }
            MutableComponent headerComp = Component.literal((String)"\u26a1 ABILITY \u26a1");
            MutableComponent abilityComp = Component.translatable((String)"ability.popup.activated", (Object[])new Object[]{popup.pokemonName, popup.abilityName});
            int headerWidth = mc.font.width((FormattedText)headerComp);
            int abilityWidth = mc.font.width((FormattedText)abilityComp);
            int maxWidth = Math.max(headerWidth, abilityWidth);
            int padding = 12;
            int boxWidth = maxWidth + padding * 2;
            int boxHeight = 28;
            if (centered) {
                targetX = (screenWidth - boxWidth) / 2;
                int startY = screenHeight + 10;
                int targetY = centeredY;
                y = (int)((float)startY + (float)(targetY - startY) * slideProgress);
                if (slideOutProgress > 0.0f) {
                    y = (int)((float)y + (float)(screenHeight - y + 20) * slideOutProgress);
                }
                x = targetX;
                centeredY -= boxHeight + 6;
            } else {
                int startX;
                if (popup.isPlayer) {
                    targetX = 10;
                    startX = -boxWidth - 20;
                    y = playerY;
                    playerY += boxHeight + 6;
                } else {
                    targetX = screenWidth - boxWidth - 10;
                    startX = screenWidth + 20;
                    y = opponentY;
                    opponentY += boxHeight + 6;
                }
                if (popup.isPlayer) {
                    x = (int)((float)startX + (float)(targetX - startX) * slideProgress);
                    if (slideOutProgress > 0.0f) {
                        x = (int)((float)x - (float)(x + boxWidth + 20) * slideOutProgress);
                    }
                } else {
                    x = (int)((float)startX + (float)(targetX - startX) * slideProgress);
                    if (slideOutProgress > 0.0f) {
                        x = (int)((float)x + (float)(screenWidth - x + 20) * slideOutProgress);
                    }
                }
            }
            AbilityPopupRenderer.renderFancyPopup(gui, mc, x, y, boxWidth, boxHeight, (Component)headerComp, (Component)abilityComp, alpha, popup.isPlayer);
        }
    }

    private static void renderFancyPopup(GuiGraphics gui, Minecraft mc, int x, int y, int width, int height, Component header, Component ability, float alpha, boolean isPlayer) {
        if (alpha <= 0.0f) {
            return;
        }
        int cornerRadius = 3;
        int bgAlpha = (int)(alpha * 224.0f);
        int borderAlpha = (int)(alpha * 221.0f);
        int textAlpha = (int)(alpha * 255.0f);
        int bg = bgAlpha << 24 | 0x101828;
        int borderTop = borderAlpha << 24 | 0xFFD700;
        int borderBottom = borderAlpha << 24 | 0xCC9900;
        int headerColor = textAlpha << 24 | 0xFFD700;
        int textColor = textAlpha << 24 | 0xFFFFFF;
        int accentColor = borderAlpha << 24 | 0xFFAA00;
        int glowColor = (int)(alpha * 64.0f) << 24 | 0xFFD700;
        AbilityPopupRenderer.drawRoundedRect(gui, x, y, width, height, bg, cornerRadius);
        AbilityPopupRenderer.drawGradientBorder(gui, x, y, width, height, borderTop, borderBottom, cornerRadius);
        if (isPlayer) {
            gui.fill(x + 3, y + 4, x + 5, y + height - 4, accentColor);
        } else {
            gui.fill(x + width - 5, y + 4, x + width - 3, y + height - 4, accentColor);
        }
        int glowX = x + (width - mc.font.width((FormattedText)header)) / 2;
        gui.fill(glowX - 4, y + 2, glowX + mc.font.width((FormattedText)header) + 4, y + 12, glowColor);
        int headerX = x + (width - mc.font.width((FormattedText)header)) / 2;
        gui.drawString(mc.font, header, headerX, y + 4, headerColor, true);
        int abilityX = x + (width - mc.font.width((FormattedText)ability)) / 2;
        int abilityTextEnd = abilityX + mc.font.width((FormattedText)ability);
        gui.drawString(mc.font, ability, abilityX, y + 16, textColor, true);
        int diamondColor = borderAlpha << 24 | 0xFFD700;
        int diamondSpacing = 6;
        int rightDiamondX = abilityTextEnd + diamondSpacing;
        AbilityPopupRenderer.drawSmallDiamond(gui, rightDiamondX, y + 4, diamondColor);
        AbilityPopupRenderer.drawSmallDiamond(gui, rightDiamondX, y + height - 6, diamondColor);
    }

    private static void drawRoundedRect(GuiGraphics g, int x, int y, int w, int h, int color, int r) {
        g.fill(x + r, y, x + w - r, y + h, color);
        g.fill(x, y + r, x + w, y + h - r, color);
        g.fill(x + 1, y + 1, x + r, y + r, color);
        g.fill(x + w - r, y + 1, x + w - 1, y + r, color);
        g.fill(x + 1, y + h - r, x + r, y + h - 1, color);
        g.fill(x + w - r, y + h - r, x + w - 1, y + h - 1, color);
    }

    private static void drawGradientBorder(GuiGraphics g, int x, int y, int w, int h, int topColor, int bottomColor, int r) {
        int color;
        float progress;
        int i;
        g.fill(x + r, y, x + w - r, y + 1, topColor);
        g.fill(x + r, y + h - 1, x + w - r, y + h, bottomColor);
        for (i = r; i < h - r; ++i) {
            progress = (float)i / (float)h;
            color = AbilityPopupRenderer.mixColors(topColor, bottomColor, progress);
            g.fill(x, y + i, x + 1, y + i + 1, color);
        }
        for (i = r; i < h - r; ++i) {
            progress = (float)i / (float)h;
            color = AbilityPopupRenderer.mixColors(topColor, bottomColor, progress);
            g.fill(x + w - 1, y + i, x + w, y + i + 1, color);
        }
        g.fill(x + 1, y + 1, x + 2, y + 2, topColor);
        g.fill(x + w - 2, y + 1, x + w - 1, y + 2, topColor);
        g.fill(x + 1, y + h - 2, x + 2, y + h - 1, bottomColor);
        g.fill(x + w - 2, y + h - 2, x + w - 1, y + h - 1, bottomColor);
    }

    private static void drawSmallDiamond(GuiGraphics g, int cx, int cy, int color) {
        g.fill(cx, cy - 1, cx + 1, cy + 2, color);
        g.fill(cx - 1, cy, cx + 2, cy + 1, color);
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * ratio);
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static class AbilityPopup {
        String pokemonName;
        String abilityName;
        long startTime;
        long durationMs;
        String key;
        boolean isPlayer;

        AbilityPopup(String pokemonName, String abilityName, long durationMs, String key, boolean isPlayer) {
            this.pokemonName = pokemonName;
            this.abilityName = abilityName;
            this.startTime = System.currentTimeMillis();
            this.durationMs = durationMs;
            this.key = key;
            this.isPlayer = isPlayer;
        }
    }
}

