/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.util.search;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.Nullable;

public class CobblelootsSearch {
    public static final int MAX_SECTION_SEARCH_ATTEMPTS = 5;
    public static final int MAX_CHECKS_FOR_SOLID_BLOCK = 5;

    @Nullable
    public static BlockPos searchRandomValidLootBallSpawn(LevelChunkSection section, RandomSource randomSource) {
        int i;
        int x = randomSource.nextInt(16);
        int z = randomSource.nextInt(16);
        int[] y = new int[16];
        for (i = 0; i < y.length; ++i) {
            y[i] = i;
        }
        for (i = 0; i < y.length; ++i) {
            int randomIndex = randomSource.nextIntBetweenInclusive(i, y.length - 1);
            BlockState blockState = section.getBlockState(x, y[randomIndex], z);
            if (!blockState.isSolid()) {
                for (int j = y[randomIndex]; j >= 0; --j) {
                    BlockState baseBlock = section.getBlockState(x, j, z);
                    if (!baseBlock.isSolid()) continue;
                    return new BlockPos(x, j + 1, z);
                }
                return new BlockPos(x, y[randomIndex], z);
            }
            y[randomIndex] = y[i];
        }
        return null;
    }

    public static int searchRandomNonEmptySectionIndex(LevelChunkSection[] sectionsArray, RandomSource randomSource) {
        int[] sectionIndexes = new int[sectionsArray.length];
        for (int i = 0; i < sectionsArray.length; ++i) {
            sectionIndexes[i] = i;
        }
        int tries = Math.min(5, sectionIndexes.length);
        for (int i = 0; i < tries; ++i) {
            int randomIndex = randomSource.nextIntBetweenInclusive(i, sectionIndexes.length - 1);
            LevelChunkSection section = sectionsArray[sectionIndexes[randomIndex]];
            if (!section.hasOnlyAir()) {
                return sectionIndexes[randomIndex];
            }
            sectionIndexes[randomIndex] = sectionIndexes[i];
        }
        return -1;
    }
}

