/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.item.custom;

import dev.ripio.cobbleloots.entity.CobblelootsEntities;
import dev.ripio.cobbleloots.entity.custom.CobblelootsLootBall;
import dev.ripio.cobbleloots.util.CobblelootsUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class CobblelootsLootBallItem
extends Item {
    public CobblelootsLootBallItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)CobblelootsUtils.cobblelootsText("item.cobbleloots.loot_ball.tooltip.1", new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        if (!this.placeLootBall(useOnContext)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    private boolean placeLootBall(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType<CobblelootsLootBall> entityType = CobblelootsEntities.getLootBallEntityType();
            CobblelootsLootBall lootBall = (CobblelootsLootBall)entityType.create((Level)serverLevel);
            if (lootBall == null) {
                return false;
            }
            lootBall.moveTo(useOnContext.getClickLocation(), Mth.wrapDegrees((float)(useOnContext.getRotation() - 180.0f)), 0.0f);
            level.addFreshEntity((Entity)lootBall);
            level.playSound(null, lootBall.getX(), lootBall.getY(), lootBall.getZ(), SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
            lootBall.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)useOnContext.getPlayer());
            if (useOnContext.getItemInHand().has(DataComponents.CUSTOM_DATA)) {
                CustomData customData = (CustomData)useOnContext.getItemInHand().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                lootBall.readAdditionalSaveData(customData.copyTag());
            }
            useOnContext.getItemInHand().shrink(1);
        }
        return false;
    }
}

