/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.item.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ripio.cobbleloots.item.client.CobblelootsLootBallItemModel;
import dev.ripio.cobbleloots.util.CobblelootsDefinitions;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.joml.Quaternionf;

public class CobblelootsLootBallItemRenderer {
    public static ResourceLocation DEFAULT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"textures/poke_balls/strange_ball.png");
    public static CobblelootsLootBallItemModel MODEL = new CobblelootsLootBallItemModel(CobblelootsLootBallItemModel.createLayer().bakeRoot());

    public static ResourceLocation getTexture(ItemStack stack) {
        ResourceLocation textureLocation;
        CompoundTag compoundTag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (compoundTag.contains("Texture") && (textureLocation = ResourceLocation.tryParse((String)compoundTag.getString("Texture"))) != null && !textureLocation.equals((Object)CobblelootsDefinitions.EMPTY_LOCATION)) {
            return textureLocation;
        }
        return DEFAULT_TEXTURE;
    }

    public static void renderLootBallItem(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ResourceLocation texture = CobblelootsLootBallItemRenderer.getTexture(stack);
        if (texture != null) {
            matrices.pushPose();
            if (mode == ItemDisplayContext.FIXED) {
                matrices.translate(0.5f, 1.75f, 0.5f);
                matrices.scale(1.0f, 1.0f, 1.0f);
                matrices.mulPose(new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f));
            }
            if (mode == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                matrices.translate(0.5f, 1.5f, 0.5f);
                matrices.scale(0.7f, 0.7f, 0.7f);
                matrices.mulPose(new Quaternionf(1.0f, 0.0f, 0.0f, 0.0f));
            }
            if (mode == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                matrices.translate(0.5f, 1.5f, 0.5f);
                matrices.scale(0.7f, 0.7f, 0.7f);
                matrices.mulPose(new Quaternionf(1.0f, 0.0f, 0.0f, 0.0f));
            }
            if (mode == ItemDisplayContext.GROUND) {
                matrices.translate(0.5f, 1.25f, 0.5f);
                matrices.scale(0.6f, 0.6f, 0.6f);
                matrices.mulPose(new Quaternionf(1.0f, 0.0f, 0.0f, 0.0f));
            }
            if (mode == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                matrices.translate(0.5f, 1.75f, 0.1f);
                matrices.mulPose(new Quaternionf(0.9029221, -0.0705408, -0.4232447, -0.0248899));
            }
            if (mode == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                matrices.translate(0.5f, 1.75f, 0.1f);
                matrices.mulPose(new Quaternionf(0.9029221, 0.0705408, 0.4232447, 0.0248899));
            }
            if (mode == ItemDisplayContext.GUI) {
                matrices.translate(0.5f, 1.75f, 0.0f);
                matrices.mulPose(new Quaternionf(0.9128798, 0.0633944, -0.3803666, -0.1339882));
            }
            MODEL.renderToBuffer(matrices, vertexConsumers.getBuffer(MODEL.renderType(texture)), light, overlay, -1);
            matrices.popPose();
        }
    }
}

