/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ripio.cobbleloots.item.custom.CobblelootsLootBallItem;
import dev.ripio.cobbleloots.item.neoforge.CobblelootsItemsImpl;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;

public class CobblelootsItems {
    public static CobblelootsLootBallItem getBaseLootBallItem() {
        return new CobblelootsLootBallItem(new Item.Properties());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CobblelootsLootBallItem getLootBallItem() {
        return CobblelootsItemsImpl.getLootBallItem();
    }

    public static void addCreativeTabItems(CreativeModeTab.Output output) {
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("poke"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("citrine"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("verdant"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("azure"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("roseate"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("slate"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("premier"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("great"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ultra"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("safari"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("fast"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("level"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("lure"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("heavy"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("love"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("friend"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("moon"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("sport"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("park"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("net"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("dive"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("nest"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("repeat"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("timer"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("luxury"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("dusk"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("heal"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("quick"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("dream"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("beast"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("master"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("cherish"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_poke"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_citrine"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_verdant"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_azure"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_roseate"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_slate"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_ivory"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_great"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_ultra"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_feather"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_wing"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_jet"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_heavy"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_leaden"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_gigaton"));
        output.accept(CobblelootsItems.generateStackWithCobblemonTexture("ancient_origin"));
        output.accept(CobblelootsItems.generateStackWithTexture("cobbleloots:textures/loot_ball/rainbow"));
        output.accept(CobblelootsItems.generateStackWithTexture("cobbleloots:textures/loot_ball/pumpkin"));
    }

    public static void addCreativeTabItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output) {
        CobblelootsItems.addCreativeTabItems(output);
    }

    private static ItemStack generateStackWithData(String dataId, String variantId) {
        CobblelootsLootBallItem lootBallItem = CobblelootsItems.getLootBallItem();
        ItemStack stack = new ItemStack((ItemLike)lootBallItem);
        CompoundTag tag = new CompoundTag();
        tag.putString("LootBallData", "cobbleloots:loot_ball/" + dataId);
        tag.putString("Variant", variantId);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        return stack;
    }

    private static ItemStack generateStackWithData(String dataId) {
        return CobblelootsItems.generateStackWithData(dataId, "");
    }

    public static ItemStack generateStackWithCobblemonTexture(String textureId) {
        return CobblelootsItems.generateStackWithTexture("cobblemon:textures/poke_balls/" + textureId + "_ball");
    }

    private static ItemStack generateStackWithTexture(String path) {
        CobblelootsLootBallItem lootBallItem = CobblelootsItems.getLootBallItem();
        ItemStack stack = new ItemStack((ItemLike)lootBallItem);
        CompoundTag tag = new CompoundTag();
        tag.putString("Texture", path + ".png");
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.cobbleloots.loot_ball.custom_texture", (Object[])new Object[]{path}));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"item.cobbleloots.loot_ball.custom_texture.lore"))));
        return stack;
    }
}

