/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.event.custom;

import dev.ripio.cobbleloots.Cobbleloots;
import dev.ripio.cobbleloots.config.CobblelootsConfig;
import dev.ripio.cobbleloots.data.CobblelootsDataProvider;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallData;
import dev.ripio.cobbleloots.entity.CobblelootsEntities;
import dev.ripio.cobbleloots.entity.custom.CobblelootsLootBall;
import dev.ripio.cobbleloots.util.CobblelootsDefinitions;
import dev.ripio.cobbleloots.util.enums.CobblelootsSourceType;
import dev.ripio.cobbleloots.util.search.CobblelootsSearch;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CobblelootsLootBallEvents {
    private static final String TEXT_EVENT_LOOT_BALL_SPAWN_SPECIAL = "event.cobbleloots.loot_ball.spawn.special";

    public static boolean generateLootBallOnChunk(ServerLevel level, LevelChunk levelChunk, RandomSource randomSource) {
        if (randomSource.nextFloat() > CobblelootsConfig.getFloatConfig("loot_ball.generation.chance")) {
            return false;
        }
        LevelChunkSection[] sections = levelChunk.getSections();
        int sectionIndex = CobblelootsSearch.searchRandomNonEmptySectionIndex(sections, randomSource);
        if (sectionIndex < 0 || sectionIndex >= sections.length) {
            Cobbleloots.LOGGER.debug("[Cobbleloots] Invalid section index: {} for chunk at {}", (Object)sectionIndex, (Object)levelChunk.getPos());
            return false;
        }
        LevelChunkSection section = sections[sectionIndex];
        BlockPos relativePos = CobblelootsSearch.searchRandomValidLootBallSpawn(section, randomSource);
        if (relativePos == null) {
            return false;
        }
        BlockPos pos = relativePos.offset(levelChunk.getPos().getMinBlockX(), levelChunk.getSectionYFromSectionIndex(sectionIndex) * 16, levelChunk.getPos().getMinBlockZ());
        return CobblelootsLootBallEvents.spawnLootBall(level, levelChunk, pos, randomSource, CobblelootsSourceType.GENERATION) != null;
    }

    public static void spawnLootBallNearRandomPlayer(MinecraftServer server, RandomSource randomSource) {
        if (randomSource.nextFloat() > CobblelootsConfig.getFloatConfig("loot_ball.spawning.chance")) {
            return;
        }
        List playerList = server.getPlayerList().getPlayers();
        if (playerList.isEmpty()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)playerList.get(randomSource.nextInt(playerList.size()));
        ServerLevel level = player.serverLevel();
        LevelChunk playerChunk = level.getChunkAt(player.blockPosition());
        ChunkPos playerChunkPos = playerChunk.getPos();
        LevelChunk randomChunk = level.getChunk(playerChunkPos.x + randomSource.nextIntBetweenInclusive(-1, 1), playerChunkPos.z + randomSource.nextIntBetweenInclusive(-1, 1));
        int sectionIndex = playerChunk.getSectionIndex((int)player.getY());
        LevelChunkSection[] sections = randomChunk.getSections();
        if (sectionIndex < 0 || sectionIndex >= sections.length) {
            Cobbleloots.LOGGER.debug("[Cobbleloots] Invalid section index: {} for player at {}", (Object)sectionIndex, (Object)player.blockPosition());
            return;
        }
        LevelChunkSection section = sections[sectionIndex];
        BlockPos relativePos = CobblelootsSearch.searchRandomValidLootBallSpawn(section, randomSource);
        if (relativePos == null) {
            return;
        }
        BlockPos pos = relativePos.offset(randomChunk.getPos().getMinBlockX(), randomChunk.getSectionYFromSectionIndex(sectionIndex) * 16, randomChunk.getPos().getMinBlockZ());
        CobblelootsLootBall lootBall = CobblelootsLootBallEvents.spawnLootBall(level, randomChunk, pos, randomSource, CobblelootsSourceType.SPAWNING);
        if (lootBall != null && CobblelootsConfig.getBooleanConfig("loot_ball.spawning.despawn.enabled")) {
            lootBall.setDespawnTick(level.getGameTime() + (long)CobblelootsConfig.getIntConfig("loot_ball.spawning.despawn.time"));
        }
    }

    @Nullable
    private static CobblelootsLootBall spawnLootBall(ServerLevel level, LevelChunk chunk, BlockPos pos, RandomSource randomSource, CobblelootsSourceType sourceType) {
        EntityType<CobblelootsLootBall> lootBallEntityType;
        CobblelootsLootBall lootBall;
        ArrayList<String> variantKeys;
        Map.Entry<ResourceLocation, CobblelootsLootBallData> lootBallEntry = CobblelootsDataProvider.getRandomLootBallData(level, chunk, pos, sourceType);
        if (lootBallEntry == null) {
            return null;
        }
        ResourceLocation dataId = lootBallEntry.getKey();
        CobblelootsLootBallData lootBallData = lootBallEntry.getValue();
        if (dataId == null || dataId == CobblelootsDefinitions.EMPTY_LOCATION) {
            return null;
        }
        String variant = "";
        if (lootBallData.getVariants() != null && !lootBallData.getVariants().isEmpty() && !(variantKeys = new ArrayList<String>(lootBallData.getVariants().keySet())).isEmpty()) {
            variant = (String)variantKeys.get(randomSource.nextInt(variantKeys.size()));
        }
        if ((lootBall = (CobblelootsLootBall)(lootBallEntityType = CobblelootsEntities.getLootBallEntityType()).create((Level)level)) == null) {
            return null;
        }
        Vec3 vec3 = new Vec3((double)((float)pos.getX() + 0.25f + randomSource.nextFloat() * 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.25f + randomSource.nextFloat() * 0.5f));
        float f = randomSource.nextFloat() * 360.0f;
        lootBall.moveTo(vec3.x(), vec3.y(), vec3.z(), f, 0.0f);
        level.addFreshEntity((Entity)lootBall);
        lootBall.setLootBallDataId(dataId);
        lootBall.setVariantId(variant);
        if (CobblelootsConfig.getBooleanConfig("loot_ball.bonus.enabled") && randomSource.nextFloat() < CobblelootsConfig.getFloatConfig("loot_ball.bonus.chance")) {
            lootBall.setInvisible(CobblelootsConfig.getBooleanConfig("loot_ball.bonus.invisible"));
            lootBall.setMultiplier(CobblelootsConfig.getFloatConfig("loot_ball.bonus.multiplier"));
        }
        return lootBall;
    }
}

