/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.event;

import dev.ripio.cobbleloots.config.CobblelootsConfig;
import dev.ripio.cobbleloots.event.custom.CobblelootsLootBallEvents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.LevelChunk;

public class CobblelootsEventManager {
    private static long lootBallSpawnTick = 0L;
    private static final RandomSource randomSource = RandomSource.create();

    public static void onChunkGenerate(ServerLevel level, LevelChunk levelChunk) {
        if (CobblelootsConfig.getBooleanConfig("loot_ball.generation.enabled")) {
            int count = 0;
            for (int i = 0; i < CobblelootsConfig.getIntConfig("loot_ball.generation.attempts") && count < CobblelootsConfig.getIntConfig("loot_ball.generation.chunk_cap"); ++i) {
                if (!CobblelootsLootBallEvents.generateLootBallOnChunk(level, levelChunk, randomSource)) continue;
                ++count;
            }
        }
    }

    public static void onServerTick(MinecraftServer server) {
        if (lootBallSpawnTick == 0L) {
            lootBallSpawnTick = (long)server.getTickCount() + CobblelootsEventManager.getLootBallCooldown();
        }
        if ((long)server.getTickCount() > lootBallSpawnTick && CobblelootsConfig.getBooleanConfig("loot_ball.spawning.enabled")) {
            CobblelootsLootBallEvents.spawnLootBallNearRandomPlayer(server, randomSource);
            lootBallSpawnTick = (long)server.getTickCount() + CobblelootsEventManager.getLootBallCooldown();
        }
    }

    private static long getLootBallCooldown() {
        return randomSource.nextIntBetweenInclusive(CobblelootsConfig.getIntConfig("loot_ball.spawning.cooldown.min"), CobblelootsConfig.getIntConfig("loot_ball.spawning.cooldown.max"));
    }
}

