/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.entity.custom;

import dev.ripio.cobbleloots.config.CobblelootsConfig;
import dev.ripio.cobbleloots.data.CobblelootsDataProvider;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallData;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallVariantData;
import dev.ripio.cobbleloots.entity.custom.CobblelootsBaseContainerEntity;
import dev.ripio.cobbleloots.item.CobblelootsItems;
import dev.ripio.cobbleloots.sound.CobblelootsLootBallSounds;
import dev.ripio.cobbleloots.util.CobblelootsDefinitions;
import dev.ripio.cobbleloots.util.CobblelootsUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CobblelootsLootBall
extends CobblelootsBaseContainerEntity {
    private static final int CONTAINER_SIZE = 1;
    private final NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    public final AnimationState openingAnimationState = new AnimationState();
    private static final int LOOT_BALL_OPENING_TICKS = 50;
    private static final int LOOT_BALL_OPENING_DROP_TICK = 25;
    private static final float PARTICLE_SPAWN_CHANCE = 0.05f;
    private static final double PARTICLE_OFFSET_MULTIPLIER = 0.1;
    private static final double PARTICLE_Y_FIXED_OFFSET = 0.5;
    private static final double PARTICLE_VELOCITY_MULTIPLIER = 0.1;
    private boolean isOpening = false;
    private ServerPlayer pendingOpener = null;
    private boolean wasInvisible = false;
    private static final EntityDataAccessor<Integer> OPENING_TICKS = SynchedEntityData.defineId(CobblelootsLootBall.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SPARKS = SynchedEntityData.defineId(CobblelootsLootBall.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> INVISIBLE = SynchedEntityData.defineId(CobblelootsLootBall.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> CUSTOM_TEXTURE = SynchedEntityData.defineId(CobblelootsLootBall.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> LOOT_BALL_DATA_ID = SynchedEntityData.defineId(CobblelootsLootBall.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> VARIANT_ID = SynchedEntityData.defineId(CobblelootsLootBall.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<CompoundTag> LOOT_BALL_CLIENT_DATA = SynchedEntityData.defineId(CobblelootsLootBall.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final String TAG_SPARKS = "Sparks";
    public static final String TAG_INVISIBLE = "Invisible";
    public static final String TAG_CUSTOM_TEXTURE = "Texture";
    public static final String TAG_LOOT_BALL_DATA_ID = "LootBallData";
    public static final String TAG_VARIANT_ID = "Variant";
    private static final String TAG_OPENERS = "Openers";
    private static final String TAG_USES = "Uses";
    private static final String TAG_MULTIPLIER = "Multiplier";
    private static final String TAG_DESPAWN_TICK = "DespawnTick";
    private static final String TAG_PLAYER_TIMER = "PlayerTimer";
    private static final String TAG_XP = "XP";
    private static final String TEXT_ERROR_IS_OPENING = "entity.cobbleloots.loot_ball.error.is_opening";
    private static final String TEXT_ERROR_ALREADY_OPENED = "entity.cobbleloots.loot_ball.error.already_opened";
    private static final String TEXT_ERROR_COOLDOWN = "entity.cobbleloots.loot_ball.error.cooldown";
    private static final String TEXT_INFO_NO_LOOT = "entity.cobbleloots.loot_ball.info.no_loot";
    private static final String TEXT_OPEN_SUCCESS = "entity.cobbleloots.loot_ball.open.success";
    private static final String TEXT_OPEN_SUCCESS_BONUS = "entity.cobbleloots.loot_ball.open.success.bonus";
    private static final String TEXT_SET_ITEM = "entity.cobbleloots.loot_ball.set.item";
    private static final String TEXT_TOGGLE_VISIBILITY = "entity.cobbleloots.loot_ball.toggle.visibility";
    private static final String TEXT_TOGGLE_SPARKS = "entity.cobbleloots.loot_ball.toggle.sparks";
    private static final float DEFAULT_MULTIPLIER = CobblelootsConfig.getFloatConfig("loot_ball.defaults.multiplier");
    private static final int DEFAULT_USES = CobblelootsConfig.getIntConfig("loot_ball.defaults.uses");
    private static final long DEFAULT_DESPAWN_TICK = CobblelootsConfig.getLongConfig("loot_ball.defaults.despawn_tick");
    private static final long DEFAULT_PLAYER_TIMER = CobblelootsConfig.getLongConfig("loot_ball.defaults.player_timer");
    private static final int DEFAULT_XP = CobblelootsConfig.getIntConfig("loot_ball.defaults.xp");
    protected final Map<UUID, Long> openers = new HashMap<UUID, Long>();
    protected int uses = DEFAULT_USES;
    protected float multiplier = DEFAULT_MULTIPLIER;
    protected long despawnTick = DEFAULT_DESPAWN_TICK;
    protected long playerTimer = DEFAULT_PLAYER_TIMER;
    protected int xp = DEFAULT_XP;

    public CobblelootsLootBall(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.GRAVITY, 0.1);
    }

    public boolean fireImmune() {
        return true;
    }

    public void setYRot(float f) {
        super.setYRot(f);
        super.setYHeadRot(f);
        super.setYBodyRot(f);
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    protected void updateInvisibilityStatus() {
        this.setInvisible(this.isInvisible());
    }

    public void setInvisible(boolean bl) {
        this.getEntityData().set(INVISIBLE, (Object)bl);
        super.setInvisible(bl);
    }

    public boolean isInvisible() {
        return (Boolean)this.getEntityData().get(INVISIBLE);
    }

    @NotNull
    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (!this.level().isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.handleServerSideInteraction(serverPlayer, interactionHand);
        }
        this.setChanged();
        return InteractionResult.SUCCESS;
    }

    private void handleServerSideInteraction(ServerPlayer serverPlayer, InteractionHand interactionHand) {
        ItemStack handStack = serverPlayer.getItemInHand(interactionHand).copy();
        if (serverPlayer.isCreative()) {
            this.handleCreativeModeInteraction(serverPlayer, handStack);
        } else if (!serverPlayer.isSpectator()) {
            this.tryOpen(serverPlayer);
        }
    }

    private void handleCreativeModeInteraction(ServerPlayer serverPlayer, ItemStack handStack) {
        if (handStack.isEmpty()) {
            this.toggleVisibility(serverPlayer);
        } else if (handStack.is(Items.HONEYCOMB) && this.isInvisible()) {
            this.toggleSparks(serverPlayer);
        } else {
            this.setLootBallItem(handStack, serverPlayer);
        }
    }

    public boolean hurt(DamageSource damageSource, float f) {
        Entity attacker = damageSource.getEntity();
        if (!(attacker instanceof Player)) {
            return false;
        }
        Player player = (Player)attacker;
        this.lastHurtByPlayerTime = 100;
        if (this.level().isClientSide()) {
            return false;
        }
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack itemStack = serverPlayer.getMainHandItem();
        if (!itemStack.isEmpty()) {
            return false;
        }
        return this.handleEmptyHandAttack(serverPlayer);
    }

    private boolean handleEmptyHandAttack(ServerPlayer serverPlayer) {
        if (!serverPlayer.isCreative() && this.getRemainingUses() != 0) {
            serverPlayer.playNotifySound(SoundEvents.SHIELD_BLOCK, SoundSource.BLOCKS, 0.3f, 1.0f);
            return false;
        }
        if (this.isOpening) {
            serverPlayer.playNotifySound(SoundEvents.SHIELD_BLOCK, SoundSource.BLOCKS, 0.3f, 1.0f);
            return false;
        }
        if (!this.isEmpty() && serverPlayer.isCreative()) {
            this.spawnAtLocation(this.getItem(0));
        }
        if (!serverPlayer.isCreative() && CobblelootsConfig.getBooleanConfig("loot_ball.survival.drop.enabled")) {
            this.spawnAtLocation(this.getSurvivalLootBallItem());
        }
        this.playSound(SoundEvents.ARMOR_STAND_BREAK, 0.5f, 1.0f);
        this.discard();
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPARKS, (Object)true);
        builder.define(INVISIBLE, (Object)false);
        builder.define(CUSTOM_TEXTURE, (Object)"");
        builder.define(LOOT_BALL_DATA_ID, (Object)"");
        builder.define(VARIANT_ID, (Object)"");
        builder.define(OPENING_TICKS, (Object)0);
        builder.define(LOOT_BALL_CLIENT_DATA, (Object)new CompoundTag());
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.saveEntityVisualProperties(compoundTag);
        this.saveEntityIdentificationData(compoundTag);
        this.saveOpeners(compoundTag);
        this.saveNumericalProperties(compoundTag);
    }

    private void saveEntityVisualProperties(CompoundTag compoundTag) {
        compoundTag.putBoolean(TAG_SPARKS, this.hasSparks());
        compoundTag.putBoolean(TAG_INVISIBLE, this.isInvisible());
        String customTexture = (String)this.getEntityData().get(CUSTOM_TEXTURE);
        if (customTexture != null && !customTexture.isEmpty()) {
            compoundTag.putString(TAG_CUSTOM_TEXTURE, customTexture);
        }
    }

    private void saveEntityIdentificationData(CompoundTag compoundTag) {
        String variantId;
        String lootBallDataId = this.getLootBallDataId();
        if (lootBallDataId != null && !lootBallDataId.isEmpty()) {
            compoundTag.putString(TAG_LOOT_BALL_DATA_ID, lootBallDataId);
        }
        if ((variantId = this.getVariantId()) != null && !variantId.isEmpty()) {
            compoundTag.putString(TAG_VARIANT_ID, variantId);
        }
    }

    private void saveOpeners(CompoundTag compoundTag) {
        if (this.openers.isEmpty()) {
            return;
        }
        ListTag openersTag = new ListTag();
        for (Map.Entry<UUID, Long> entry : this.openers.entrySet()) {
            CompoundTag openerTag = new CompoundTag();
            openerTag.putUUID("UUID", entry.getKey());
            openerTag.putLong("Timestamp", entry.getValue().longValue());
            openersTag.add((Object)openerTag);
        }
        compoundTag.put(TAG_OPENERS, (Tag)openersTag);
    }

    private void saveNumericalProperties(CompoundTag compoundTag) {
        if (this.uses != DEFAULT_USES) {
            compoundTag.putInt(TAG_USES, this.uses);
        }
        if (this.multiplier != DEFAULT_MULTIPLIER) {
            compoundTag.putFloat(TAG_MULTIPLIER, this.multiplier);
        }
        if (this.despawnTick != DEFAULT_DESPAWN_TICK) {
            compoundTag.putLong(TAG_DESPAWN_TICK, this.despawnTick);
        }
        if (this.playerTimer != DEFAULT_PLAYER_TIMER) {
            compoundTag.putLong(TAG_PLAYER_TIMER, this.playerTimer);
        }
        if (this.xp != DEFAULT_XP) {
            compoundTag.putInt(TAG_XP, this.xp);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setSparks(compoundTag.getBoolean(TAG_SPARKS));
        this.setInvisible(compoundTag.getBoolean(TAG_INVISIBLE));
        this.readTextureFromTag(compoundTag);
        this.readLootBallDataFromTag(compoundTag);
        if (compoundTag.contains(TAG_VARIANT_ID)) {
            this.setVariantId(compoundTag.getString(TAG_VARIANT_ID));
        }
        this.readOpenersFromTag(compoundTag);
        this.readNumericalValuesFromTag(compoundTag);
    }

    private void readTextureFromTag(CompoundTag compoundTag) {
        ResourceLocation textureLocation;
        String texturePath;
        if (compoundTag.contains(TAG_CUSTOM_TEXTURE) && !(texturePath = compoundTag.getString(TAG_CUSTOM_TEXTURE)).isEmpty() && (textureLocation = ResourceLocation.tryParse((String)texturePath)) != null) {
            this.setTexture(textureLocation);
        }
    }

    private void readLootBallDataFromTag(CompoundTag compoundTag) {
        ResourceLocation lootBallDataLocation;
        String dataPath;
        if (compoundTag.contains(TAG_LOOT_BALL_DATA_ID) && !(dataPath = compoundTag.getString(TAG_LOOT_BALL_DATA_ID)).isEmpty() && (lootBallDataLocation = ResourceLocation.tryParse((String)dataPath)) != null) {
            this.setLootBallDataId(lootBallDataLocation);
        }
    }

    private void readOpenersFromTag(CompoundTag compoundTag) {
        if (compoundTag.contains(TAG_OPENERS)) {
            ListTag openersTag = compoundTag.getList(TAG_OPENERS, 10);
            this.openers.clear();
            for (int i = 0; i < openersTag.size(); ++i) {
                CompoundTag openerTag = openersTag.getCompound(i);
                if (!openerTag.contains("UUID") || !openerTag.contains("Timestamp")) continue;
                UUID uuid = openerTag.getUUID("UUID");
                long timestamp = openerTag.getLong("Timestamp");
                this.openers.put(uuid, timestamp);
            }
        }
    }

    private void readNumericalValuesFromTag(CompoundTag compoundTag) {
        this.uses = compoundTag.contains(TAG_USES) ? compoundTag.getInt(TAG_USES) : DEFAULT_USES;
        this.multiplier = compoundTag.contains(TAG_MULTIPLIER) ? compoundTag.getFloat(TAG_MULTIPLIER) : DEFAULT_MULTIPLIER;
        this.despawnTick = compoundTag.contains(TAG_DESPAWN_TICK) ? compoundTag.getLong(TAG_DESPAWN_TICK) : DEFAULT_DESPAWN_TICK;
        this.playerTimer = compoundTag.contains(TAG_PLAYER_TIMER) ? compoundTag.getLong(TAG_PLAYER_TIMER) : DEFAULT_PLAYER_TIMER;
        this.xp = compoundTag.contains(TAG_XP) ? compoundTag.getInt(TAG_XP) : DEFAULT_XP;
    }

    public boolean isPushable() {
        return false;
    }

    public void setYHeadRot(float f) {
        super.setYHeadRot(f);
        super.setYBodyRot(f);
    }

    public void setYBodyRot(float f) {
        super.setYBodyRot(f);
        super.setYHeadRot(f);
    }

    public void tick() {
        super.tick();
        this.openingTick();
        if (!this.level().isClientSide() && this.getDespawnTick() > 0L && this.level().getGameTime() >= this.getDespawnTick()) {
            this.discard();
        }
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public void baseTick() {
        super.baseTick();
        this.level().getProfiler().push("cobblelootsLootBallEntityBaseTick");
        this.trySpawnParticles();
        this.level().getProfiler().pop();
    }

    private void trySpawnParticles() {
        if (this.random.nextFloat() > 0.05f) {
            return;
        }
        double x = this.getX() + this.random.nextGaussian() * 0.1;
        double y = this.getY() + 0.5 + this.random.nextGaussian() * 0.1;
        double z = this.getZ() + this.random.nextGaussian() * 0.1;
        double vx = this.random.nextGaussian() * 0.1;
        double vy = this.random.nextGaussian() * 0.1;
        double vz = this.random.nextGaussian() * 0.1;
        if (this.isInvisible() && this.hasSparks()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, x, y, z, vx, vy, vz);
        }
        if (this.isInWater()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, x, y, z, vx, vy, vz);
        }
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    @Override
    public int getContainerSize() {
        return 1;
    }

    @Override
    public ResourceLocation getLootTableLocation() {
        ResourceLocation tableLocation = super.getLootTableLocation();
        if (tableLocation == null) {
            CobblelootsLootBallData lootBallData = this.getLootBallData();
            if (lootBallData == null) {
                return CobblelootsDefinitions.EMPTY_LOCATION;
            }
            CobblelootsLootBallVariantData variantData = this.getVariantData();
            if (variantData != null && variantData.getLootTable() != null && !variantData.getLootTable().equals((Object)CobblelootsDefinitions.EMPTY_LOCATION)) {
                tableLocation = variantData.getLootTable();
            } else if (lootBallData.getLootTable() != null && !lootBallData.getLootTable().equals((Object)CobblelootsDefinitions.EMPTY_LOCATION)) {
                tableLocation = lootBallData.getLootTable();
            } else {
                return CobblelootsDefinitions.EMPTY_LOCATION;
            }
        }
        return tableLocation;
    }

    private void tryOpen(ServerPlayer serverPlayer) {
        if (!this.canPlayerOpenLootBall(serverPlayer)) {
            return;
        }
        this.unpackLootTable(serverPlayer);
        if (!this.isEmpty()) {
            this.startOpeningAnimation(serverPlayer);
        } else {
            serverPlayer.sendSystemMessage((Component)CobblelootsUtils.cobblelootsText(TEXT_INFO_NO_LOOT, new Object[0]).withStyle(ChatFormatting.GRAY), true);
        }
    }

    private boolean canPlayerOpenLootBall(ServerPlayer serverPlayer) {
        if (this.isOpening) {
            serverPlayer.sendSystemMessage((Component)CobblelootsUtils.cobblelootsText(TEXT_ERROR_IS_OPENING, new Object[0]).withStyle(ChatFormatting.RED), true);
            return false;
        }
        if (this.isOpener(serverPlayer) && !this.handleAlreadyOpenedError(serverPlayer)) {
            return false;
        }
        if (this.getRemainingUses() == 0) {
            serverPlayer.sendSystemMessage((Component)CobblelootsUtils.cobblelootsText(TEXT_ERROR_ALREADY_OPENED, new Object[0]).withStyle(ChatFormatting.RED), true);
            return false;
        }
        return true;
    }

    private boolean handleAlreadyOpenedError(ServerPlayer serverPlayer) {
        if (this.getPlayerTimer() > 0L) {
            long lastOpenTime = this.openers.getOrDefault(serverPlayer.getUUID(), 0L);
            long timeDiff = this.level().getGameTime() - lastOpenTime;
            if (timeDiff < this.getPlayerTimer()) {
                long remainingSeconds = (long)Math.ceil((float)(this.getPlayerTimer() - timeDiff) / 20.0f);
                serverPlayer.sendSystemMessage((Component)CobblelootsUtils.cobblelootsText(TEXT_ERROR_COOLDOWN, String.valueOf(remainingSeconds)).withStyle(ChatFormatting.RED), true);
                return false;
            }
            return true;
        }
        serverPlayer.sendSystemMessage((Component)CobblelootsUtils.cobblelootsText(TEXT_ERROR_ALREADY_OPENED, new Object[0]).withStyle(ChatFormatting.RED), true);
        return false;
    }

    private void startOpeningAnimation(ServerPlayer serverPlayer) {
        this.pendingOpener = serverPlayer;
        this.isOpening = true;
        this.wasInvisible = this.isInvisible();
        this.setInvisible(false);
        this.setOpeningTicks(50);
        if (this.getDespawnTick() > 0L) {
            this.setDespawnTick(this.level().getGameTime() + 250L);
        }
    }

    private long getPlayerTimer() {
        return this.playerTimer;
    }

    private void setOpeningTicks(int i) {
        this.getEntityData().set(OPENING_TICKS, (Object)i);
    }

    private int getOpeningTicks() {
        return (Integer)this.getEntityData().get(OPENING_TICKS);
    }

    private void open(ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        this.deliverItemsToPlayer(serverPlayer);
        this.awardExperienceIfEnabled(serverPlayer);
        this.decrementUsesIfNotInfinite();
        this.clearInventoryIfUsingLootTable();
        this.setChanged();
    }

    private void deliverItemsToPlayer(ServerPlayer serverPlayer) {
        for (ItemStack itemStack : this.itemStacks) {
            if (itemStack.isEmpty()) continue;
            ItemStack deliveredItem = this.prepareItemForDelivery(itemStack.copy());
            this.notifyPlayerAboutItem(serverPlayer, deliveredItem);
            serverPlayer.getInventory().placeItemBackInInventory(deliveredItem);
            this.addOpener(serverPlayer);
            this.playSound(CobblelootsLootBallSounds.getPopItemSound());
            serverPlayer.playNotifySound(CobblelootsLootBallSounds.getFanfare(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private ItemStack prepareItemForDelivery(ItemStack item) {
        int multipliedCount = (int)Math.ceil((float)item.getCount() * this.getMultiplier());
        item.setCount(multipliedCount);
        return item;
    }

    private void notifyPlayerAboutItem(ServerPlayer serverPlayer, ItemStack item) {
        MutableComponent message = this.getMultiplier() > 1.0f ? CobblelootsUtils.cobblelootsText(TEXT_OPEN_SUCCESS_BONUS, String.valueOf(this.getMultiplier()), item.getHoverName().getString(), String.valueOf(item.getCount())).withStyle(ChatFormatting.AQUA) : CobblelootsUtils.cobblelootsText(TEXT_OPEN_SUCCESS, item.getHoverName().getString(), String.valueOf(item.getCount())).withStyle(ChatFormatting.AQUA);
        serverPlayer.sendSystemMessage((Component)message, true);
    }

    private void awardExperienceIfEnabled(ServerPlayer serverPlayer) {
        if (CobblelootsConfig.getBooleanConfig("loot_ball.xp.enabled") && this.getXP() > 0) {
            serverPlayer.giveExperiencePoints(this.getXP());
        }
    }

    private void decrementUsesIfNotInfinite() {
        if (!this.isInfinite()) {
            this.setRemainingUses(this.getRemainingUses() - 1);
        }
    }

    private void clearInventoryIfUsingLootTable() {
        ResourceLocation lootTableLocation = this.getLootTableLocation();
        if (lootTableLocation != null && !lootTableLocation.equals((Object)CobblelootsDefinitions.EMPTY_LOCATION)) {
            this.clearContent();
        }
    }

    public boolean isOpener(ServerPlayer serverPlayer) {
        return this.openers.containsKey(serverPlayer.getUUID());
    }

    public void addOpener(ServerPlayer serverPlayer) {
        this.openers.put(serverPlayer.getUUID(), this.level().getGameTime());
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void setRemainingUses(int uses) {
        this.uses = uses;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public boolean hasSparks() {
        return (Boolean)this.getEntityData().get(SPARKS);
    }

    public String getLootBallDataId() {
        return (String)this.getEntityData().get(LOOT_BALL_DATA_ID);
    }

    public String getVariantId() {
        return (String)this.getEntityData().get(VARIANT_ID);
    }

    @Nullable
    public CobblelootsLootBallData getLootBallData() {
        ResourceLocation dataLocation = ResourceLocation.tryParse((String)this.getLootBallDataId());
        if (dataLocation == null) {
            return null;
        }
        return CobblelootsDataProvider.getLootBallData(dataLocation);
    }

    @Nullable
    public CobblelootsLootBallVariantData getVariantData() {
        CobblelootsLootBallData lootBallData = this.getLootBallData();
        if (lootBallData == null) {
            return null;
        }
        return lootBallData.getVariants().get(this.getVariantId());
    }

    public CompoundTag getLootBallClientData() {
        return (CompoundTag)this.getEntityData().get(LOOT_BALL_CLIENT_DATA);
    }

    public void updateLootBallClientData() {
        CompoundTag compoundTag = new CompoundTag();
        ResourceLocation texture = this.getTextureFromServerData();
        if (texture != null) {
            compoundTag.putString(TAG_CUSTOM_TEXTURE, texture.toString());
        }
        this.getEntityData().set(LOOT_BALL_CLIENT_DATA, (Object)compoundTag);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if ((key.equals(CUSTOM_TEXTURE) || key.equals(LOOT_BALL_DATA_ID) || key.equals(VARIANT_ID)) && !this.level().isClientSide()) {
            this.updateLootBallClientData();
        }
    }

    public String getTextureId() {
        return this.getTexture().toString();
    }

    @NotNull
    public ResourceLocation getTexture() {
        ResourceLocation textureLocation = this.level().isClientSide() ? this.getTextureFromClientData() : this.getTextureFromServerData();
        return textureLocation != null ? textureLocation : CobblelootsDefinitions.EMPTY_LOCATION;
    }

    @Nullable
    private ResourceLocation getTextureFromClientData() {
        CompoundTag compoundTag = this.getLootBallClientData();
        if (compoundTag == null || !compoundTag.contains(TAG_CUSTOM_TEXTURE)) {
            return null;
        }
        String texturePath = compoundTag.getString(TAG_CUSTOM_TEXTURE);
        if (texturePath.isEmpty()) {
            return null;
        }
        return ResourceLocation.tryParse((String)texturePath);
    }

    @Nullable
    private ResourceLocation getTextureFromServerData() {
        ResourceLocation customLocation = this.getCustomTextureLocation();
        if (customLocation != null) {
            return customLocation;
        }
        return this.getLootBallDataTexture();
    }

    @Nullable
    private ResourceLocation getCustomTextureLocation() {
        String customTexture = (String)this.getEntityData().get(CUSTOM_TEXTURE);
        if (customTexture.isEmpty()) {
            return null;
        }
        return ResourceLocation.tryParse((String)customTexture);
    }

    @Nullable
    private ResourceLocation getLootBallDataTexture() {
        CobblelootsLootBallVariantData variantData;
        CobblelootsLootBallData lootBallData = this.getLootBallData();
        if (lootBallData == null) {
            return null;
        }
        String variantId = this.getVariantId();
        if (!variantId.isEmpty() && (variantData = lootBallData.getVariants().get(variantId)) != null && variantData.getTexture() != null && !variantData.getTexture().equals((Object)CobblelootsDefinitions.EMPTY_LOCATION)) {
            return variantData.getTexture();
        }
        return lootBallData.getTexture();
    }

    public void setSparks(boolean sparks) {
        this.getEntityData().set(SPARKS, (Object)sparks);
    }

    public void setVariantId(String variantId) {
        this.getEntityData().set(VARIANT_ID, (Object)variantId);
        this.updateLootBallClientData();
    }

    public void setLootBallDataId(ResourceLocation lootBallData) {
        this.getEntityData().set(LOOT_BALL_DATA_ID, (Object)lootBallData.toString());
        this.updateLootBallClientData();
    }

    public void setTexture(ResourceLocation texture) {
        this.getEntityData().set(CUSTOM_TEXTURE, (Object)texture.toString());
        this.updateLootBallClientData();
    }

    public void setDespawnTick(long tick) {
        this.despawnTick = tick;
    }

    public long getDespawnTick() {
        return this.despawnTick;
    }

    public boolean isInfinite() {
        return this.uses <= -1;
    }

    public int getXP() {
        if (this.xp != DEFAULT_XP) {
            return this.xp;
        }
        CobblelootsLootBallData lootBallData = this.getLootBallData();
        if (lootBallData != null && lootBallData.getXp() > 0) {
            return lootBallData.getXp();
        }
        return this.xp;
    }

    private void toggleVisibility(ServerPlayer serverPlayer) {
        serverPlayer.sendSystemMessage((Component)CobblelootsUtils.cobblelootsText(TEXT_TOGGLE_VISIBILITY, new Object[0]).withStyle(ChatFormatting.AQUA), true);
        serverPlayer.playNotifySound(CobblelootsLootBallSounds.getToggleInvisibilitySound(), SoundSource.BLOCKS, 0.5f, 1.0f);
        this.setInvisible(!this.isInvisible());
    }

    private void toggleSparks(ServerPlayer serverPlayer) {
        serverPlayer.sendSystemMessage((Component)CobblelootsUtils.cobblelootsText(TEXT_TOGGLE_SPARKS, new Object[0]).withStyle(ChatFormatting.AQUA), true);
        serverPlayer.playNotifySound(CobblelootsLootBallSounds.getToggleSparksSound(this.hasSparks()), SoundSource.BLOCKS, 0.5f, 1.0f);
        this.setSparks(!this.hasSparks());
    }

    private void setLootBallItem(ItemStack itemStack, ServerPlayer serverPlayer) {
        this.setItem(0, itemStack);
        if (!serverPlayer.isCreative()) {
            serverPlayer.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        serverPlayer.sendSystemMessage((Component)CobblelootsUtils.cobblelootsText(TEXT_SET_ITEM, itemStack.getHoverName().getString(), String.valueOf(itemStack.getCount())).withStyle(ChatFormatting.AQUA), true);
        serverPlayer.playNotifySound(CobblelootsLootBallSounds.getSetItemSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
        this.setChanged();
    }

    private ItemStack getSurvivalLootBallItem() {
        Component nameComponent;
        ItemStack lootBallItem = new ItemStack((ItemLike)CobblelootsItems.getLootBallItem());
        CompoundTag tag = this.createSurvivalLootBallItemTag();
        if (!tag.isEmpty()) {
            lootBallItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        if (!(nameComponent = this.getLootBallNameComponent()).equals((Object)Component.empty())) {
            lootBallItem.set(DataComponents.CUSTOM_NAME, (Object)nameComponent);
        }
        return lootBallItem;
    }

    private ItemStack getCreativeLootBallItem() {
        Component nameComponent;
        ItemStack lootBallItem = new ItemStack((ItemLike)CobblelootsItems.getLootBallItem());
        CompoundTag tag = this.createCreativeLootBallItemTag();
        if (!tag.isEmpty()) {
            lootBallItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        if (!(nameComponent = this.getLootBallNameComponent()).equals((Object)Component.empty())) {
            lootBallItem.set(DataComponents.CUSTOM_NAME, (Object)nameComponent);
        }
        return lootBallItem;
    }

    private Component getLootBallNameComponent() {
        CobblelootsLootBallData data = this.getLootBallData();
        CobblelootsLootBallVariantData variantData = this.getVariantData();
        if (variantData != null) {
            return variantData.getName();
        }
        if (data != null) {
            return data.getName();
        }
        return Component.empty();
    }

    private CompoundTag createSurvivalLootBallItemTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString(TAG_LOOT_BALL_DATA_ID, this.getLootBallDataId());
        tag.putString(TAG_VARIANT_ID, this.getVariantId());
        tag.putString(TAG_CUSTOM_TEXTURE, this.getTextureId());
        tag.putBoolean(TAG_INVISIBLE, false);
        tag.putInt(TAG_USES, 0);
        tag.putLong(TAG_DESPAWN_TICK, 0L);
        return tag;
    }

    private CompoundTag createCreativeLootBallItemTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString(TAG_LOOT_BALL_DATA_ID, this.getLootBallDataId());
        tag.putString(TAG_VARIANT_ID, this.getVariantId());
        tag.putString(TAG_CUSTOM_TEXTURE, this.getTextureId());
        tag.putBoolean(TAG_SPARKS, this.hasSparks());
        tag.putBoolean(TAG_INVISIBLE, this.isInvisible());
        tag.putInt(TAG_USES, this.getRemainingUses());
        tag.putFloat(TAG_MULTIPLIER, this.getMultiplier());
        tag.putLong(TAG_DESPAWN_TICK, this.getDespawnTick());
        tag.putLong(TAG_PLAYER_TIMER, this.getPlayerTimer());
        tag.putInt(TAG_XP, this.getXP());
        return tag;
    }

    private void openingTick() {
        if (this.level().isClientSide()) {
            this.handleClientAnimations();
        } else {
            this.handleServerAnimations();
        }
    }

    private void handleClientAnimations() {
        int currentTicks = this.getOpeningTicks();
        boolean animationStarted = this.openingAnimationState.isStarted();
        if (currentTicks > 0 && !animationStarted) {
            this.openingAnimationState.start(this.tickCount);
        } else if (currentTicks == 0 && animationStarted) {
            this.openingAnimationState.stop();
        }
    }

    private void handleServerAnimations() {
        int currentTicks = this.getOpeningTicks();
        if (currentTicks > 0) {
            if (currentTicks == 50) {
                this.playSound(CobblelootsLootBallSounds.getLidOpenSound());
            } else if (currentTicks == 25) {
                this.open(this.pendingOpener);
            }
            this.setOpeningTicks(currentTicks - 1);
        } else if (currentTicks == 0 && this.pendingOpener != null) {
            this.pendingOpener = null;
            this.isOpening = false;
            this.setInvisible(this.wasInvisible);
            this.playSound(CobblelootsLootBallSounds.getLidCloseSound());
            if (CobblelootsConfig.getBooleanConfig("loot_ball.survival.destroy_looted") && !this.isInfinite() && this.getRemainingUses() <= 0) {
                this.discard();
                return;
            }
            if (CobblelootsConfig.getBooleanConfig("loot_ball.survival.drop.enabled") && CobblelootsConfig.getBooleanConfig("loot_ball.survival.drop.automatic") && !this.isInfinite() && this.getRemainingUses() <= 0) {
                this.discard();
                this.spawnAtLocation(this.getSurvivalLootBallItem());
                this.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM);
            }
        }
    }

    public ItemStack getPickResult() {
        return this.getCreativeLootBallItem();
    }
}

