/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.entity.custom;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CobblelootsBaseContainerEntity
extends LivingEntity
implements Container {
    private static final NonNullList<ItemStack> EMPTY_STACK_LIST = NonNullList.createWithCapacity((int)0);
    protected ResourceLocation lootTableLocation;
    protected long lootTableSeed;
    private static final String TAG_LOOT_TABLE = "LootTable";
    private static final String TAG_LOOT_TABLE_SEED = "LootTableSeed";

    protected CobblelootsBaseContainerEntity(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isInvulnerable() {
        return true;
    }

    public boolean canFreeze() {
        return false;
    }

    protected void onBelowWorld() {
        this.discard();
    }

    public boolean canBeSeenAsEnemy() {
        return false;
    }

    public void kill() {
        this.discard();
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        return EMPTY_STACK_LIST;
    }

    @NotNull
    public ItemStack getItemBySlot(EquipmentSlot equipmentSlot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    @NotNull
    public HumanoidArm getMainArm() {
        return HumanoidArm.LEFT;
    }

    protected boolean shouldDropLoot() {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        if (this.lootTableLocation != null) {
            compoundTag.putString(TAG_LOOT_TABLE, this.lootTableLocation.toString());
            if (this.getLootTableSeed() != 0L) {
                compoundTag.putLong(TAG_LOOT_TABLE_SEED, this.getLootTableSeed());
            }
        } else {
            ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.clearItemStacks();
        if (compoundTag.contains(TAG_LOOT_TABLE, 8)) {
            this.setLootTableLocation(ResourceLocation.tryParse((String)compoundTag.getString(TAG_LOOT_TABLE)));
            this.setLootTableSeed(compoundTag.getLong(TAG_LOOT_TABLE_SEED));
        } else {
            ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
        }
    }

    public void clearItemStacks() {
        this.getItemStacks().clear();
    }

    public void setLootTableSeed(long l) {
        this.lootTableSeed = l;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.getItemStacks()) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public abstract NonNullList<ItemStack> getItemStacks();

    public abstract int getContainerSize();

    @NotNull
    public ItemStack getItem(int i) {
        return (ItemStack)this.getItemStacks().get(i);
    }

    @NotNull
    public ItemStack removeItem(int i, int j) {
        return ContainerHelper.removeItem(this.getItemStacks(), (int)i, (int)j);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        ItemStack itemStack = (ItemStack)this.getItemStacks().get(i);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.getItemStacks().set(i, (Object)ItemStack.EMPTY);
        return itemStack;
    }

    public void setItem(int i, ItemStack itemStack) {
        this.getItemStacks().set(i, (Object)itemStack);
        itemStack.limitSize(this.getMaxStackSize(itemStack));
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return !this.isRemoved() && player.canInteractWithEntity(this.getBoundingBox(), 4.0);
    }

    public void clearContent() {
        this.getItemStacks().clear();
    }

    @Nullable
    public ResourceLocation getLootTableLocation() {
        return this.lootTableLocation;
    }

    protected void unpackLootTable(ServerPlayer serverPlayer) {
        MinecraftServer minecraftServer = this.level().getServer();
        ResourceLocation tableLocation = this.getLootTableLocation();
        if (tableLocation != null && minecraftServer != null && this.isEmpty()) {
            ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)tableLocation);
            LootTable lootTable = minecraftServer.reloadableRegistries().getLootTable(resourceKey);
            if (serverPlayer != null) {
                CriteriaTriggers.GENERATE_LOOT.trigger(serverPlayer, resourceKey);
            }
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position());
            if (serverPlayer != null) {
                builder.withLuck(serverPlayer.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer);
            }
            lootTable.fill((Container)this, builder.create(LootContextParamSets.CHEST), this.lootTableSeed);
        }
    }

    private void setLootTableLocation(ResourceLocation resourceLocation) {
        this.lootTableLocation = resourceLocation;
    }
}

