/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.ripio.cobbleloots.Cobbleloots;
import dev.ripio.cobbleloots.config.CobblelootsConfig;
import dev.ripio.cobbleloots.data.CobblelootsCodecs;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallData;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallResourceLocation;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallSources;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsBlockFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsDateFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsLightFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsPositionFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsSourceFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsTimeFilter;
import dev.ripio.cobbleloots.data.custom.filter.CobblelootsWeatherFilter;
import dev.ripio.cobbleloots.util.CobblelootsDefinitions;
import dev.ripio.cobbleloots.util.enums.CobblelootsSourceType;
import dev.ripio.cobbleloots.util.math.CobblelootsMath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CobblelootsDataProvider {
    private static final Map<ResourceLocation, CobblelootsLootBallData> lootBallsData = new HashMap<ResourceLocation, CobblelootsLootBallData>();
    private static final List<CobblelootsLootBallResourceLocation> disabledLootBalls = new ArrayList<CobblelootsLootBallResourceLocation>();

    public static void addLootBallData(ResourceLocation id, JsonElement json) {
        DataResult result = CobblelootsCodecs.LOOT_BALL_DATA_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        CobblelootsLootBallData data = (CobblelootsLootBallData)result.resultOrPartial(arg_0 -> ((Logger)Cobbleloots.LOGGER).error(arg_0)).orElseThrow();
        lootBallsData.put(id, data);
    }

    public static void removeLootBallData(List<ResourceLocation> ids) {
        ids.forEach(lootBallsData::remove);
    }

    public static List<ResourceLocation> getExistingLootBallIds() {
        return new ArrayList<ResourceLocation>(lootBallsData.keySet());
    }

    @Nullable
    public static CobblelootsLootBallData getLootBallData(ResourceLocation id) {
        return lootBallsData.get(id);
    }

    public static Map.Entry<ResourceLocation, CobblelootsLootBallData> getRandomLootBallData(ServerLevel level, LevelChunk levelChunk, BlockPos pos, CobblelootsSourceType sourceType) {
        Map.Entry weightEntry;
        HashMap<ResourceLocation, Integer> filtered = new HashMap<ResourceLocation, Integer>();
        for (ResourceLocation id : CobblelootsDataProvider.getExistingLootBallIds()) {
            CobblelootsLootBallData data = CobblelootsDataProvider.getLootBallData(id);
            if (data == null) {
                Cobbleloots.LOGGER.error("Data not found for id: {}", (Object)id);
                continue;
            }
            CobblelootsLootBallSources sourcesData = data.getSources();
            if (sourcesData == null) continue;
            for (CobblelootsSourceFilter filter : switch (sourceType) {
                case CobblelootsSourceType.GENERATION -> sourcesData.getGeneration();
                case CobblelootsSourceType.SPAWNING -> sourcesData.getSpawning();
                case CobblelootsSourceType.FISHING -> sourcesData.getFishing();
                case CobblelootsSourceType.ARCHAEOLOGY -> sourcesData.getArchaeology();
                default -> throw new IllegalStateException("Unexpected sourceType value: " + String.valueOf((Object)sourceType));
            }) {
                if (!CobblelootsDataProvider.processSourceFilter(level, levelChunk, pos, filter, sourceType)) continue;
                filtered.put(id, filter.getWeight());
            }
        }
        if (!filtered.isEmpty() && (weightEntry = CobblelootsMath.weightedRandomEntry(filtered)) != null) {
            ResourceLocation key = (ResourceLocation)weightEntry.getKey();
            CobblelootsLootBallData value = CobblelootsDataProvider.getLootBallData(key);
            return new AbstractMap.SimpleEntry<ResourceLocation, CobblelootsLootBallData>(key, value);
        }
        return null;
    }

    public static boolean processSourceFilter(ServerLevel level, LevelChunk chunk, BlockPos pos, CobblelootsSourceFilter source, CobblelootsSourceType sourceType) {
        if (level == null || pos == null || source == null) {
            return false;
        }
        if (CobblelootsDataProvider.isDimensionDisabled(level, sourceType)) {
            return false;
        }
        if (!CobblelootsDataProvider.checkStructureFilter(level, pos, source.getStructure())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkBiomeFilter(level, pos, source.getBiome())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkDimensionFilter(level, source.getDimension())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkBlockFilter(level, chunk, pos, source.getBlock())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkFluidFilter(level, chunk, pos, source.getFluid())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkPositionFilter(pos, source.getPosition())) {
            return false;
        }
        if (sourceType == CobblelootsSourceType.SPAWNING && !CobblelootsDataProvider.checkLightFilter(level, pos, source.getLight())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkTimeFilter(level, source.getTime())) {
            return false;
        }
        if (!CobblelootsDataProvider.checkWeatherFilter(level, source.getWeather())) {
            return false;
        }
        return CobblelootsDataProvider.checkDateFilter(source.getDate());
    }

    private static boolean checkStructureFilter(ServerLevel level, BlockPos pos, TagKey<Structure> structureTag) {
        if (structureTag == null || structureTag.equals(CobblelootsDefinitions.EMPTY_STRUCTURE_TAG)) {
            return true;
        }
        StructureStart structureStart = level.structureManager().getStructureWithPieceAt(pos, holder -> holder.is(structureTag));
        return structureStart != null && structureStart.isValid();
    }

    private static boolean checkBiomeFilter(ServerLevel level, BlockPos pos, TagKey<Biome> biomeTag) {
        if (biomeTag == null || biomeTag.equals(CobblelootsDefinitions.EMPTY_BIOME_TAG)) {
            return true;
        }
        return level.getBiome(pos).is(biomeTag);
    }

    private static boolean checkDimensionFilter(ServerLevel level, List<ResourceLocation> dimensionIds) {
        if (dimensionIds == null || dimensionIds.isEmpty()) {
            return true;
        }
        return dimensionIds.contains(level.dimension().location());
    }

    private static boolean checkBlockFilter(ServerLevel level, LevelChunk chunk, BlockPos spawnPos, CobblelootsBlockFilter blockFilter) {
        if (blockFilter == null) {
            return true;
        }
        LevelChunkSection[] sections = chunk.getSections();
        BlockPos basePos = spawnPos.below();
        int baseSectionIndex = chunk.getSectionIndex(basePos.getY());
        if (baseSectionIndex < 0 || baseSectionIndex >= sections.length) {
            return false;
        }
        LevelChunkSection baseSection = sections[baseSectionIndex];
        BlockState baseBlockState = baseSection.getBlockState(basePos.getX() & 0xF, basePos.getY() & 0xF, basePos.getZ() & 0xF);
        int spawnSectionIndex = chunk.getSectionIndex(spawnPos.getY());
        LevelChunkSection spawnSection = sections[spawnSectionIndex];
        BlockState spawnBlockState = spawnSection.getBlockState(spawnPos.getX() & 0xF, spawnPos.getY() & 0xF, spawnPos.getZ() & 0xF);
        return blockFilter.isSpawnable(spawnBlockState) && blockFilter.isBase(baseBlockState);
    }

    private static boolean checkFluidFilter(ServerLevel level, LevelChunk chunk, BlockPos pos, TagKey<Fluid> fluidTag) {
        if (fluidTag == null || fluidTag.equals(CobblelootsDefinitions.EMPTY_FLUID_TAG)) {
            return true;
        }
        LevelChunkSection[] sections = chunk.getSections();
        int sectionIndex = chunk.getSectionIndex(pos.getY());
        LevelChunkSection section = sections[sectionIndex];
        FluidState fluidState = section.getFluidState(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF);
        return fluidState.is(fluidTag);
    }

    private static boolean checkPositionFilter(BlockPos pos, CobblelootsPositionFilter positionFilter) {
        if (positionFilter == null) {
            return true;
        }
        return positionFilter.isInRange(pos.getX(), pos.getY(), pos.getZ());
    }

    private static boolean checkLightFilter(ServerLevel level, BlockPos pos, CobblelootsLightFilter lightFilter) {
        if (lightFilter == null) {
            return true;
        }
        int blockLight = level.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = level.getBrightness(LightLayer.SKY, pos);
        return lightFilter.isInRange(blockLight, skyLight);
    }

    private static boolean checkTimeFilter(ServerLevel level, CobblelootsTimeFilter timeFilter) {
        if (timeFilter == null) {
            return true;
        }
        long currentTime = level.getDayTime();
        currentTime = timeFilter.getPeriod() > 0 ? level.getDayTime() % (long)timeFilter.getPeriod() : level.getDayTime();
        return timeFilter.getValue().isInRange((int)currentTime);
    }

    private static boolean checkWeatherFilter(ServerLevel level, CobblelootsWeatherFilter weatherFilter) {
        if (weatherFilter == null) {
            return true;
        }
        return weatherFilter.isValid(level.isRaining(), level.isThundering());
    }

    private static boolean checkDateFilter(CobblelootsDateFilter dateFilter) {
        if (dateFilter == null) {
            return true;
        }
        return dateFilter.test();
    }

    public static void onReload(ResourceManager resourceManager) {
        List<ResourceLocation> cachedLootBalls = CobblelootsDataProvider.getExistingLootBallIds();
        disabledLootBalls.clear();
        List<String> disabledLootBallsStrings = CobblelootsConfig.getStringList("loot_ball.disabled.loot_balls");
        for (String disabledString : disabledLootBallsStrings) {
            try {
                disabledLootBalls.add(new CobblelootsLootBallResourceLocation(disabledString));
            }
            catch (IllegalArgumentException e) {
                Cobbleloots.LOGGER.warn("Invalid format for disabled loot ball location in config: '{}'", (Object)disabledString);
            }
        }
        for (ResourceLocation id : resourceManager.listResources("loot_ball", path -> path.getPath().endsWith(".json")).keySet()) {
            ResourceLocation normalizedId = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath().replace(".json", ""));
            boolean isDisabled = false;
            for (CobblelootsLootBallResourceLocation disabled : disabledLootBalls) {
                if (!disabled.matches(normalizedId.getNamespace(), normalizedId.getPath(), "*")) continue;
                isDisabled = true;
                break;
            }
            if (isDisabled) {
                cachedLootBalls.remove(normalizedId);
                continue;
            }
            try {
                InputStream stream = resourceManager.getResourceOrThrow(id).open();
                try {
                    JsonObject jsonObject = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject();
                    CobblelootsDataProvider.addLootBallData(normalizedId, (JsonElement)jsonObject);
                    cachedLootBalls.remove(normalizedId);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (JsonSyntaxException | IOException | NullPointerException | NoSuchElementException e) {
                Cobbleloots.LOGGER.error("Error loading loot ball data: {}", (Object)id, (Object)e);
            }
        }
        CobblelootsDataProvider.removeLootBallData(cachedLootBalls);
        Cobbleloots.LOGGER.info("Loaded {} Loot Ball data definitions.", (Object)lootBallsData.size());
    }

    private static boolean isDimensionDisabled(ServerLevel level, CobblelootsSourceType sourceType) {
        List<ResourceLocation> disabledDimensions;
        ResourceLocation dimensionId = level.dimension().location();
        switch (sourceType) {
            case GENERATION: {
                disabledDimensions = CobblelootsConfig.getResourceLocationList("loot_ball.disabled.dimensions.generation");
                break;
            }
            case SPAWNING: {
                disabledDimensions = CobblelootsConfig.getResourceLocationList("loot_ball.disabled.dimensions.spawning");
                break;
            }
            case FISHING: {
                disabledDimensions = CobblelootsConfig.getResourceLocationList("loot_ball.disabled.dimensions.fishing");
                break;
            }
            case ARCHAEOLOGY: {
                disabledDimensions = CobblelootsConfig.getResourceLocationList("loot_ball.disabled.dimensions.archaeology");
                break;
            }
            default: {
                return false;
            }
        }
        return disabledDimensions != null && disabledDimensions.contains(dimensionId);
    }
}

