/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import javax.annotation.Nonnull;
import net.creeperhost.polylib.data.serializable.BooleanData;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.integration.Integration;
import vswe.stevescarts.polylib.EntityData;

public class ModuleRemover
extends ModuleWorker
implements IActivatorModule {
    @Nonnull
    private BlockPos remove;
    private final EntityData<Boolean> isEnabled = new EntityData(this.getCart(), new BooleanData(true));

    public ModuleRemover(EntityMinecartModular cart) {
        super(cart);
        this.remove = new BlockPos(0, -1, 0);
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public byte getWorkPriority() {
        return 120;
    }

    @Override
    protected boolean preventTurnback() {
        return true;
    }

    @Override
    public boolean work() {
        EntityMinecartModular cart = this.getCart();
        Level world = cart.level();
        if (this.remove.getY() != -1 && (this.remove.getX() != cart.x() || this.remove.getZ() != cart.z()) && this.removeRail(world, this.remove, true)) {
            return false;
        }
        BlockPos next = this.getNextblock();
        BlockPos last = this.getLastblock();
        boolean front = this.isRailAtCoords(world, next);
        boolean back = this.isRailAtCoords(world, last);
        if (!front) {
            if (back) {
                this.turnback();
                if (this.removeRail(world, cart.getExactPosition(), false)) {
                    return true;
                }
            }
        } else if (!back && this.removeRail(world, cart.getExactPosition(), false)) {
            return true;
        }
        return false;
    }

    private boolean isRailAtCoords(Level world, BlockPos coords) {
        return RailBlock.isRail((Level)world, (BlockPos)coords.above()) || RailBlock.isRail((Level)world, (BlockPos)coords) || RailBlock.isRail((Level)world, (BlockPos)coords.below());
    }

    private boolean removeRail(Level world, BlockPos pos, boolean flag) {
        if (flag) {
            BlockState blockState = world.getBlockState(pos);
            if (RailBlock.isRail((BlockState)blockState)) {
                if (this.isRemovingEnabled() && Integration.canEditBlock((ServerPlayer)this.getFakePlayer(), pos)) {
                    if (this.doPreWork()) {
                        this.startWorking(12);
                        return true;
                    }
                    ItemStack iStack = new ItemStack((ItemLike)blockState.getBlock(), 1);
                    this.getCart().addItemToChest(iStack);
                    if (iStack.getCount() == 0) {
                        world.removeBlock(pos, false);
                    }
                }
                this.remove = new BlockPos(pos.getX(), -1, pos.getZ());
            } else {
                this.remove = new BlockPos(pos.getX(), -1, pos.getZ());
            }
        } else if (RailBlock.isRail((Level)world, (BlockPos)pos.below())) {
            this.remove = pos.below();
        } else if (RailBlock.isRail((Level)world, (BlockPos)pos)) {
            this.remove = pos;
        } else if (RailBlock.isRail((Level)world, (BlockPos)pos.above())) {
            this.remove = pos.above();
        }
        this.stopWorking();
        return false;
    }

    private void enableRemoving(boolean remove) {
        if (!this.isPlaceholder()) {
            this.isEnabled.set(remove);
        }
    }

    private boolean isRemovingEnabled() {
        return !this.isPlaceholder() && this.isEnabled.get() != false;
    }

    @Override
    public void doActivate(int id) {
        this.enableRemoving(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.enableRemoving(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.isRemovingEnabled();
    }
}

