/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotIncinerator;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleIncinerator
extends ModuleAddon {
    public ModuleIncinerator(EntityMinecartModular cart) {
        super(cart);
    }

    public void incinerate(@Nonnull ItemStack item) {
        if (this.isItemValid(item)) {
            item.setCount(0);
        }
    }

    protected int getIncinerationCost() {
        return 3;
    }

    protected boolean isItemValid(@Nonnull ItemStack item) {
        if (!item.isEmpty()) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                if (this.getStack(i).isEmpty() || !ItemStack.isSameItem((ItemStack)item, (ItemStack)this.getStack(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return 4;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotIncinerator(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }
}

