/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.entities;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.events.CartEvents;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.blocks.BlockRailAdvDetector;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.ForceChunkHelper;
import vswe.stevescarts.helpers.GuiAllocationHelper;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModEntities;
import vswe.stevescarts.modules.addons.ModuleCreativeSupplies;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;
import vswe.stevescarts.modules.workers.CompWorkModule;
import vswe.stevescarts.polylib.DataEntity;
import vswe.stevescarts.polylib.EntityData;

public class EntityMinecartModular
extends AbstractMinecart
implements Container,
IEntityWithComplexSpawn,
IFluidHandler,
MenuProvider,
DataEntity {
    public BlockPos disabledPos;
    protected boolean wasDisabled;
    public double pushX;
    public double pushZ;
    public double temppushX;
    public double temppushZ;
    protected boolean engineFlag = false;
    private int motorRotation;
    public boolean cornerFlip;
    private List<ResourceLocation> moduleLoadingData;
    private RailShape fixedRailDirection = null;
    private BlockPos fixedRailPos;
    private int wrongRender;
    private boolean oldRender;
    private float lastRenderYaw;
    private double lastMotionX;
    private double lastMotionZ;
    private int workingTime;
    private ModuleWorker workingComponent;
    public TileEntityCartAssembler placeholderAsssembler;
    public boolean isPlaceholder;
    public int keepAlive;
    public static final int MODULAR_SPACE_WIDTH = 443;
    public static final int MODULAR_SPACE_HEIGHT = 168;
    public int modularSpaceHeight;
    public boolean canScrollModules;
    private ArrayList<ModuleCountPair> moduleCounts;
    private List<ChunkPos> forcedChunks = new ArrayList<ChunkPos>();
    public static final int[][][] railDirectionCoordinates;
    private ArrayList<ModuleBase> modules;
    private ArrayList<ModuleWorker> workModules;
    private ArrayList<ModuleEngine> engineModules;
    private ArrayList<ModuleTank> tankModules;
    private ModuleCreativeSupplies creativeSupplies;
    public RandomSource random;
    protected Component name;
    private int scrollY;
    @Deprecated(forRemoval=true)
    private int keepSilent;
    private final List<EntityData<?>> entityDataList = new ArrayList();
    private static final EntityDataAccessor<Boolean> IS_BURNING;
    private static final EntityDataAccessor<Boolean> IS_DISANABLED;
    int base = 0;
    protected final SimpleContainerData dataAccess = new SimpleContainerData(this, 0){

        public int get(int id) {
            throw new IllegalArgumentException("Invalid index: " + id);
        }

        public void set(int p_221477_1_, int p_221477_2_) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int getCount() {
            return 0;
        }
    };
    AbstractContainerMenu container = null;

    public ArrayList<ModuleBase> getModules() {
        return this.modules;
    }

    public boolean hasModule(Class<? extends ModuleBase> module) {
        for (ModuleBase moduleBase : this.getModules()) {
            if (!moduleBase.getClass().equals(module)) continue;
            return true;
        }
        return false;
    }

    public boolean hasModule(ModuleData moduleData) {
        if (moduleData == null) {
            return false;
        }
        for (ModuleBase module : this.getModules()) {
            if (module.getModuleId() != moduleData.getID()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ModuleWorker> getWorkers() {
        return this.workModules;
    }

    public ArrayList<ModuleEngine> getEngines() {
        return this.engineModules;
    }

    public ArrayList<ModuleTank> getModuleTanks() {
        return this.tankModules;
    }

    public ArrayList<ModuleCountPair> getModuleCounts() {
        return this.moduleCounts;
    }

    public EntityMinecartModular(Level world, double x, double y, double z, CompoundTag info, Component name) {
        super((EntityType)ModEntities.MODULAR_CART.get(), world, x, y, z);
        this.random = world.random;
        this.loadModules(info);
    }

    public EntityMinecartModular(Level world) {
        super((EntityType)ModEntities.MODULAR_CART.get(), world);
        this.random = world.random;
    }

    public EntityMinecartModular(EntityType<EntityMinecartModular> entityType, Level world) {
        super(entityType, world);
        this.random = RandomSource.create();
    }

    public EntityMinecartModular(Level world, TileEntityCartAssembler assembler, ArrayList<ResourceLocation> data) {
        this(world);
        this.setPlaceholder(assembler);
        this.loadPlaceHolderModules(data);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_BURNING, (Object)false);
        builder.define(IS_DISANABLED, (Object)false);
    }

    @Override
    public List<EntityData<?>> getEntityDataList() {
        return this.entityDataList;
    }

    @Override
    public void registerEntityData(EntityData<?> data) {
        this.entityDataList.add(data);
    }

    private void loadPlaceHolderModules(List<ResourceLocation> data) {
        if (this.modules == null) {
            this.modules = new ArrayList();
            for (ResourceLocation moduleResourceLocation : data) {
                ModuleData moduleData = StevesCartsAPI.MODULE_REGISTRY.get(moduleResourceLocation);
                this.doLoadModules(moduleData, null);
            }
        } else {
            this.modules.clear();
            for (ResourceLocation moduleResourceLocation : data) {
                ModuleData moduleData = StevesCartsAPI.MODULE_REGISTRY.get(moduleResourceLocation);
                this.doLoadModules(moduleData, null);
            }
        }
        this.initModules();
        this.moduleLoadingData = data;
    }

    private void doLoadModules(ModuleData moduleData, @org.jetbrains.annotations.Nullable CompoundTag data) {
        if (moduleData == null) {
            return;
        }
        try {
            Class<? extends ModuleBase> moduleClass = moduleData.getModuleClass();
            Constructor<? extends ModuleBase> moduleConstructor = moduleClass.getConstructor(EntityMinecartModular.class);
            ModuleBase module = moduleConstructor.newInstance(this);
            module.setModuleId(moduleData.getID());
            this.modules.add(module);
            if (data != null && data.contains("data")) {
                module.readExtraData(data.getCompound("data"));
            }
        }
        catch (Exception e) {
            StevesCarts.LOGGER.error("Failed to load module with ID " + String.valueOf(moduleData.getID()) + "! More info below.");
            e.printStackTrace();
        }
    }

    private void loadModules(CompoundTag info) {
        ArrayList<CompoundTag> modules = new ArrayList<CompoundTag>();
        if (info == null) {
            return;
        }
        ArrayList<ResourceLocation> names = new ArrayList<ResourceLocation>();
        ListTag listTag = (ListTag)info.get("modules");
        for (int i = 0; i < listTag.size(); ++i) {
            Tag tag = listTag.get(i);
            modules.add((CompoundTag)tag);
            names.add(ResourceLocation.parse((String)((CompoundTag)tag).getString(String.valueOf(i))));
        }
        if (!names.isEmpty()) {
            this.moduleLoadingData = names;
        }
        this.loadModules(modules);
    }

    public void updateSimulationModules(List<ResourceLocation> data) {
        if (!this.isPlaceholder) {
            StevesCarts.LOGGER.error("You're stupid! This is not a placeholder cart.");
        } else {
            this.loadPlaceHolderModules(data);
        }
    }

    protected void loadModules(List<CompoundTag> data) {
        this.modules = new ArrayList();
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                CompoundTag tag = data.get(i);
                ResourceLocation name = ResourceLocation.parse((String)tag.getString(String.valueOf(i)));
                this.doLoadModules(StevesCartsAPI.MODULE_REGISTRY.get(name), tag);
            }
        }
        this.initModules();
    }

    protected void loadModulesFromNames(List<ResourceLocation> data) {
        this.modules = new ArrayList();
        if (data != null) {
            for (ResourceLocation name : data) {
                this.doLoadModules(StevesCartsAPI.MODULE_REGISTRY.get(name), null);
            }
        }
        this.initModules();
    }

    /*
     * WARNING - void declaration
     */
    private void initModules() {
        this.moduleCounts = new ArrayList();
        for (ModuleBase module : this.modules) {
            ModuleData data = StevesCartsAPI.MODULE_REGISTRY.get(module.getModuleId());
            boolean found = false;
            for (ModuleCountPair moduleCountPair : this.moduleCounts) {
                if (!moduleCountPair.isContainingData(data)) continue;
                moduleCountPair.increase();
                found = true;
                break;
            }
            if (found) continue;
            this.moduleCounts.add(new ModuleCountPair(data));
        }
        for (ModuleBase module : this.modules) {
            module.preInit();
        }
        this.workModules = new ArrayList();
        this.engineModules = new ArrayList();
        this.tankModules = new ArrayList();
        int guidata = 0;
        int packets = 0;
        if (this.level().isClientSide) {
            this.generateModels();
        }
        for (ModuleBase module2 : this.modules) {
            if (module2 instanceof ModuleWorker) {
                this.workModules.add((ModuleWorker)module2);
                continue;
            }
            if (module2 instanceof ModuleEngine) {
                this.engineModules.add((ModuleEngine)module2);
                continue;
            }
            if (module2 instanceof ModuleTank) {
                this.tankModules.add((ModuleTank)module2);
                continue;
            }
            if (!(module2 instanceof ModuleCreativeSupplies)) continue;
            this.creativeSupplies = (ModuleCreativeSupplies)module2;
        }
        CompWorkModule sorter = new CompWorkModule();
        this.workModules.sort(sorter);
        if (!this.isPlaceholder) {
            void var6_17;
            ArrayList<GuiAllocationHelper> lines = new ArrayList<GuiAllocationHelper>();
            int slots = 0;
            for (ModuleBase module3 : this.modules) {
                if (module3.hasGui()) {
                    boolean foundLine = false;
                    for (GuiAllocationHelper line : lines) {
                        if (line.width + module3.guiWidth() > 443) continue;
                        module3.setX(line.width);
                        line.width += module3.guiWidth();
                        line.maxHeight = Math.max(line.maxHeight, module3.guiHeight());
                        line.modules.add(module3);
                        foundLine = true;
                        break;
                    }
                    if (!foundLine) {
                        GuiAllocationHelper line2 = new GuiAllocationHelper();
                        module3.setX(0);
                        line2.width = module3.guiWidth();
                        line2.maxHeight = module3.guiHeight();
                        line2.modules.add(module3);
                        lines.add(line2);
                    }
                    module3.setGuiDataStart(guidata);
                    guidata += module3.numberOfGuiData();
                    if (module3.hasSlots()) {
                        slots = module3.generateSlots(slots);
                    }
                }
                module3.setPacketStart(packets);
                packets += module3.totalNumberOfPackets();
            }
            boolean bl = false;
            for (GuiAllocationHelper line3 : lines) {
                for (ModuleBase module4 : line3.modules) {
                    module4.setY((int)var6_17);
                }
                var6_17 += line3.maxHeight;
            }
            if (var6_17 > 168) {
                this.canScrollModules = true;
            }
            this.modularSpaceHeight = var6_17;
        }
        for (ModuleBase module5 : this.modules) {
            module5.init();
        }
    }

    public void remove(@NotNull Entity.RemovalReason removalReason) {
        CartEvents.CartRemovedEvent event = new CartEvents.CartRemovedEvent(this);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        if (this.level().isClientSide) {
            for (int var1 = 0; var1 < this.getContainerSize(); ++var1) {
                this.setItem(var1, ItemStack.EMPTY);
            }
        }
        super.remove(removalReason);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.onDeath();
            }
        }
        this.dropChunkLoading();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(GuiGraphics render, float partialTicks) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.renderOverlay(render, partialTicks);
            }
        }
    }

    public void updateFuel() {
        ModuleEngine engine;
        int consumption = this.getConsumption();
        if (consumption > 0 && (engine = this.getCurrentEngine()) != null) {
            engine.consumeFuel(consumption);
            if (!this.isPlaceholder && this.level().isClientSide && this.hasFuel() && !this.isDisabled()) {
                engine.smoke();
            }
        }
        if (this.hasFuel()) {
            if (!this.engineFlag) {
                this.pushX = this.temppushX;
                this.pushZ = this.temppushZ;
            }
        } else if (this.engineFlag) {
            this.temppushX = this.pushX;
            this.temppushZ = this.pushZ;
            double n = 0.0;
            this.pushZ = 0.0;
            this.pushX = 0.0;
        }
        this.setEngineBurning(this.hasFuel() && !this.isDisabled());
    }

    public boolean isEngineBurning() {
        return (Boolean)this.entityData.get(IS_BURNING);
    }

    public void setEngineBurning(boolean on) {
        this.entityData.set(IS_BURNING, (Object)on);
    }

    private ModuleEngine getCurrentEngine() {
        if (this.modules == null) {
            return null;
        }
        for (ModuleBase module : this.modules) {
            if (!module.stopEngines()) continue;
            return null;
        }
        int consumption = this.getConsumption(true);
        ArrayList<ModuleEngine> priority = new ArrayList<ModuleEngine>();
        int mostImportant = -1;
        for (ModuleEngine engine : this.engineModules) {
            if (!engine.hasFuel(consumption) || mostImportant != -1 && mostImportant < engine.getPriority()) continue;
            if (engine.getPriority() < mostImportant) {
                priority.clear();
            }
            mostImportant = engine.getPriority();
            priority.add(engine);
        }
        if (priority.size() > 0) {
            if (this.motorRotation >= priority.size()) {
                this.motorRotation = 0;
            }
            this.motorRotation = (this.motorRotation + 1) % priority.size();
            return (ModuleEngine)priority.get(this.motorRotation);
        }
        return null;
    }

    public int getConsumption() {
        return this.getConsumption(!this.isDisabled() && this.isEngineBurning());
    }

    public int getConsumption(boolean isMoving) {
        int consumption;
        int n = consumption = isMoving ? 1 : 0;
        if (this.modules != null && !this.isPlaceholder) {
            for (ModuleBase module : this.modules) {
                consumption += module.getConsumption(isMoving);
            }
        }
        return consumption;
    }

    @NotNull
    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.FURNACE;
    }

    @NotNull
    public HitResult pick(double p_19908_, float p_19909_, boolean p_19910_) {
        return super.pick(p_19908_, p_19909_, p_19910_);
    }

    public double getEyeY() {
        return this.position().y + (double)0.9f;
    }

    @NotNull
    public Item getDropItem() {
        return Items.AIR;
    }

    @Nonnull
    public ItemStack getCartItem() {
        if (this.modules != null) {
            ItemStack cart = ModuleData.createModularCart(this);
            return cart;
        }
        return ItemStack.EMPTY;
    }

    public void destroy(@NotNull DamageSource damageSource) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && this.dropOnDeath()) {
            ItemStack itemstack = this.getCartItem();
            if (this.hasCustomName()) {
                // empty if block
            }
            for (int i = 0; i < this.getContainerSize(); ++i) {
                ItemStack stack = this.getItem(i);
                if (stack.isEmpty()) continue;
                this.spawnAtLocation(stack);
            }
            this.spawnAtLocation(itemstack);
        }
    }

    public boolean dropOnDeath() {
        if (this.isPlaceholder) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (module.dropOnDeath()) continue;
                return false;
            }
        }
        return true;
    }

    public float getMaxCartSpeedOnRail() {
        float maxSpeed = super.getMaxCartSpeedOnRail();
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                float tempMax = module.getMaxSpeed();
                if (!(tempMax < maxSpeed)) continue;
                maxSpeed = tempMax;
            }
        }
        return maxSpeed;
    }

    public boolean isPoweredCart() {
        return this.engineModules.size() > 0;
    }

    public int getDefaultDisplayTileData() {
        return -1;
    }

    public float[] getColor() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                float[] color = module.getColor();
                if (color[0] == 1.0f && color[1] == 1.0f && color[2] == 1.0f) continue;
                return color;
            }
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public int getYTarget() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                int yTarget = module.getYTarget();
                if (yTarget == -1) continue;
                return yTarget;
            }
        }
        return this.y();
    }

    public ModuleBase getInterfaceThief() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                if (!module.doStealInterface()) continue;
                return module;
            }
        }
        return null;
    }

    public boolean hurt(@NotNull DamageSource dmg, float par2) {
        if (this.isPlaceholder) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                if (module.receiveDamage(dmg, par2)) continue;
                return false;
            }
        }
        return super.hurt(dmg, par2);
    }

    public boolean isPushable() {
        return true;
    }

    public void activateMinecart(int x, int y, int z, boolean active) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.activatedByRail(x, y, z, active);
            }
        }
    }

    public void moveMinecartOnRail(@NotNull BlockPos pos) {
        boolean forceUnDisable;
        BlockState blockState;
        RailShape railDirection;
        super.moveMinecartOnRail(pos);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.moveMinecartOnRail(pos);
            }
        }
        boolean bl = this.cornerFlip = ((railDirection = ((BaseRailBlock)(blockState = this.level().getBlockState(pos)).getBlock()).getRailDirection(blockState, (BlockGetter)this.level(), pos, (AbstractMinecart)this)) == RailShape.SOUTH_EAST || railDirection == RailShape.SOUTH_WEST) && this.getDeltaMovement().x < 0.0 || (railDirection == RailShape.NORTH_EAST || railDirection == RailShape.NORTH_WEST) && this.getDeltaMovement().x > 0.0;
        if (blockState.getBlock() != ModBlocks.ADVANCED_DETECTOR.get() && this.isDisabled()) {
            this.releaseCart();
        }
        boolean canBeDisabled = blockState.getBlock() == ModBlocks.ADVANCED_DETECTOR.get();
        boolean bl2 = forceUnDisable = this.wasDisabled && this.disabledPos != null && this.disabledPos.equals((Object)pos);
        if (!forceUnDisable && this.wasDisabled) {
            this.wasDisabled = false;
        }
        boolean bl3 = canBeDisabled = !forceUnDisable && canBeDisabled;
        if (canBeDisabled && !this.isDisabled()) {
            this.setIsDisabled(true);
            if (this.pushX != 0.0 || this.pushZ != 0.0) {
                this.temppushX = this.pushX;
                this.temppushZ = this.pushZ;
                double n = 0.0;
                this.pushZ = 0.0;
                this.pushX = 0.0;
            }
            this.disabledPos = new BlockPos((Vec3i)pos);
        }
        if (this.fixedRailPos != null && !this.fixedRailPos.equals((Object)pos)) {
            this.fixedRailDirection = null;
            this.fixedRailPos = new BlockPos(this.fixedRailPos.getX(), -1, this.fixedRailPos.getZ());
        }
    }

    public boolean isCorner(BlockPos blockPos) {
        if (this.level().getBlockState(blockPos).getBlock() == Blocks.RAIL) {
            RailShape value = (RailShape)this.level().getBlockState(blockPos).getValue((Property)RailBlock.SHAPE);
            if (value == RailShape.NORTH_EAST) {
                return true;
            }
            if (value == RailShape.NORTH_WEST) {
                return true;
            }
            if (value == RailShape.SOUTH_WEST) {
                return true;
            }
            if (value == RailShape.SOUTH_EAST) {
                return true;
            }
        }
        return false;
    }

    public RailShape getRailDirection(BlockPos pos) {
        ModuleBase module;
        ModuleBase.RAILDIRECTION dir = ModuleBase.RAILDIRECTION.DEFAULT;
        Iterator<ModuleBase> iterator = this.getModules().iterator();
        while (iterator.hasNext() && (dir = (module = iterator.next()).getSpecialRailDirection(pos)) == ModuleBase.RAILDIRECTION.DEFAULT) {
        }
        if (dir == ModuleBase.RAILDIRECTION.DEFAULT) {
            return null;
        }
        int Yaw = (int)(this.getYRot() % 180.0f);
        if (Yaw < 0) {
            Yaw += 180;
        }
        boolean flag = Yaw >= 45 && Yaw <= 135;
        Vec3 motion = this.getDeltaMovement();
        if (this.fixedRailDirection == null) {
            switch (dir) {
                case FORWARD: {
                    if (flag) {
                        this.fixedRailDirection = RailShape.NORTH_SOUTH;
                        break;
                    }
                    this.fixedRailDirection = RailShape.EAST_WEST;
                    break;
                }
                case LEFT: {
                    if (flag) {
                        if (motion.z > 0.0) {
                            this.fixedRailDirection = RailShape.NORTH_EAST;
                            break;
                        }
                        if (!(motion.z <= 0.0)) break;
                        this.fixedRailDirection = RailShape.SOUTH_WEST;
                        break;
                    }
                    if (motion.x > 0.0) {
                        this.fixedRailDirection = RailShape.NORTH_WEST;
                        break;
                    }
                    if (!(motion.x < 0.0)) break;
                    this.fixedRailDirection = RailShape.SOUTH_EAST;
                    break;
                }
                case RIGHT: {
                    if (flag) {
                        if (motion.z > 0.0) {
                            this.fixedRailDirection = RailShape.NORTH_WEST;
                            break;
                        }
                        if (!(motion.z <= 0.0)) break;
                        this.fixedRailDirection = RailShape.SOUTH_EAST;
                        break;
                    }
                    if (motion.x > 0.0) {
                        this.fixedRailDirection = RailShape.SOUTH_WEST;
                        break;
                    }
                    if (!(motion.x < 0.0)) break;
                    this.fixedRailDirection = RailShape.NORTH_EAST;
                    break;
                }
                case NORTH: {
                    if (flag) {
                        if (!(motion.z > 0.0)) break;
                        this.fixedRailDirection = RailShape.NORTH_SOUTH;
                        break;
                    }
                    if (motion.x > 0.0) {
                        this.fixedRailDirection = RailShape.SOUTH_WEST;
                        break;
                    }
                    if (!(motion.x < 0.0)) break;
                    this.fixedRailDirection = RailShape.SOUTH_EAST;
                    break;
                }
            }
            if (this.fixedRailDirection == null) {
                return null;
            }
            this.fixedRailPos = new BlockPos((Vec3i)pos);
        }
        return this.fixedRailDirection;
    }

    public void resetRailDirection() {
        this.fixedRailDirection = null;
    }

    public void turnback() {
        this.pushX *= -1.0;
        this.pushZ *= -1.0;
        this.temppushX *= -1.0;
        this.temppushZ *= -1.0;
        this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, -1.0, -1.0));
    }

    public void releaseCart() {
        this.wasDisabled = true;
        this.setIsDisabled(false);
        this.pushX = this.temppushX;
        this.pushZ = this.temppushZ;
    }

    public ItemStack getPickResult() {
        return this.getCartItem();
    }

    public int getContainerSize() {
        int slotCount = 0;
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                slotCount += module.getInventorySize();
            }
        }
        return slotCount;
    }

    public boolean isEmpty() {
        return false;
    }

    @NotNull
    public ItemStack getItem(int i) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (i < module.getInventorySize()) {
                    return module.getStack(i);
                }
                i -= module.getInventorySize();
            }
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.getItem(slot);
        if (stack.isEmpty() || amount == 0) {
            return ItemStack.EMPTY;
        }
        stack = stack.split(amount);
        this.setChanged();
        return stack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        return ItemStack.EMPTY;
    }

    public void setItem(int i, @NotNull ItemStack item) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (i < module.getInventorySize()) {
                    module.setStack(i, item);
                    break;
                }
                i -= module.getInventorySize();
            }
        }
    }

    public void setChanged() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.onInventoryChanged();
            }
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    protected void moveAlongTrack(@NotNull BlockPos pos, @NotNull BlockState state) {
        Block block;
        if (!this.getPassengers().isEmpty()) {
            Entity riddenByEntity = (Entity)this.getPassengers().get(0);
            if (riddenByEntity instanceof LivingEntity) {
                float move = riddenByEntity.moveDist;
                riddenByEntity.moveDist = 0.0f;
                super.moveAlongTrack(pos, state);
                riddenByEntity.moveDist = move;
            } else {
                super.moveAlongTrack(pos, state);
            }
        } else {
            super.moveAlongTrack(pos, state);
        }
        double d2 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        Vec3 motion = this.getDeltaMovement();
        if (d2 > 1.0E-4 && motion.x * motion.x + motion.z * motion.z > 0.001) {
            d2 = Math.sqrt(d2);
            this.pushX /= d2;
            this.pushZ /= d2;
            if (this.pushX * motion.x + this.pushZ * motion.z < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                this.pushX = motion.x;
                this.pushZ = motion.z;
            }
        }
        if ((block = state.getBlock()) instanceof BlockRailAdvDetector) {
            BlockRailAdvDetector advDetector = (BlockRailAdvDetector)block;
            advDetector.onMinecartPassSC(state, this.level(), pos, this);
        }
    }

    protected void applyNaturalSlowdown() {
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        boolean bl = this.engineFlag = d0 > 1.0E-4;
        if (this.isDisabled()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        } else if (this.engineFlag) {
            d0 = Math.sqrt(d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            double d2 = this.getPushFactor();
            Vec3 vec3 = this.getDeltaMovement().multiply(0.8, 0.0, 0.8).add(this.pushX * d2, 0.0, this.pushZ * d2);
            if (this.isInWater()) {
                vec3 = vec3.scale(0.1);
            }
            this.setDeltaMovement(vec3);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.98, 0.0, 0.98));
        }
        super.applyNaturalSlowdown();
    }

    protected double getPushFactor() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                double factor = module.getPushFactor();
                if (!(factor >= 0.0)) continue;
                return factor;
            }
        }
        return 0.05;
    }

    public boolean save(@NotNull CompoundTag tagCompound) {
        super.save(tagCompound);
        if (this.name != null) {
            tagCompound.putString("cartName", this.name.getString());
        }
        tagCompound.putBoolean("engineFlag", this.engineFlag);
        tagCompound.putDouble("pushX", this.pushX);
        tagCompound.putDouble("pushZ", this.pushZ);
        tagCompound.putDouble("temppushX", this.temppushX);
        tagCompound.putDouble("temppushZ", this.temppushZ);
        tagCompound.putShort("workingTime", (short)this.workingTime);
        this.writeModulesToNbt(tagCompound);
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ModuleBase module = this.modules.get(i);
                module.writeToNBT(tagCompound, i, (HolderLookup.Provider)this.registryAccess());
            }
        }
        if (this.disabledPos != null) {
            tagCompound.put("disabled_pos", NbtUtils.writeBlockPos((BlockPos)this.disabledPos));
        }
        return true;
    }

    public void writeModulesToNbt(CompoundTag compoundTag) {
        ListTag listTag = new ListTag();
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                CompoundTag compoundTag1 = new CompoundTag();
                compoundTag1.putString(String.valueOf(i), this.modules.get(i).getModuleId().toString());
                listTag.add(i, (Tag)compoundTag1);
            }
            compoundTag.put("modules", (Tag)listTag);
        }
    }

    public void load(@NotNull CompoundTag tagCompound) {
        super.load(tagCompound);
        this.name = Component.translatable((String)tagCompound.getString("cartName"));
        this.engineFlag = tagCompound.getBoolean("engineFlag");
        this.pushX = tagCompound.getDouble("pushX");
        this.pushZ = tagCompound.getDouble("pushZ");
        this.temppushX = tagCompound.getDouble("temppushX");
        this.temppushZ = tagCompound.getDouble("temppushZ");
        this.workingTime = tagCompound.getShort("workingTime");
        this.loadModules(tagCompound);
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ModuleBase module = this.modules.get(i);
                module.readFromNBT(tagCompound, i, (HolderLookup.Provider)this.registryAccess());
            }
        }
        if (tagCompound.contains("disabled_pos")) {
            this.disabledPos = NbtUtils.readBlockPos((CompoundTag)tagCompound, (String)"disabled_pos").orElse(null);
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.entityData.get(IS_DISANABLED);
    }

    public void setIsDisabled(boolean disabled) {
        this.entityData.set(IS_DISANABLED, (Object)disabled);
    }

    public void tick() {
        if (!this.level().isClientSide) {
            this.entityDataList.forEach(EntityData::detectAndSend);
        }
        this.flipped = true;
        this.onCartUpdate();
        if (this.level().isClientSide) {
            this.updateSounds();
        }
        super.tick();
    }

    public void onCartUpdate() {
        if (this.modules != null) {
            this.updateFuel();
            for (ModuleBase module : this.modules) {
                module.update();
            }
            for (ModuleBase module : this.modules) {
                module.postUpdate();
            }
            this.work();
            this.setCurrentCartSpeedCapOnRail(this.getMaxCartSpeedOnRail());
        }
        if (this.isPlaceholder && this.keepAlive++ > 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.placeholderAsssembler.resetPlaceholder();
        }
    }

    public boolean hasFuel() {
        if (this.isDisabled()) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!module.stopEngines()) continue;
                return false;
            }
        }
        return this.hasFuelForModule();
    }

    public boolean hasFuelForModule() {
        if (this.isPlaceholder) {
            return true;
        }
        int consumption = this.getConsumption(true);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!module.hasFuel(consumption)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult interactAt(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        if (this.isPlaceholder) {
            return InteractionResult.FAIL;
        }
        if (this.modules != null && !player.isCrouching()) {
            boolean interupt = false;
            for (ModuleBase module : this.modules) {
                if (!module.onInteractFirst(player)) continue;
                interupt = true;
            }
            if (interupt) {
                return InteractionResult.SUCCESS;
            }
        }
        if (!this.level().isClientSide) {
            if (!this.isDisabled() && !this.hasPassenger((Entity)player)) {
                this.temppushX = this.getX() - player.getX();
                this.temppushZ = this.getZ() - player.getZ();
            }
            if (!this.isDisabled() && this.hasFuel() && this.pushX == 0.0 && this.pushZ == 0.0) {
                this.pushX = this.temppushX;
                this.pushZ = this.temppushZ;
            }
            ((ServerPlayer)player).openMenu((MenuProvider)this, packetBuffer -> packetBuffer.writeInt(this.getId()));
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"entity.minecart");
    }

    public void loadChunks() {
        this.updateTicket(true);
    }

    public void initChunkLoading() {
        this.updateTicket(true);
    }

    public void dropChunkLoading() {
        this.updateTicket(false);
    }

    public void updateTicket(boolean loadingEnabled) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ArrayList removed = new ArrayList();
        if (!loadingEnabled) {
            this.forcedChunks.forEach(pos -> {
                if (ForceChunkHelper.CONTROLLER.forceChunk(level2, (Entity)this, pos.x, pos.z, false, true)) {
                    removed.add(pos);
                }
            });
            this.forcedChunks.removeAll(removed);
            return;
        }
        ArrayList<ChunkPos> forcedCopy = new ArrayList<ChunkPos>(this.forcedChunks);
        Stream loadArea = ChunkPos.rangeClosed((ChunkPos)this.chunkPosition(), (int)1);
        loadArea.forEach(pos -> {
            if (forcedCopy.contains(pos)) {
                forcedCopy.remove(pos);
            } else if (ForceChunkHelper.CONTROLLER.forceChunk(level2, (Entity)this, pos.x, pos.z, true, true)) {
                this.forcedChunks.add((ChunkPos)pos);
            }
        });
        forcedCopy.forEach(pos -> {
            if (ForceChunkHelper.CONTROLLER.forceChunk(level2, (Entity)this, pos.x, pos.z, false, true)) {
                removed.add(pos);
            }
        });
        this.forcedChunks.removeAll(removed);
    }

    public void setWorker(ModuleWorker worker) {
        if (this.workingComponent != null && worker != null) {
            this.workingComponent.stopWorking();
        }
        if ((this.workingComponent = worker) == null) {
            this.setWorkingTime(0);
        }
    }

    public ModuleWorker getWorker() {
        return this.workingComponent;
    }

    public void setWorkingTime(int val) {
        this.workingTime = val;
    }

    private void work() {
        if (this.isPlaceholder) {
            return;
        }
        if (!this.level().isClientSide && this.hasFuel()) {
            if (this.workingTime <= 0) {
                ModuleWorker oldComponent = this.workingComponent;
                if (this.workingComponent != null) {
                    boolean result = this.workingComponent.work();
                    if (this.workingComponent != null && oldComponent == this.workingComponent && this.workingTime <= 0 && !this.workingComponent.preventAutoShutdown()) {
                        this.workingComponent.stopWorking();
                    }
                    if (result) {
                        this.work();
                        return;
                    }
                }
                if (this.workModules != null) {
                    for (ModuleWorker module : this.workModules) {
                        if (!module.work()) continue;
                        return;
                    }
                }
            } else {
                --this.workingTime;
            }
        }
    }

    public void handleActivator(ActivatorOption option, boolean isOrange) {
        for (ModuleBase module : this.modules) {
            if (!(module instanceof IActivatorModule)) continue;
            IActivatorModule activator = (IActivatorModule)((Object)module);
            if (!option.getModule().isAssignableFrom(module.getClass())) continue;
            if (option.shouldActivate(isOrange)) {
                activator.doActivate(option.getId());
                continue;
            }
            if (option.shouldDeactivate(isOrange)) {
                activator.doDeActivate(option.getId());
                continue;
            }
            if (!option.shouldToggle()) continue;
            if (activator.isActive(option.getId())) {
                activator.doDeActivate(option.getId());
                continue;
            }
            activator.doActivate(option.getId());
        }
    }

    public boolean getRenderFlippedYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        Vec3 motion = this.getDeltaMovement();
        if (!this.oldRender || Math.abs(yaw - this.lastRenderYaw) < 90.0f || Math.abs(yaw - this.lastRenderYaw) > 270.0f || motion.x > 0.0 && this.lastMotionX < 0.0 || motion.z > 0.0 && this.lastMotionZ < 0.0 || motion.x < 0.0 && this.lastMotionX > 0.0 || motion.z < 0.0 && this.lastMotionZ > 0.0 || this.wrongRender >= 50) {
            this.lastMotionX = motion.x;
            this.lastMotionZ = motion.z;
            this.lastRenderYaw = yaw;
            this.oldRender = true;
            this.wrongRender = 0;
            return false;
        }
        ++this.wrongRender;
        return true;
    }

    public ArrayList<Component> getLabel() {
        ArrayList<Component> label = new ArrayList<Component>();
        if (this.getModules() != null) {
            for (ModuleBase module : this.getModules()) {
                module.addToLabel(label);
            }
        }
        return label;
    }

    public int x() {
        return Mth.floor((double)this.position().x);
    }

    public int y() {
        return Mth.floor((double)this.position().y);
    }

    public int z() {
        return Mth.floor((double)this.position().z);
    }

    public BlockPos getExactPosition() {
        return this.blockPosition();
    }

    public void addItemToChest(@Nonnull ItemStack iStack) {
        TransferHandler.TransferItem(iStack, (Container)this, this.getCon(null), Slot.class, null, -1);
    }

    public void addItemToChest(@Nonnull ItemStack iStack, int start, int end) {
        TransferHandler.TransferItem(iStack, this, start, end, this.getCon(null), Slot.class, null, -1);
    }

    public void addItemToChest(@Nonnull ItemStack iStack, Class validSlot, Class invalidSlot) {
        TransferHandler.TransferItem(iStack, (Container)this, this.getCon(null), validSlot, invalidSlot, -1);
    }

    public AbstractContainerMenu getCon(Inventory playerInventory) {
        return new ContainerMinecart(0, playerInventory, this, this.dataAccess);
    }

    public void setPlaceholder(TileEntityCartAssembler assembler) {
        this.isPlaceholder = true;
        this.placeholderAsssembler = assembler;
    }

    public boolean canBeCollidedWith() {
        return !this.isPlaceholder && super.canBeCollidedWith();
    }

    private void generateModels() {
        if (this.modules != null) {
            ModuleData data;
            ArrayList<String> invalid = new ArrayList<String>();
            for (ModuleBase module : this.modules) {
                data = module.getData();
                if (!data.haveRemovedModels()) continue;
                invalid.addAll(data.getRemovedModels());
            }
            for (int i = this.modules.size() - 1; i >= 0; --i) {
                ModuleBase module;
                module = this.modules.get(i);
                data = module.getData();
                if (data == null || !data.haveModels(this.isPlaceholder)) continue;
                ArrayList<ModelCartbase> models = new ArrayList<ModelCartbase>();
                for (String str : data.getModels(this.isPlaceholder).keySet()) {
                    if (invalid.contains(str)) continue;
                    models.add(data.getModels(this.isPlaceholder).get(str));
                    invalid.add(str);
                }
                if (models.size() <= 0) continue;
                module.setModels(models);
            }
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf data) {
        if (this.moduleLoadingData == null) {
            return;
        }
        data.writeByte(this.moduleLoadingData.size());
        for (ResourceLocation b : this.moduleLoadingData) {
            data.writeResourceLocation(b);
        }
        this.entityDataList.forEach(e -> e.toBytes(data));
    }

    public void readSpawnData(RegistryFriendlyByteBuf data) {
        int length = data.readByte();
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < length; ++i) {
            list.add(data.readResourceLocation());
        }
        this.loadModulesFromNames(list);
        this.entityDataList.forEach(e -> e.fromBytes(data));
    }

    public void setScrollY(int val) {
        if (this.canScrollModules) {
            this.scrollY = val;
        }
    }

    public int getScrollY() {
        if (this.getInterfaceThief() != null) {
            return 0;
        }
        return this.scrollY;
    }

    public int getRealScrollY() {
        return (int)((float)(this.modularSpaceHeight - 168) / 198.0f * (float)this.getScrollY());
    }

    public boolean hasCreativeSupplies() {
        return this.creativeSupplies != null;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void silent() {
        this.keepSilent = 6;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateSounds() {
    }

    public Entity getCartRider() {
        return this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public SynchedEntityData getDataManager() {
        return this.entityData;
    }

    public int getNextDataWatcher() {
        ++this.base;
        return this.getDataManager().itemsById.length + this.base + 1;
    }

    public void clearContent() {
    }

    public int getTanks() {
        return this.getModuleTanks().size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.tankModules.get(tank).getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tankModules.get(tank).getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.tankModules.get(tank).isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        int amount = 0;
        FluidStack fluid = resource.copy();
        for (ModuleTank tank : this.tankModules) {
            int filled = tank.fill(fluid, action);
            amount += filled;
            fluid.shrink(filled);
            if (!fluid.isEmpty()) continue;
            break;
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack toDrain = resource.copy();
        for (ModuleTank tank : this.tankModules) {
            FluidStack fromTank = tank.drain(resource, action);
            if (fromTank.isEmpty() || !fromTank.is(toDrain.getFluid())) continue;
            toDrain.shrink(fromTank.getAmount());
        }
        return resource.copyWithAmount(resource.getAmount() - toDrain.getAmount());
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        int toDrain = maxDrain;
        FluidStack drained = FluidStack.EMPTY;
        for (ModuleTank tank : this.tankModules) {
            FluidStack fromTank = drained.isEmpty() ? tank.drain(toDrain, action) : tank.drain(drained.copyWithAmount(toDrain), action);
            if (fromTank.isEmpty() || !drained.isEmpty() && !fromTank.is(drained.getFluid())) continue;
            if (drained.isEmpty()) {
                drained = fromTank.copy();
            } else {
                drained.grow(fromTank.getAmount());
            }
            toDrain -= fromTank.getAmount();
        }
        return drained;
    }

    public void removeVehicle() {
        if (!this.level().isClientSide && !this.isRemoved()) {
            ItemEntity cartItem = new ItemEntity(this.level(), (double)this.getExactPosition().getX(), (double)this.getExactPosition().getY(), (double)this.getExactPosition().getZ(), this.getCartItem());
            this.level().addFreshEntity((Entity)cartItem);
        }
        super.removeVehicle();
    }

    @org.jetbrains.annotations.Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        this.container = new ContainerMinecart(id, inventory, this, this.dataAccess);
        return this.container;
    }

    static {
        IS_BURNING = SynchedEntityData.defineId(EntityMinecartModular.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        IS_DISANABLED = SynchedEntityData.defineId(EntityMinecartModular.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        railDirectionCoordinates = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    }
}

