/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.init.ModContainers;

public class ContainerMinecart
extends ContainerBase {
    private Inventory playerInventory;
    public HashMap<Short, Short> cache;
    public EntityMinecartModular cart;
    private final SimpleContainerData data;

    public ContainerMinecart(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (EntityMinecartModular)playerInventory.player.level().getEntity(packetBuffer.readInt()), new SimpleContainerData(1));
    }

    public ContainerMinecart(int id, Inventory playerInventory, EntityMinecartModular cart, SimpleContainerData data) {
        super((MenuType)ModContainers.CONTAINER_MINECART.get(), id);
        this.data = data;
        this.cart = cart;
        this.cartInv(cart);
        this.playerInv(playerInventory);
        this.addDataSlots((ContainerData)data);
    }

    protected void cartInv(EntityMinecartModular cart) {
        this.cart = cart;
        if (cart.getModules() != null) {
            for (ModuleBase module : cart.getModules()) {
                if (!module.hasSlots()) continue;
                ArrayList<SlotStevesCarts> slotsList = module.getSlots();
                for (SlotStevesCarts slot : slotsList) {
                    slot.x = slot.getX() + module.getX() + 1;
                    slot.y = slot.getY() + module.getY() + 1;
                    this.addSlot(slot);
                }
            }
        } else {
            for (int i = 0; i < 100; ++i) {
                this.addSlot(new Slot((Container)cart, i, -1000, -1000));
            }
        }
    }

    protected void playerInv(Inventory playerInventory) {
        this.playerInventory = playerInventory;
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + i * 9 + 9, this.offsetX() + k * 18, i * 18 + this.offsetY()));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, this.offsetX() + j * 18, 58 + this.offsetY()));
        }
    }

    protected int offsetX() {
        return 159;
    }

    protected int offsetY() {
        return 174;
    }

    public boolean stillValid(@NotNull Player playerEntity) {
        return true;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.playerInventory.player;
        if (this.cart.getModules() != null) {
            for (ModuleBase module : this.cart.getModules()) {
                module.checkGuiData(this, Collections.singletonList(player), false);
            }
        }
    }

    @Override
    public void receiveGuiData(int id, int data) {
        data &= 0xFFFF;
        if (this.cart.getModules() != null) {
            for (ModuleBase module : this.cart.getModules()) {
                if (id < module.getGuiDataStart() || id >= module.getGuiDataStart() + module.numberOfGuiData()) continue;
                module.receiveGuiData(id - module.getGuiDataStart(), (short)data);
                break;
            }
        }
    }
}

