/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis.buttons;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.helpers.ResourceHelper;

public abstract class ButtonBase {
    protected final LOCATION loc;
    protected final ModuleBase module;
    private boolean lastVisibility;
    private int currentID;
    private int moduleID;
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/buttons.png");

    public ButtonBase(ModuleBase module, LOCATION loc) {
        this.module = module;
        this.module.addButton(this);
        this.loc = loc;
    }

    public void setCurrentID(int id) {
        this.currentID = id;
    }

    public void setIdInModule(int id) {
        this.moduleID = id;
    }

    public int getIdInModule() {
        return this.moduleID;
    }

    public String toString() {
        return "";
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean hasText() {
        return false;
    }

    public boolean isVisible() {
        return false;
    }

    public final void computeOnClick(GuiMinecart gui, int mousebutton) {
    }

    public void onClientClick(int mousebutton, boolean ctrlKey, boolean shiftKey) {
    }

    public void onServerClick(Player player, int mousebutton, boolean ctrlKey, boolean shiftKey) {
    }

    public boolean handleClickOnServer() {
        return true;
    }

    private boolean useTexture() {
        return this.texture() != -1;
    }

    public int ColorCode() {
        return 0;
    }

    private boolean hasBorder() {
        return this.borderID() != -1;
    }

    public int borderID() {
        return -1;
    }

    public int texture() {
        return -1;
    }

    public int textureX() {
        return this.texture() % 21 * 12;
    }

    public int textureY() {
        return 60 + this.texture() / 21 * 12;
    }

    public void drawButtonText(GuiGraphics guiGraphics, GuiMinecart gui, ModuleBase module) {
        if (this.isVisible() && this.hasText()) {
            module.drawString(guiGraphics, gui, this.toString(), this.X() + 8, this.Y() + 7, 0xFFFFFF);
        }
    }

    public void drawButton(GuiGraphics guiGraphics, GuiMinecart gui, ModuleBase module, int x, int y) {
        boolean visibility = this.isVisible();
        if (visibility != this.lastVisibility) {
            module.buttonVisibilityChanged();
        }
        this.lastVisibility = visibility;
        ResourceHelper.bindResource(texture);
        if (!visibility) {
            return;
        }
        int sourceX = 0;
        int sourceY = 20;
        if (this.isEnabled()) {
            sourceX = 20 * (this.ColorCode() + 1);
        }
        if (module.inRect(x, y, this.getBounds())) {
            sourceY += 20;
        }
        module.drawImage(guiGraphics, gui, this.getBounds(), sourceX, sourceY);
        if (this.useTexture()) {
            module.drawImage(guiGraphics, gui, this.X() + 4, this.Y() + 4, this.textureX(), this.textureY(), 12, 12);
        }
        if (this.hasBorder()) {
            module.drawImage(guiGraphics, gui, this.getBounds(), this.borderID() * 20, 0);
        }
    }

    public int[] getBounds() {
        return new int[]{this.X(), this.Y(), 20, 20};
    }

    public int X() {
        switch (this.loc.ordinal()) {
            case 0: {
                return 15 + this.currentID * 25;
            }
            case 1: {
                return 125 + this.currentID % 6 * 25;
            }
            case 2: {
                return 306 + this.currentID % 5 * 25;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 115 + this.currentID % 7 * 25;
            }
            case 5: {
                return 400 + this.currentID % 3 * 25;
            }
            case 6: {
                return 366 + this.currentID % 5 * 25;
            }
            case 7: {
                return 111 + this.currentID % 6 * 22;
            }
        }
        return -1;
    }

    public int Y() {
        switch (this.loc.ordinal()) {
            case 0: {
                return 143;
            }
            case 1: {
                return 118 + this.currentID / 6 * 25;
            }
            case 2: {
                return 32 + this.currentID / 5 * 25;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 32 + this.currentID / 7 * 25;
            }
            case 5: {
                return 32 + this.currentID / 3 * 25;
            }
            case 6: {
                return 118 + this.currentID / 5 * 25;
            }
            case 7: {
                return 19 + this.currentID / 6 * 22;
            }
        }
        return -1;
    }

    public LOCATION getLocation() {
        return this.loc;
    }

    public int getLocationID() {
        for (int i = 0; i < LOCATION.values().length; ++i) {
            if (LOCATION.values()[i] != this.loc) continue;
            return i;
        }
        return 0;
    }

    public static enum LOCATION {
        OVERVIEW,
        PROGRAM,
        TASK,
        DEFINED,
        FLOATING,
        VARIABLE,
        BUILD,
        MODEL;

    }
}

