/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.api.modules;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.i18n.FMLTranslations;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.client.guis.buttons.ButtonBase;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.ButtonComparator;
import vswe.stevescarts.helpers.SimulationInfo;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.network.PacketHandler;
import vswe.stevescarts.network.packets.PacketGuiData;
import vswe.stevescarts.network.packets.PacketMinecartButton;
import vswe.stevescarts.polylib.NBTHelper;

public abstract class ModuleBase {
    private final EntityMinecartModular cart;
    @Nonnull
    private final NonNullList<ItemStack> cargo;
    private int offSetX;
    private int offSetY;
    private int guiDataOffset;
    private int packetOffset;
    private ArrayList<ButtonBase> buttons;
    protected int slotGlobalStart;
    private ResourceLocation moduleId;
    private ArrayList<ModelCartbase> models;
    protected ArrayList<SlotStevesCarts> slotList;
    private int moduleButtonId = 0;

    public ModuleBase(EntityMinecartModular cart) {
        this.cart = cart;
        this.cargo = NonNullList.withSize((int)this.getInventorySize(), (Object)ItemStack.EMPTY);
    }

    public void init() {
        if (this.useButtons()) {
            this.buttons = new ArrayList();
            this.loadButtons();
            this.buttonVisibilityChanged();
        }
    }

    public void preInit() {
    }

    public EntityMinecartModular getCart() {
        return this.cart;
    }

    public boolean isPlaceholder() {
        return this.getCart().isPlaceholder;
    }

    protected SimulationInfo getSimInfo() {
        return this.getCart().placeholderAsssembler.getSimulationInfo();
    }

    public void setModuleId(ResourceLocation val) {
        this.moduleId = val;
    }

    public ResourceLocation getModuleId() {
        return this.moduleId;
    }

    public void onInventoryChanged() {
    }

    public int getX() {
        if (this.doStealInterface()) {
            return 0;
        }
        return this.offSetX;
    }

    public int getY() {
        if (this.doStealInterface()) {
            return 0;
        }
        return this.offSetY;
    }

    public void setX(int val) {
        this.offSetX = val;
    }

    public void setY(int val) {
        this.offSetY = val;
    }

    public int getInventorySize() {
        if (!this.hasSlots()) {
            return 0;
        }
        return this.getInventoryWidth() * this.getInventoryHeight();
    }

    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    public int guiHeight() {
        return 27 + this.getInventoryHeight() * 18;
    }

    protected int getInventoryWidth() {
        return 3;
    }

    protected int getInventoryHeight() {
        return 1;
    }

    public void keyPress(GuiMinecart gui, int id, int extraInformation) {
    }

    public ArrayList<SlotStevesCarts> getSlots() {
        return this.slotList;
    }

    public int generateSlots(int slotCount) {
        this.slotGlobalStart = slotCount;
        this.slotList = new ArrayList();
        for (int j = 0; j < this.getInventoryHeight(); ++j) {
            for (int i = 0; i < this.getInventoryWidth(); ++i) {
                this.slotList.add(this.getSlot(slotCount++, i, j));
            }
        }
        return slotCount;
    }

    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return null;
    }

    public boolean hasSlots() {
        return this.hasGui();
    }

    public void update() {
    }

    public boolean hasFuel(int consumption) {
        return false;
    }

    public float getMaxSpeed() {
        return 1.1f;
    }

    public int getYTarget() {
        return Integer.MIN_VALUE;
    }

    public void moveMinecartOnRail(BlockPos pos) {
    }

    @Nonnull
    public ItemStack getStack(int slot) {
        return (ItemStack)this.cargo.get(slot);
    }

    public void setStack(int slot, @Nonnull ItemStack item) {
        this.cargo.set(slot, (Object)item);
    }

    public void addStack(int slotStart, int slotEnd, @Nonnull ItemStack item) {
        this.getCart().addItemToChest(item, this.slotGlobalStart + slotStart, this.slotGlobalStart + slotEnd);
    }

    public void addStack(int slot, @Nonnull ItemStack item) {
        this.addStack(slot, slot, item);
    }

    public boolean dropOnDeath() {
        return true;
    }

    public void onDeath() {
    }

    public boolean hasGui() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawString(GuiGraphics guiGraphics, GuiMinecart gui, String str, int[] rect, int c) {
        if (rect.length < 4) {
            return;
        }
        int n = rect[0] + (rect[2] - Minecraft.getInstance().font.width(str)) / 2;
        int n2 = rect[1];
        int n3 = rect[3];
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.drawString(guiGraphics, gui, str, n, n2 + (n3 - 9 + 3) / 2, c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawString(GuiGraphics guiGraphics, GuiMinecart gui, String str, int x, int y, int c) {
        this.drawString(guiGraphics, gui, str, x, y, -1, false, c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawString(GuiGraphics guiGraphics, GuiMinecart gui, String str, int x, int y, int w, boolean center, int c) {
        Minecraft mc = Minecraft.getInstance();
        int left = gui.getGuiLeft();
        int top = gui.getGuiTop();
        int[] rect = new int[]{x, y, w, 8};
        boolean stealInterface = this.doStealInterface();
        int dif = 0;
        if (!stealInterface) {
            dif = this.handleScroll(rect);
        }
        if (rect[3] > 0) {
            if (!stealInterface) {
                gui.pushScissor();
            }
            if (center) {
                guiGraphics.drawString(mc.font, str, rect[0] + (rect[2] - Minecraft.getInstance().font.width(str)) / 2 + this.getX() + left, rect[1] + this.getY() + dif + top, c);
            } else {
                guiGraphics.drawString(mc.font, str, rect[0] + this.getX() + left, rect[1] + this.getY() + dif + top, 0xFFFFFF);
            }
            if (!stealInterface) {
                gui.popScissor();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawStringWithShadow(GuiGraphics guiGraphics, GuiMinecart gui, String str, int x, int y, int c) {
        int j = gui.getGuiLeft();
        int k = gui.getGuiTop();
        int[] rect = new int[]{x, y, 0, 8};
        if (!this.doStealInterface()) {
            this.handleScroll(rect);
        }
        if (rect[3] == 8) {
            guiGraphics.drawString(Minecraft.getInstance().font, str, rect[0] + this.getX(), rect[1] + this.getY(), c);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawSplitString(GuiGraphics guiGraphics, GuiMinecart gui, String str, int x, int y, int w, int c) {
        this.drawSplitString(guiGraphics, gui, str, x, y, w, false, c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawSplitString(GuiGraphics guiGraphics, GuiMinecart gui, String str, int x, int y, int w, boolean center, int c) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawItemInInterface(GuiGraphics guiGraphics, GuiMinecart gui, @Nonnull ItemStack item, int x, int y) {
        int[] rect = new int[]{x, y, 16, 16};
        this.handleScroll(rect);
        if (rect[3] == 16) {
            guiGraphics.renderItem(item, gui.getGuiLeft() + rect[0] + this.getX(), gui.getGuiTop() + rect[1] + this.getY());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiGraphics guiGraphics, GuiMinecart gui, int targetX, int targetY, int srcX, int srcY, int sizeX, int sizeY) {
        this.drawImage(guiGraphics, gui, targetX, targetY, srcX, srcY, sizeX, sizeY, GuiMinecart.RENDER_ROTATION.NORMAL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiGraphics guiGraphics, GuiMinecart gui, int targetX, int targetY, int srcX, int srcY, int sizeX, int sizeY, GuiMinecart.RENDER_ROTATION rotation) {
        this.drawImage(guiGraphics, gui, new int[]{targetX, targetY, sizeX, sizeY}, srcX, srcY, rotation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiGraphics guiGraphics, GuiMinecart gui, int[] rect, int srcX, int srcY) {
        this.drawImage(guiGraphics, gui, rect, srcX, srcY, GuiMinecart.RENDER_ROTATION.NORMAL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiGraphics guiGraphics, GuiMinecart gui, int[] rect, int srcX, int srcY, GuiMinecart.RENDER_ROTATION rotation) {
        if (rect.length < 4) {
            return;
        }
        rect = this.cloneRect(rect);
        if (!this.doStealInterface()) {
            srcY -= this.handleScroll(rect);
        }
        if (rect[3] > 0) {
            gui.drawTexturedModalRect(guiGraphics, gui.getGuiLeft() + rect[0] + this.getX(), gui.getGuiTop() + rect[1] + this.getY(), srcX, srcY, rect[2], rect[3], rotation);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiGraphics guiGraphics, GuiMinecart gui, TextureAtlasSprite icon, int targetX, int targetY, int sizeX, int sizeY) {
        this.drawImage(guiGraphics, gui, icon, new int[]{targetX, targetY, sizeX, sizeY});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiGraphics guiGraphics, GuiMinecart gui, TextureAtlasSprite icon, int[] rect) {
        if (rect.length < 4) {
            return;
        }
        rect = this.cloneRect(rect);
        if (!this.doStealInterface()) {
            this.handleScroll(rect);
        }
        if (rect[3] > 0) {
            guiGraphics.blit(gui.getGuiLeft() + rect[0] + this.getX(), gui.getGuiTop() + rect[1] + this.getY(), 0, rect[2], rect[3], icon);
        }
    }

    public int handleScroll(int[] rect) {
        rect[1] = rect[1] - this.getCart().getRealScrollY();
        int y = rect[1] + this.getY();
        if (y < 4) {
            int dif = y - 4;
            rect[3] = rect[3] + dif;
            y = 4;
            rect[1] = y - this.getY();
            return dif;
        }
        if (y + rect[3] > 168) {
            rect[3] = Math.max(0, 168 - y);
            return 0;
        }
        return 0;
    }

    protected int[] cloneRect(int[] rect) {
        return new int[]{rect[0], rect[1], rect[2], rect[3]};
    }

    public boolean useButtons() {
        return false;
    }

    public final void buttonVisibilityChanged() {
        this.buttons.sort(ButtonComparator.INSTANCE);
        ButtonBase.LOCATION lastLoc = null;
        int id = 0;
        for (ButtonBase button : this.buttons) {
            if (!button.isVisible()) continue;
            if (lastLoc != null && button.getLocation() != lastLoc) {
                id = 0;
            }
            lastLoc = button.getLocation();
            button.setCurrentID(id);
            ++id;
        }
    }

    public RAILDIRECTION getSpecialRailDirection(BlockPos pos) {
        return RAILDIRECTION.DEFAULT;
    }

    protected void loadButtons() {
    }

    public final void addButton(ButtonBase button) {
        button.setIdInModule(this.moduleButtonId++);
        this.buttons.add(button);
    }

    public String generateNBTName(String name, int id) {
        return "module" + id + name;
    }

    public final void writeToNBT(CompoundTag tagCompound, int id, @NotNull HolderLookup.Provider provider) {
        if (this.getInventorySize() > 0) {
            ListTag items = new ListTag();
            for (int i = 0; i < this.getInventorySize(); ++i) {
                ItemStack stack = this.getStack(i);
                if (stack.isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.putByte("Slot", (byte)i);
                items.add((Object)stack.save(provider, (Tag)itemTag));
            }
            tagCompound.put(this.generateNBTName("Items", id), (Tag)items);
        }
        this.save(tagCompound, id, provider);
    }

    protected void save(CompoundTag tagCompound, int id, @NotNull HolderLookup.Provider provider) {
    }

    public final void readFromNBT(CompoundTag tagCompound, int id, @NotNull HolderLookup.Provider provider) {
        if (this.getInventorySize() > 0) {
            ListTag items = tagCompound.getList(this.generateNBTName("Items", id), NBTHelper.COMPOUND.getId());
            for (int i = 0; i < items.size(); ++i) {
                CompoundTag item = items.getCompound(i);
                int slot = item.getByte("Slot") & 0xFF;
                if (slot < 0 || slot >= this.getInventorySize()) continue;
                this.setStack(slot, ItemStack.parse((HolderLookup.Provider)provider, (Tag)item).orElse(ItemStack.EMPTY));
            }
        }
        this.load(tagCompound, id, provider);
    }

    protected void load(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawButtonText(GuiGraphics guiGraphics, GuiMinecart gui) {
        for (ButtonBase button : this.buttons) {
            button.drawButtonText(guiGraphics, gui, this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawButtons(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        for (ButtonBase button : this.buttons) {
            button.drawButton(guiGraphics, gui, this, x, y);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawButtonOverlays(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        for (ButtonBase button : this.buttons) {
            if (!button.isVisible()) continue;
            this.drawStringOnMouseOver(guiGraphics, gui, button.toString(), x, y, button.getBounds());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void mouseClickedButton(GuiMinecart gui, int x, int y, int mousebutton) {
        for (ButtonBase button : this.buttons) {
            if (!this.inRect(x, y, button.getBounds())) continue;
            button.computeOnClick(gui, mousebutton);
        }
    }

    public void sendButtonPacket(ButtonBase button, byte clickinfo) {
        byte id = (byte)button.getIdInModule();
        this.sendPacket(this.totalNumberOfPackets() - 1, new byte[]{id, clickinfo});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBackgroundItems(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseReleased(GuiMinecart gui, int x, int y, int button) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseMoved(GuiMinecart gui, int x, int y) {
    }

    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
    }

    protected boolean inRect(int x, int y, int x1, int y1, int sizeX, int sizeY) {
        return this.inRect(x, y, new int[]{x1, y1, sizeX, sizeY});
    }

    public boolean inRect(int x, int y, int[] rect) {
        if (rect.length < 4) {
            return false;
        }
        rect = this.cloneRect(rect);
        if (!this.doStealInterface()) {
            this.handleScroll(rect);
        }
        return rect[3] > 0 && x >= rect[0] && x <= rect[0] + rect[2] && y >= rect[1] && y <= rect[1] + rect[3];
    }

    public boolean receiveDamage(DamageSource source, float val) {
        return true;
    }

    protected void turnback() {
        for (ModuleBase module : this.getCart().getModules()) {
            if (module == this || !module.preventTurnback()) continue;
            return;
        }
        this.getCart().turnback();
    }

    protected boolean preventTurnback() {
        return false;
    }

    public final int totalNumberOfPackets() {
        return this.numberOfPackets() + (this.useButtons() ? 1 : 0);
    }

    protected int numberOfPackets() {
        return 0;
    }

    public int getPacketStart() {
        return this.packetOffset;
    }

    public void setPacketStart(int val) {
        this.packetOffset = val;
    }

    protected void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    public void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        PacketHandler.sendToServer(new PacketMinecartButton(this.cart.getId(), this.getPacketStart() + id, data));
    }

    protected void sendPacket(int id, Player player) {
        this.sendPacket(id, new byte[0], player);
    }

    protected void sendPacket(int id, byte data, Player player) {
        this.sendPacket(id, new byte[]{data}, player);
    }

    protected void sendPacket(int id, byte[] data, Player player) {
        if (player instanceof ServerPlayer) {
            PacketHandler.sendTo(new PacketMinecartButton(this.cart.getId(), this.getPacketStart() + id, data), (ServerPlayer)player);
        }
    }

    protected void receivePacket(int id, byte[] data, Player player) {
    }

    public final void delegateReceivedPacket(int id, byte[] data, Player player) {
        if (id < 0) {
            return;
        }
        if (id == this.totalNumberOfPackets() - 1 && this.useButtons()) {
            int buttonId = data[0];
            if (buttonId < 0) {
                buttonId += 256;
            }
            for (ButtonBase button : this.buttons) {
                if (button.getIdInModule() != buttonId) continue;
                byte buttoninformation = data[1];
                boolean isCtrlDown = (buttoninformation & 0x40) != 0;
                boolean isShiftDown = (buttoninformation & 0x80) != 0;
                int mousebutton = buttoninformation & 0x3F;
                if (button.isVisible() && button.isEnabled()) {
                    button.onServerClick(player, mousebutton, isCtrlDown, isShiftDown);
                }
                break;
            }
        } else {
            this.receivePacket(id, data, player);
        }
    }

    public int numberOfGuiData() {
        return 0;
    }

    public int getGuiDataStart() {
        return this.guiDataOffset;
    }

    public void setGuiDataStart(int val) {
        this.guiDataOffset = val;
    }

    private void updateGuiData(AbstractContainerMenu con, List<Player> players, int id, short data) {
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendTo(new PacketGuiData(con.containerId, id, data), serverPlayer);
        }
    }

    @Deprecated
    public final void updateGuiData(Object[] info, int id, short data) {
        this.updateGuiData((AbstractContainerMenu)info[0], (List)info[1], (Boolean)info[2], id, data);
    }

    public final void updateGuiData(AbstractContainerMenu containerMenu, List<Player> players, boolean isNew, int id, short data) {
        if (!(containerMenu instanceof ContainerMinecart)) {
            return;
        }
        ContainerMinecart con = (ContainerMinecart)containerMenu;
        int globalId = id + this.getGuiDataStart();
        if (!isNew) {
            Short val;
            isNew = con.cache != null ? (val = con.cache.get((short)globalId)) == null || val != data : true;
        }
        if (isNew) {
            if (con.cache == null) {
                con.cache = new HashMap();
            }
            this.updateGuiData(con, players, globalId, data);
            con.cache.put((short)globalId, data);
        }
    }

    public final void initGuiData(AbstractContainerMenu con, ContainerListener player) {
        ArrayList<Player> players = new ArrayList<Player>();
        players.add((Player)player);
        this.checkGuiData(con, players, true);
    }

    @Deprecated
    protected void checkGuiData(Object[] info) {
    }

    protected void doGuiDataCheck(AbstractContainerMenu con, List<Player> players, boolean isNew) {
        this.checkGuiData(new Object[]{con, players, isNew});
    }

    public final void checkGuiData(AbstractContainerMenu con, List<Player> players, boolean isNew) {
        if (con == null) {
            return;
        }
        this.doGuiDataCheck(con, players, isNew);
    }

    public void receiveGuiData(int id, short data) {
    }

    public int getConsumption(boolean isMoving) {
        return 0;
    }

    public void setModels(ArrayList<ModelCartbase> models) {
        this.models = models;
    }

    public ArrayList<ModelCartbase> getModels() {
        return this.models;
    }

    public boolean haveModels() {
        return this.models != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawStringOnMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, String str, int x, int y, int x1, int y1, int w, int h) {
        this.drawStringOnMouseOver(guiGraphics, gui, str, x, y, new int[]{x1, y1, w, h});
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void drawStringOnMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, String str, int x, int y, int[] rect) {
        if (!this.inRect(x, y, rect)) {
            return;
        }
        gui.drawMouseOver(guiGraphics, str, x += this.getX(), y += this.getY());
    }

    protected void drawImage(int[] rect, int sourceX, int sourceY) {
        this.drawImage(rect[0], rect[1], sourceX, sourceY, rect[2], rect[3]);
    }

    protected void drawImage(int targetX, int targetY, int sourceX, int sourceY, int width, int height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex((float)targetX, (float)(targetY + height), -90.0f).setUv((float)sourceX * 0.00390625f, (float)(sourceY + height) * 0.00390625f);
        bufferbuilder.addVertex((float)(targetX + width), (float)(targetY + height), -90.0f).setUv((float)(sourceX + width) * 0.00390625f, (float)(sourceY + height) * 0.00390625f);
        bufferbuilder.addVertex((float)(targetX + width), (float)targetY, -90.0f).setUv((float)(sourceX + width) * 0.00390625f, (float)sourceY * 0.00390625f);
        bufferbuilder.addVertex((float)targetX, (float)targetY, -90.0f).setUv((float)sourceX * 0.00390625f, (float)sourceY * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getClientPlayer() {
        if (Minecraft.getInstance() != null) {
            return Minecraft.getInstance().player;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(GuiGraphics render, float partialTicks) {
    }

    public boolean stopEngines() {
        return false;
    }

    public boolean shouldCartRender() {
        return true;
    }

    public double getPushFactor() {
        return -1.0;
    }

    public float[] getColor() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public float mountedOffset(Entity rider) {
        return 0.0f;
    }

    protected boolean countsAsAir(BlockPos pos) {
        if (this.getCart().level().getBlockState(pos).isAir()) {
            return true;
        }
        Block b = this.getCart().level().getBlockState(pos).getBlock();
        return b instanceof SnowLayerBlock || b instanceof FlowerBlock || b instanceof VineBlock;
    }

    public void activatedByRail(int x, int y, int z, boolean active) {
    }

    public ModuleData getData() {
        return StevesCartsAPI.MODULE_REGISTRY.get(this.getModuleId());
    }

    public boolean doStealInterface() {
        return false;
    }

    public boolean hasExtraData() {
        return false;
    }

    public CompoundTag writeExtraData() {
        return new CompoundTag();
    }

    public void readExtraData(CompoundTag nbt) {
    }

    protected FakePlayer getFakePlayer() {
        return FakePlayerFactory.get((ServerLevel)((ServerLevel)this.getCart().level()), (GameProfile)StevesCarts.FAKE_PLAYER);
    }

    public boolean disableStandardKeyFunctionality() {
        return false;
    }

    public void addToLabel(ArrayList<Component> label) {
    }

    public boolean onInteractFirst(Player entityplayer) {
        return false;
    }

    public void postUpdate() {
    }

    public String getModuleName() {
        return FMLTranslations.parseMessage((String)("item.stevescarts." + StevesCartsAPI.MODULE_REGISTRY.get(this.getModuleId()).getRawName()), (Object[])new Object[0]);
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)ModItems.MODULES.get(this.getData()).get());
    }

    public static enum RAILDIRECTION {
        DEFAULT,
        NORTH,
        WEST,
        SOUTH,
        EAST,
        LEFT,
        FORWARD,
        RIGHT;

    }
}

