/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.util;

import at.ridgo8.moreoverlays.MoreOverlays;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;

public final class ReflectionUtil {
    public static <T> Stream<T> findFieldsWithClass(Object object, Class<? extends T> fieldClass) {
        return ReflectionUtil.getAllFields(object).filter(field -> fieldClass.isAssignableFrom(field.getType())).mapMulti((field, mapper) -> {
            try {
                field.setAccessible(true);
                Object fieldValue = field.get(object);
                if (fieldClass.isInstance(fieldValue)) {
                    Object cast = fieldClass.cast(fieldValue);
                    mapper.accept(cast);
                }
            }
            catch (IllegalAccessException | SecurityException | InaccessibleObjectException e) {
                MoreOverlays.logger.error("Something went wrong. Failed to get field " + String.valueOf(fieldClass), (Throwable)e);
            }
        });
    }

    private static Stream<Field> getAllFields(Object object) {
        ArrayList classes = new ArrayList();
        for (Class<?> objectClass = object.getClass(); objectClass != Object.class; objectClass = objectClass.getSuperclass()) {
            classes.add(objectClass);
        }
        return classes.stream().flatMap(c -> {
            try {
                Field[] fields = c.getDeclaredFields();
                return Arrays.stream(fields);
            }
            catch (SecurityException e) {
                MoreOverlays.logger.error("Something went wrong. Failed to get fields on " + String.valueOf(c), (Throwable)e);
                return Stream.of(new Field[0]);
            }
        });
    }
}

