/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics.functions;

import com.google.common.base.Preconditions;
import org.simmetrics.metrics.functions.Gap;

public final class AffineGap
implements Gap {
    private final float startValue;
    private final float gapValue;

    public AffineGap(float startValue, float gapValue) {
        Preconditions.checkArgument((startValue <= 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((gapValue <= 0.0f ? 1 : 0) != 0);
        this.startValue = startValue;
        this.gapValue = gapValue;
    }

    @Override
    public final float value(int fromIndex, int toIndex) {
        Preconditions.checkArgument((fromIndex < toIndex ? 1 : 0) != 0, (Object)"fromIndex must be before toIndex");
        return this.startValue + this.gapValue * (float)(toIndex - fromIndex - 1);
    }

    @Override
    public final float max() {
        return this.startValue;
    }

    @Override
    public final float min() {
        return Float.NEGATIVE_INFINITY;
    }

    public String toString() {
        return "AffineGap [startValue=" + this.startValue + ", gapValue=" + this.gapValue + "]";
    }
}

