/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.block.BufferBlock;
import ca.teamdman.sfm.common.block.BufferBlockTier;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BufferBlockEntityContents {
    private final Map<ResourceType<?, ?, ?>, Object> contents = new HashMap();
    public final BufferBlockTier tier;
    public BufferBlock.ContainedResource lastUsedResource = BufferBlock.ContainedResource.Unknown;

    public BufferBlockEntityContents(BufferBlockTier tier) {
        this.tier = tier;
    }

    public <CAP> SFMBlockCapabilityResult<CAP> getCapability(ResourceType<?, ?, CAP> type) {
        @Nullable Object handler = this.contents.get(type);
        if (handler != null) {
            if (!type.isHandlerEmpty(handler)) {
                return SFMBlockCapabilityResult.of(handler);
            }
            if (this.isEmpty()) {
                return SFMBlockCapabilityResult.of(handler);
            }
            return SFMBlockCapabilityResult.empty();
        }
        if (!this.isEmpty()) {
            return SFMBlockCapabilityResult.empty();
        }
        handler = type.createHandlerForBufferBlock(this);
        this.contents.put(type, handler);
        return SFMBlockCapabilityResult.of(handler);
    }

    public boolean isEmpty() {
        for (Map.Entry<ResourceType<?, ?, ?>, Object> entry : this.contents.entrySet()) {
            if (this.isHandlerEmpty(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public BufferBlock.ContainedResource getBlockIconType() {
        for (Map.Entry<ResourceType<?, ?, ?>, Object> entry : this.contents.entrySet()) {
            Object cap;
            ResourceType<?, ?, ?> resourceType = entry.getKey();
            boolean handlerEmpty = this.isHandlerEmpty(resourceType, cap = entry.getValue());
            if (handlerEmpty) continue;
            return BufferBlock.ContainedResource.from(resourceType);
        }
        return BufferBlock.ContainedResource.Unknown;
    }

    public boolean allowInsertion(ResourceType<?, ?, ?> queryType) {
        for (Map.Entry<ResourceType<?, ?, ?>, Object> entry : this.contents.entrySet()) {
            Object entryHandler;
            ResourceType<?, ?, ?> entryType = entry.getKey();
            boolean handlerEmpty = this.isHandlerEmpty(entryType, entryHandler = entry.getValue());
            if (handlerEmpty) continue;
            return entryType.equals(queryType);
        }
        return true;
    }

    private <STACK, ITEM, CAP> boolean isHandlerEmpty(ResourceType<STACK, ITEM, CAP> type, CAP handler) {
        return type.isHandlerEmpty(handler);
    }
}

