/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.IPacketHandler;
import org.cyclops.cyclopscore.network.PacketCodec;

public abstract class PlayerPositionPacketCommon<T extends PlayerPositionPacketCommon<T>>
extends PacketCodec<T> {
    private static final int DEFAULT_RANGE = 3000;
    @CodecField
    protected String uuid;
    @CodecField
    protected Vec3 position = new Vec3(0.0, 0.0, 0.0);
    @CodecField
    private int range = 3000;

    public PlayerPositionPacketCommon(CustomPacketPayload.Type<T> type) {
        super(type);
    }

    public PlayerPositionPacketCommon(CustomPacketPayload.Type<T> type, Player player) {
        this(type, player, 3000);
    }

    public PlayerPositionPacketCommon(CustomPacketPayload.Type<T> type, Player player, int range) {
        super(type);
        this.uuid = player.getUUID().toString();
        this.position = player.position();
        this.range = range;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public void actionClient(net.minecraft.world.level.Level level, Player player) {
        if (this.uuid == null) {
            this.getModInstance().log(Level.WARN, "Got PlayerPositionPacket with empty uuid");
            return;
        }
        try {
            UUID uuid = UUID.fromString(this.uuid);
            if (player != null && !player.getUUID().equals(uuid)) {
                player = level.getPlayerByUUID(uuid);
            }
            if (player == null) {
                this.getModInstance().log(Level.WARN, "Received PlayerPositionPacket for player with uuid '" + String.valueOf(uuid) + "', but player doesn't exist");
            } else {
                this.performClientAction(level, player);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void actionServer(net.minecraft.world.level.Level level, ServerPlayer player) {
        this.getModInstance().getPacketHandlerCommon().sendToAllAroundPoint(this.create((Player)player, this.range), IPacketHandler.createTargetPointFromEntity((Entity)player, this.range));
    }

    protected abstract PlayerPositionPacketCommon<?> create(Player var1, int var2);

    protected abstract IModBase getModInstance();

    protected abstract void performClientAction(net.minecraft.world.level.Level var1, Player var2);
}

