/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.PacketCodecs;

public class PacketCodecsNeoForge {
    public static void load() {
        PacketCodecs.addCodedAction(FluidStack.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, RegistryFriendlyByteBuf output) {
                FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)output, (Object)((FluidStack)object));
            }

            @Override
            public Object decode(RegistryFriendlyByteBuf input) {
                return FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)input);
            }
        });
        PacketCodecs.addCodedAction(DimPos.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, RegistryFriendlyByteBuf output) {
                PacketCodecs.write(output, ((DimPos)object).getLevelKey());
                PacketCodecs.write(output, ((DimPos)object).getBlockPos());
            }

            @Override
            public Object decode(RegistryFriendlyByteBuf input) {
                ResourceKey dimensionType = PacketCodecs.read(input, ResourceKey.class);
                BlockPos blockPos = PacketCodecs.read(input, BlockPos.class);
                return DimPos.of((ResourceKey<Level>)dimensionType, blockPos);
            }
        });
        PacketCodecs.addCodedAction(ItemLocation.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, RegistryFriendlyByteBuf output) {
                ItemLocation.writeToPacketBuffer((FriendlyByteBuf)output, (ItemLocation)object);
            }

            @Override
            public Object decode(RegistryFriendlyByteBuf input) {
                return ItemLocation.readFromPacketBuffer((FriendlyByteBuf)input);
            }
        });
    }
}

