/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import java.util.stream.Stream;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathStringParser;

public class NbtPathExpressionParseHandlerStringEqual
implements INbtPathExpressionParseHandler {
    private static int skipSpaces(String string, int pos) {
        while (pos < string.length() && string.charAt(pos) == ' ') {
            ++pos;
        }
        return pos;
    }

    @Override
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        int currentPos = NbtPathExpressionParseHandlerStringEqual.skipSpaces(nbtPathExpression, pos);
        if (currentPos + 1 >= nbtPathExpression.length()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        if (nbtPathExpression.charAt(currentPos) != '=' || nbtPathExpression.charAt(currentPos + 1) != '=') {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        NbtPathStringParser.StringParseResult parseResult = NbtPathStringParser.parse(nbtPathExpression, currentPos = NbtPathExpressionParseHandlerStringEqual.skipSpaces(nbtPathExpression, currentPos + 2));
        if (!parseResult.isSuccess()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        return new INbtPathExpressionParseHandler.HandleResult(new Expression(parseResult.getResult()), currentPos - pos + parseResult.getConsumed());
    }

    public static class Expression
    implements INbtPathExpression {
        private final String targetString;

        public Expression(String targetString) {
            this.targetString = targetString;
        }

        String getTargetString() {
            return this.targetString;
        }

        @Override
        public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
            return new NbtPathExpressionMatches(executionContexts.map(executionContext -> {
                Tag nbt = executionContext.getCurrentTag();
                if (nbt.getId() == 8) {
                    StringTag tag = (StringTag)nbt;
                    return new NbtPathExpressionExecutionContext((Tag)ByteTag.valueOf((byte)(this.getTargetString().equals(tag.getAsString()) ? (byte)1 : (byte)0)), (NbtPathExpressionExecutionContext)executionContext);
                }
                return new NbtPathExpressionExecutionContext((Tag)ByteTag.valueOf((byte)0), (NbtPathExpressionExecutionContext)executionContext);
            }));
        }
    }
}

