/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.Capabilities;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.IFluidHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.jetbrains.annotations.Nullable;

public class FluidHelpersNeoForge
implements IFluidHelpersNeoForge {
    @Override
    public int getBucketVolume() {
        return 1000;
    }

    @Override
    public int getAmount(FluidStack fluidStack) {
        return fluidStack.getAmount();
    }

    @Override
    public FluidStack copy(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return fluidStack.copy();
    }

    @Override
    public boolean canCompletelyFill(IFluidHandler source, IFluidHandler destination) {
        FluidStack drained = source.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        return !drained.isEmpty() && destination.fill(drained, IFluidHandler.FluidAction.SIMULATE) == drained.getAmount();
    }

    @Override
    public FluidStack getFluid(@Nullable IFluidHandler fluidHandler) {
        return fluidHandler != null ? fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) : FluidStack.EMPTY;
    }

    @Override
    public boolean hasFluid(@Nullable IFluidHandler fluidHandler) {
        return !this.getFluid(fluidHandler).isEmpty();
    }

    @Override
    public int getCapacity(@Nullable IFluidHandler fluidHandler) {
        int capacity = 0;
        if (fluidHandler != null) {
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                capacity += fluidHandler.getTankCapacity(i);
            }
        }
        return capacity;
    }

    @Override
    public Optional<IFluidHandlerItemCapacity> getFluidHandlerItemCapacity(ItemStack itemStack) {
        return Optional.ofNullable((IFluidHandlerItemCapacity)itemStack.getCapability(Capabilities.Item.FLUID_HANDLER_CAPACITY));
    }

    @Override
    public FluidStack extractFromInventory(int amount, @Nullable ItemStack blacklistedStack, @Nullable Fluid fluidWhitelist, Player player, IFluidHandler.FluidAction action) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        Wrapper<FluidStack> drained = new Wrapper<FluidStack>(FluidStack.EMPTY);
        Wrapper<Integer> amountHolder = new Wrapper<Integer>(amount);
        while (it.hasNext() && amountHolder.get() > 0) {
            ItemStack current = it.next();
            if (current == null || current == blacklistedStack || FluidUtil.getFluidHandler((ItemStack)current) == null) continue;
            FluidUtil.getFluidHandler((ItemStack)current).ifPresent(fluidHandler -> {
                FluidStack thisDrained;
                FluidStack totalFluid = this.getFluid((IFluidHandler)fluidHandler);
                if (!(totalFluid.isEmpty() || fluidWhitelist != null && totalFluid.getFluid() != fluidWhitelist || (thisDrained = fluidHandler.drain(((Integer)amountHolder.get()).intValue(), action)).isEmpty() || fluidWhitelist != null && thisDrained.getFluid() != fluidWhitelist)) {
                    if (((FluidStack)drained.get()).isEmpty()) {
                        drained.set(thisDrained);
                    } else {
                        ((FluidStack)drained.get()).setAmount(((FluidStack)drained.get()).getAmount() + thisDrained.getAmount());
                    }
                    amountHolder.set((Integer)amountHolder.get() - thisDrained.getAmount());
                }
            });
        }
        if (drained.get() != null && drained.get().getAmount() == 0) {
            drained.set(FluidStack.EMPTY);
        }
        return drained.get();
    }

    @Override
    public FluidStack extractFromItemOrInventory(int amount, ItemStack itemStack, @Nullable Player player, IFluidHandler.FluidAction action) {
        if (action.execute() && player != null && player.isCreative() && !player.level().isClientSide()) {
            action = IFluidHandler.FluidAction.SIMULATE;
        }
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        IFluidHandler.FluidAction finalAction = action;
        return FluidUtil.getFluidHandler((ItemStack)itemStack).map(fluidHandler -> {
            FluidStack otherDrained;
            FluidStack drained = fluidHandler.drain(amount, finalAction);
            if (!drained.isEmpty() && drained.getAmount() == amount) {
                return drained;
            }
            int drainedAmount = drained.isEmpty() ? 0 : drained.getAmount();
            int toDrain = amount - drainedAmount;
            FluidStack fluidStack = otherDrained = player == null ? null : this.extractFromInventory(toDrain, itemStack, this.getFluid((IFluidHandler)fluidHandler).getFluid(), player, finalAction);
            if (otherDrained == null) {
                return drained;
            }
            otherDrained.setAmount(otherDrained.getAmount() + drainedAmount);
            return otherDrained;
        }).orElse(FluidStack.EMPTY);
    }

    @Override
    public void placeOrPickUpFluid(Player player, InteractionHand hand, Level world, BlockPos blockPos, Direction side) {
        ItemStack itemStack = player.getItemInHand(hand);
        ItemStack itemStackResult = FluidHelpers.getFluidHandlerItemCapacity(itemStack).map(fluidHandler -> {
            FluidActionResult resultPlace;
            FluidActionResult resultPickUp;
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
            FluidStack drained = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if ((fluidStack.isEmpty() || fluidStack.getAmount() + 1000 <= fluidHandler.getCapacity()) && (resultPickUp = FluidUtil.tryPickUpFluid((ItemStack)itemStack, (Player)player, (Level)world, (BlockPos)blockPos, (Direction)side)).isSuccess()) {
                return resultPickUp.getResult();
            }
            if (!drained.isEmpty() && drained.getAmount() > 0 && (resultPlace = FluidUtil.tryPlaceFluid((Player)player, (Level)world, (InteractionHand)hand, (BlockPos)blockPos, (ItemStack)itemStack, (FluidStack)fluidStack)).isSuccess()) {
                return resultPlace.getResult();
            }
            return itemStack;
        }).orElse(itemStack);
        player.setItemInHand(hand, itemStackResult);
    }

    @Override
    public IFluidHandler.FluidAction simulateBooleanToAction(boolean simulate) {
        return simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
    }
}

